/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;

public class ClosePerspectiveHandler
extends AbstractHandler {
    private static final String PARAMETER_NAME_PERSPECTIVE_ID = "org.eclipse.ui.window.closePerspective.perspectiveId";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        WorkbenchPage page;
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow(event);
        if (activeWorkbenchWindow != null && (page = (WorkbenchPage)activeWorkbenchWindow.getActivePage()) != null) {
            Map parameters = event.getParameters();
            String value = (String)parameters.get(PARAMETER_NAME_PERSPECTIVE_ID);
            if (value == null) {
                page.closePerspective(page.getPerspective(), true, true);
            } else {
                IPerspectiveDescriptor perspective = activeWorkbenchWindow.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(value);
                if (perspective != null) {
                    page.closePerspective(perspective, true, true);
                }
            }
        }
        return null;
    }

    public static void closePerspective(WorkbenchPage page, Perspective persp) {
        if (page != null && persp != null) {
            page.closePerspective(persp.getDesc(), true, true);
        }
    }
}

