/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import org.rssowl.core.persist.INews;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;

public class LinkTransformer {
    private static final String URL_INPUT_TOKEN = "[L]";
    private final String fId;
    private final String fName;
    private final String fUrl;

    public LinkTransformer(String id, String name, String url) {
        this.fId = id;
        this.fName = name;
        this.fUrl = url;
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public String toTransformedUrl(INews news) {
        String link = CoreUtils.getLink((INews)news);
        return this.toTransformedUrl(link);
    }

    public String toTransformedUrl(String link) {
        if (!StringUtils.isSet((String)link)) {
            link = "";
        }
        link = URIUtils.urlEncode((String)link);
        String transformedUrl = this.fUrl;
        int linkIndex = this.fUrl.indexOf(URL_INPUT_TOKEN);
        if (linkIndex >= 0) {
            transformedUrl = StringUtils.replaceAll((String)transformedUrl, (String)URL_INPUT_TOKEN, (String)link);
        }
        return transformedUrl;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fId == null ? 0 : this.fId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkTransformer other = (LinkTransformer)obj;
        return !(this.fId == null ? other.fId != null : !this.fId.equals(other.fId));
    }
}

