/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.util.ModelUtils;

public class LabelAction
extends Action {
    private final ILabel fLabel;
    private IStructuredSelection fSelection;

    public LabelAction(ILabel label, IStructuredSelection selection) {
        super("", label != null ? 2 : 0);
        this.fLabel = label;
        this.fSelection = selection;
    }

    public String getActionDefinitionId() {
        if (this.fLabel != null) {
            return "org.rssowl.ui.LabelAction" + this.fLabel.getOrder();
        }
        return null;
    }

    public String getText() {
        if (this.fLabel == null) {
            return Messages.LabelAction_REMOVE_ALL_LABELS;
        }
        IBindingService bs = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence binding = bs.getBestActiveBindingFor("org.rssowl.ui.LabelAction" + this.fLabel.getId());
        return binding != null ? NLS.bind((String)Messages.LabelAction_LABEL_BINDING, (Object)this.fLabel.getName(), (Object)binding.format()) : this.fLabel.getName();
    }

    public boolean isEnabled() {
        return !this.fSelection.isEmpty();
    }

    public void run() {
        List<INews> newsList = ModelUtils.getEntities(this.fSelection, INews.class);
        if (newsList.isEmpty()) {
            return;
        }
        for (INews newsItem : newsList) {
            Set newsLabels = newsItem.getLabels();
            if (this.fLabel != null) {
                if (!newsLabels.contains(this.fLabel)) {
                    newsItem.addLabel(this.fLabel);
                    continue;
                }
                newsItem.removeLabel(this.fLabel);
                continue;
            }
            for (ILabel newsLabel : newsLabels) {
                newsItem.removeLabel(newsLabel);
            }
        }
        Controller.getDefault().getSavedSearchService().forceQuickUpdate();
        DynamicDAO.saveAll(newsList);
    }
}

