/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.actions.NewBookMarkAction;
import org.rssowl.ui.internal.actions.NewFolderAction;
import org.rssowl.ui.internal.actions.NewNewsBinAction;
import org.rssowl.ui.internal.actions.NewSearchMarkAction;

public class NewTypeDropdownAction
implements IWorkbenchWindowPulldownDelegate,
IMenuCreator {
    private Shell fShell;
    private Menu fMenu;
    private IFolder fParent;
    private IMark fPosition;
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private IBindingService fBindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            OwlUI.safeDispose(this.fMenu);
        }
        this.fMenu = new Menu(parent);
        MenuItem newBookMark = new MenuItem(this.fMenu, 8);
        newBookMark.setText(this.getLabelWithBinding("org.rssowl.ui.actions.NewBookMark", Messages.NewTypeDropdownAction_BOOKMARK));
        newBookMark.setImage(OwlUI.getImage((ResourceManager)this.fResources, OwlUI.BOOKMARK));
        newBookMark.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    NewTypeDropdownAction.this.addBookmark();
                }
                catch (Exception e1) {
                    Activator.getDefault().logError(e1.getMessage(), e1);
                }
            }
        });
        MenuItem newNewsBin = new MenuItem(this.fMenu, 8);
        newNewsBin.setText(this.getLabelWithBinding("org.rssowl.ui.actions.NewNewsBin", Messages.NewTypeDropdownAction_NEWSBIN));
        newNewsBin.setImage(OwlUI.getImage((ResourceManager)this.fResources, OwlUI.NEWSBIN));
        newNewsBin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    NewTypeDropdownAction.this.addNewsBin();
                }
                catch (Exception e1) {
                    Activator.getDefault().logError(e1.getMessage(), e1);
                }
            }
        });
        MenuItem newSearchMark = new MenuItem(this.fMenu, 8);
        newSearchMark.setText(this.getLabelWithBinding("org.rssowl.ui.actions.NewSearchMark", Messages.NewTypeDropdownAction_SAVED_SEARCH));
        newSearchMark.setImage(OwlUI.getImage((ResourceManager)this.fResources, OwlUI.SEARCHMARK));
        newSearchMark.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    NewTypeDropdownAction.this.addSearchMark();
                }
                catch (Exception e1) {
                    Activator.getDefault().logError(e1.getMessage(), e1);
                }
            }
        });
        new MenuItem(this.fMenu, 2);
        MenuItem newFolder = new MenuItem(this.fMenu, 8);
        newFolder.setText(this.getLabelWithBinding("org.rssowl.ui.actions.NewFolder", Messages.NewTypeDropdownAction_FOLDER));
        newFolder.setImage(OwlUI.getImage((ResourceManager)this.fResources, OwlUI.FOLDER));
        newFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    NewTypeDropdownAction.this.addFolder();
                }
                catch (Exception e1) {
                    Activator.getDefault().logError(e1.getMessage(), e1);
                }
            }
        });
        return this.fMenu;
    }

    public void dispose() {
        this.fResources.dispose();
        if (this.fMenu != null) {
            OwlUI.safeDispose(this.fMenu);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.fShell = window.getShell();
    }

    public void run(IAction action) {
        try {
            this.addBookmark();
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structSel;
        this.fParent = null;
        this.fPosition = null;
        if (selection instanceof IStructuredSelection && !(structSel = (IStructuredSelection)selection).isEmpty()) {
            Object firstElement = structSel.getFirstElement();
            if (firstElement instanceof IFolder) {
                this.fParent = (IFolder)firstElement;
            } else if (firstElement instanceof IMark) {
                this.fParent = ((IMark)firstElement).getParent();
                this.fPosition = (IMark)firstElement;
            }
        }
    }

    private void addBookmark() {
        new NewBookMarkAction(this.fShell, this.fParent, this.fPosition).run(null);
    }

    private void addNewsBin() {
        new NewNewsBinAction(this.fShell, this.fParent, this.fPosition).run(null);
    }

    private void addFolder() {
        new NewFolderAction(this.fShell, this.fParent, this.fPosition).run(null);
    }

    private void addSearchMark() {
        new NewSearchMarkAction(this.fShell, this.fParent, this.fPosition).run(null);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private String getLabelWithBinding(String id, String label) {
        TriggerSequence binding = this.fBindingService.getBestActiveBindingFor(id);
        if (binding != null) {
            return NLS.bind((String)Messages.NewTypeDropdownAction_LABEL_BINDING, (Object)label, (Object)binding.format());
        }
        return label;
    }
}

