/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.EntityGroupItem;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadTypesAction
extends Action
implements IObjectActionDelegate {
    public static final String ID = "org.rssowl.ui.actions.Reload";
    private IStructuredSelection fSelection;
    private Shell fShell;

    public ReloadTypesAction() {
        this((IStructuredSelection)StructuredSelection.EMPTY, null);
    }

    public ReloadTypesAction(IStructuredSelection selection, Shell shell) {
        Assert.isNotNull((Object)selection);
        this.fSelection = selection;
        this.fShell = shell;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    public void run() {
        FeedView activeFeedView;
        TreeSet<IBookMark> selectedBookMarks = new TreeSet<IBookMark>(new Comparator<IBookMark>(){

            @Override
            public int compare(IBookMark o1, IBookMark o2) {
                if (o1.equals(o2)) {
                    return 0;
                }
                return 1;
            }
        });
        if (this.fSelection.isEmpty() && (activeFeedView = OwlUI.getActiveFeedView()) != null) {
            FeedViewInput input = (FeedViewInput)activeFeedView.getEditorInput();
            this.fSelection = new StructuredSelection((Object)input.getMark());
        }
        List list = this.fSelection.toList();
        HashSet<FeedLinkReference> handledFeedsFromNews = new HashSet<FeedLinkReference>();
        for (Object selection : list) {
            if (selection instanceof IFolder) {
                IFolder folder = (IFolder)selection;
                this.getBookMarks(folder, selectedBookMarks);
                continue;
            }
            if (selection instanceof IBookMark) {
                IBookMark bookMark = (IBookMark)selection;
                selectedBookMarks.add(bookMark);
                continue;
            }
            if (selection instanceof INews) {
                INews news = (INews)selection;
                if (handledFeedsFromNews.contains(news.getFeedReference())) continue;
                handledFeedsFromNews.add(news.getFeedReference());
                Collection relatedBookmarks = Owl.getPersistenceService().getDAOService().getBookMarkDAO().loadAll(news.getFeedReference());
                if (relatedBookmarks.size() <= 0) continue;
                selectedBookMarks.add((IBookMark)relatedBookmarks.iterator().next());
                continue;
            }
            if (!(selection instanceof EntityGroup)) continue;
            EntityGroup group = (EntityGroup)selection;
            List<EntityGroupItem> items = group.getItems();
            for (EntityGroupItem item : items) {
                INews news;
                IEntity entity = item.getEntity();
                if (entity instanceof IBookMark) {
                    IBookMark bookMark = (IBookMark)entity;
                    selectedBookMarks.add(bookMark);
                    continue;
                }
                if (!(entity instanceof INews) || handledFeedsFromNews.contains((news = (INews)entity).getFeedReference())) continue;
                handledFeedsFromNews.add(news.getFeedReference());
                Collection relatedBookmarks = Owl.getPersistenceService().getDAOService().getBookMarkDAO().loadAll(news.getFeedReference());
                if (relatedBookmarks.size() <= 0) continue;
                selectedBookMarks.add((IBookMark)relatedBookmarks.iterator().next());
            }
        }
        Controller.getDefault().getSavedSearchService().forceQuickUpdate();
        Controller.getDefault().reloadQueued(selectedBookMarks, null, this.fShell);
    }

    private void getBookMarks(IFolder folder, Set<IBookMark> bookmarks) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            if (!(mark instanceof IBookMark)) continue;
            bookmarks.add((IBookMark)mark);
        }
        List folders = folder.getFolders();
        for (IFolder childFolder : folders) {
            this.getBookMarks(childFolder, bookmarks);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fShell = targetPart.getSite().getShell();
    }
}

