/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

public class MasterPasswordDialog
extends TitleAreaDialog {
    private final LocalResourceManager fResources;
    private Text fPassword;
    private Text fPasswordConfirmed;
    private String fPasswordValue;
    private final int fStyle;
    private ProgressBar fQualityBar;

    public MasterPasswordDialog(Shell parentShell, int style) {
        super(parentShell);
        this.fStyle = style;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    public String getMasterPassword() {
        return this.fPasswordValue;
    }

    public boolean close() {
        this.fResources.dispose();
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.fPasswordValue = this.fPassword.getText();
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if ((this.fStyle & 1) != 0) {
            shell.setText(Messages.MasterPasswordDialog_ENTER_MASTER_PASSWORD_TITLE);
        } else {
            shell.setText(Messages.MasterPasswordDialog_ENTER_MASTER_PASSWORD);
        }
    }

    public void create() {
        super.create();
        if ((this.fStyle & 1) != 0) {
            this.getButton(0).setEnabled(false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 10));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setTitle(Messages.MasterPasswordDialog_MASTER_PASSWORD);
        if ((this.fStyle & 1) != 0) {
            this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/new_value_wiz.png"));
            this.setMessage(Messages.MasterPasswordDialog_REMEMBER_PASSWORD, 2);
        } else {
            this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/login_wiz.png"));
            this.setMessage(Messages.MasterPasswordDialog_MASTER_PASSWORD_INFO, 1);
        }
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText(Messages.MasterPasswordDialog_PASSWORD);
        passwordLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.fPassword = new Text(composite, 0x400804);
        this.fPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fPassword.setFocus();
        if ((this.fStyle & 1) != 0) {
            this.fPassword.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    boolean enabled = MasterPasswordDialog.this.fPassword.getText().equals(MasterPasswordDialog.this.fPasswordConfirmed.getText()) && MasterPasswordDialog.this.fPassword.getText().length() > 0;
                    MasterPasswordDialog.this.getButton(0).setEnabled(enabled);
                    MasterPasswordDialog.this.updateQualityBar();
                }
            });
        }
        if ((this.fStyle & 1) != 0) {
            Label confirmPasswordLabel = new Label(composite, 0);
            confirmPasswordLabel.setText(Messages.MasterPasswordDialog_CONFIRM_PASSWORD);
            confirmPasswordLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
            this.fPasswordConfirmed = new Text(composite, 0x400804);
            this.fPasswordConfirmed.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.fPasswordConfirmed.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    boolean enabled = MasterPasswordDialog.this.fPassword.getText().equals(MasterPasswordDialog.this.fPasswordConfirmed.getText()) && MasterPasswordDialog.this.fPassword.getText().length() > 0;
                    MasterPasswordDialog.this.getButton(0).setEnabled(enabled);
                }
            });
            new Label(composite, 0);
            new Label(composite, 0);
            Label passwordQuality = new Label(composite, 0);
            passwordQuality.setText(Messages.MasterPasswordDialog_PASSWORD_QUALITY);
            passwordQuality.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
            this.fQualityBar = new ProgressBar(composite, 256);
            this.fQualityBar.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.fQualityBar.setMinimum(0);
            this.fQualityBar.setMaximum(100);
        }
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000008, true, true));
        MasterPasswordDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void updateQualityBar() {
        String pw = this.fPassword.getText();
        int score = 0;
        score += Math.min(20, pw.length() * 10 - 20);
        int numericsCount = 0;
        int i = 0;
        while (i < pw.length()) {
            if (Character.isDigit(pw.charAt(i))) {
                ++numericsCount;
            }
            ++i;
        }
        score += Math.min(30, numericsCount * 10);
        int symbolCount = 0;
        int i2 = 0;
        while (i2 < pw.length()) {
            if (!Character.isLetterOrDigit(pw.charAt(i2))) {
                ++symbolCount;
            }
            ++i2;
        }
        score += Math.min(45, symbolCount * 15);
        int upperCaseCount = 0;
        int i3 = 0;
        while (i3 < pw.length()) {
            if (Character.isUpperCase(pw.charAt(i3))) {
                ++upperCaseCount;
            }
            ++i3;
        }
        this.fQualityBar.setSelection(score += Math.min(30, upperCaseCount * 10));
    }

    protected int getShellStyle() {
        int style = 0x10860 | MasterPasswordDialog.getDefaultOrientation();
        return style;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        int minWidth = this.convertHorizontalDLUsToPixels(320);
        int minHeight = shell.computeSize((int)minWidth, (int)-1).y;
        Point requiredSize = shell.computeSize(-1, -1);
        shell.setSize(Math.max(minWidth, requiredSize.x), Math.max(minHeight, requiredSize.y));
        LayoutUtils.positionShell(shell);
    }
}

