/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.ContextMenuCreator;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.dialogs.SearchNewsDialog;
import org.rssowl.ui.internal.filter.NewsActionDescriptor;
import org.rssowl.ui.internal.filter.NewsActionList;
import org.rssowl.ui.internal.filter.NewsActionPresentationManager;
import org.rssowl.ui.internal.search.LocationControl;
import org.rssowl.ui.internal.search.SearchConditionList;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsFilterDialog
extends TitleAreaDialog {
    private static final String SETTINGS_SECTION = "org.rssowl.ui.internal.dialogs.NewsFilterDialog";
    private static final String SEARCHES_ACTION = "org.rssowl.ui.internal.dialogs.filter.SearchesAction";
    private static final String FILTERS_ACTION = "org.rssowl.ui.internal.dialogs.filter.FiltersAction";
    private LocalResourceManager fResources;
    private final ISearchFilter fEditedFilter;
    private final List<Integer> fExcludedConditions = this.getExcludedConditions();
    private LocationControl fLocationControl;
    private SearchConditionList fSearchConditionList;
    private NewsActionPresentationManager fNewsActionPresentationManager = NewsActionPresentationManager.getInstance();
    private Button fMatchAllRadio;
    private Button fMatchAnyRadio;
    private Button fMatchAllNewsRadio;
    private NewsActionList fFilterActionList;
    private Text fNameInput;
    private int fFilterPosition;
    private ISearch fPresetSearch;
    private boolean fPresetMatchAll;
    private List<IFilterAction> fPresetActions;
    private ISearchFilter fAddedFilter;

    public NewsFilterDialog(Shell parentShell) {
        this(parentShell, (ISearchFilter)null);
    }

    public NewsFilterDialog(Shell parentShell, ISearchFilter filter) {
        super(parentShell);
        this.fEditedFilter = filter;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    public NewsFilterDialog(Shell parentShell, ISearch presetSearch) {
        this(parentShell, presetSearch, null, false);
    }

    public NewsFilterDialog(Shell parentShell, ISearch presetSearch, List<IFilterAction> presetActions, boolean matchAll) {
        super(parentShell);
        this.fPresetSearch = presetSearch;
        this.fPresetActions = presetActions;
        this.fPresetMatchAll = matchAll;
        this.fEditedFilter = null;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    public void setFilterPosition(int filterPosition) {
        this.fFilterPosition = filterPosition;
    }

    protected void okPressed() {
        if (!StringUtils.isSet((String)this.fNameInput.getText())) {
            this.onGenerateName();
        }
        if (this.fSearchConditionList.isEmpty() && !this.fMatchAllNewsRadio.getSelection()) {
            this.setErrorMessage(Messages.NewsFilterDialog_ENTER_CONDITION);
            this.fSearchConditionList.focusInput();
            return;
        }
        if (this.fFilterActionList.isEmpty()) {
            this.setErrorMessage(Messages.NewsFilterDialog_CHOOSE_ACTION);
            this.fFilterActionList.focusInput();
            return;
        }
        List<IFilterAction> actions = this.fFilterActionList.createActions();
        if (this.isConflicting(actions)) {
            return;
        }
        if (this.fEditedFilter == null) {
            this.fAddedFilter = this.createFilter(actions);
            DynamicDAO.save((IPersistable)this.fAddedFilter);
        } else {
            this.updateFilter(actions);
            DynamicDAO.save((IPersistable)this.fEditedFilter);
        }
        super.okPressed();
    }

    public ISearchFilter getFilter() {
        return this.fEditedFilter != null ? this.fEditedFilter : this.fAddedFilter;
    }

    private ISearchFilter createFilter(List<IFilterAction> actions) {
        IModelFactory factory = Owl.getModelFactory();
        ISearch search = this.createSearch();
        ISearchFilter filter = factory.createSearchFilter(null, search, this.fNameInput.getText());
        filter.setEnabled(true);
        filter.setMatchAllNews(this.fMatchAllNewsRadio.getSelection());
        filter.setOrder(this.fFilterPosition);
        for (IFilterAction action : actions) {
            filter.addAction(action);
        }
        return filter;
    }

    private ISearch createSearch() {
        IModelFactory factory = Owl.getModelFactory();
        ISearch search = null;
        ISearchCondition locationCondition = this.fLocationControl.toScopeCondition();
        if (locationCondition != null && this.fMatchAllNewsRadio.getSelection()) {
            search = factory.createSearch(null);
            search.addSearchCondition(locationCondition);
        } else if (!this.fMatchAllNewsRadio.getSelection()) {
            List<ISearchCondition> conditions = this.fSearchConditionList.createConditions();
            if (locationCondition != null) {
                conditions.add(locationCondition);
            }
            search = factory.createSearch(null);
            search.setMatchAllConditions(this.fMatchAllRadio.getSelection());
            for (ISearchCondition condition : conditions) {
                search.addSearchCondition(condition);
            }
        }
        return search;
    }

    private void updateFilter(List<IFilterAction> actions) {
        this.fEditedFilter.setName(this.fNameInput.getText());
        if (this.fFilterActionList.isModified()) {
            List oldActions = this.fEditedFilter.getActions();
            for (IFilterAction oldAction : oldActions) {
                this.fEditedFilter.removeAction(oldAction);
            }
            for (IFilterAction action : actions) {
                this.fEditedFilter.addAction(action);
            }
        }
        this.fEditedFilter.setMatchAllNews(this.fMatchAllNewsRadio.getSelection());
        ISearch oldSearch = this.fEditedFilter.getSearch();
        this.fEditedFilter.setSearch(this.createSearch());
        if (oldSearch != null) {
            DynamicDAO.delete((IPersistable)oldSearch);
        }
    }

    private boolean isConflicting(List<IFilterAction> actions) {
        for (IFilterAction action : actions) {
            NewsActionDescriptor newsAction = this.fNewsActionPresentationManager.getNewsActionDescriptor(action.getActionId());
            for (IFilterAction otherAction : actions) {
                NewsActionDescriptor otherNewsAction;
                if (action == otherAction || !(otherNewsAction = this.fNewsActionPresentationManager.getNewsActionDescriptor(otherAction.getActionId())).getNewsAction().conflictsWith(newsAction.getNewsAction())) continue;
                StringBuilder str = new StringBuilder();
                str.append(NLS.bind((String)Messages.NewsFilterDialog_REMOVE_ACTION_N, (Object)otherNewsAction.getName(), (Object)newsAction.getName()));
                this.setErrorMessage(str.toString());
                return true;
            }
        }
        return false;
    }

    public boolean close() {
        boolean res = super.close();
        this.fResources.dispose();
        return res;
    }

    protected Control createDialogArea(Composite parent) {
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        this.setTitle(Messages.NewsFilterDialog_NEWS_FILTER);
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/filter_wiz.png"));
        this.setMessage(Messages.NewsFilterDialog_DEFINE_SEARCH);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 5, 0, 5, false));
        container.setLayoutData((Object)new GridData(4, 1, true, false));
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(Messages.NewsFilterDialog_NAME);
        Composite nameContainer = new Composite(container, 2048);
        nameContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        nameContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        nameContainer.setBackground(container.getDisplay().getSystemColor(25));
        this.fNameInput = new Text(nameContainer, 4);
        OwlUI.makeAccessible((Control)this.fNameInput, (Control)nameLabel);
        this.fNameInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        if (this.fEditedFilter != null) {
            this.fNameInput.setText(this.fEditedFilter.getName());
            this.fNameInput.selectAll();
        }
        this.fNameInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewsFilterDialog.this.setErrorMessage(null);
            }
        });
        GC gc = new GC((Drawable)this.fNameInput);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        int entryFieldWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)200);
        gc.dispose();
        ((GridData)this.fNameInput.getLayoutData()).widthHint = entryFieldWidth;
        ToolBar generateTitleBar = new ToolBar(nameContainer, 0x800000);
        OwlUI.makeAccessible((Control)generateTitleBar, Messages.NewsFilterDialog_CREATE_NAME_FROM_CONDITIONS);
        generateTitleBar.setBackground(container.getDisplay().getSystemColor(25));
        ToolItem generateTitleItem = new ToolItem(generateTitleBar, 8);
        generateTitleItem.setImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/etool16/info.gif"));
        generateTitleItem.setToolTipText(Messages.NewsFilterDialog_CREATE_NAME_FROM_CONDITIONS);
        generateTitleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsFilterDialog.this.onGenerateName();
            }
        });
        SashForm sashForm = new SashForm(parent, 66048);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite topSash = new Composite((Composite)sashForm, 0);
        topSash.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 0, false));
        this.createConditionControls(topSash);
        Composite bottomSash = new Composite((Composite)sashForm, 0);
        bottomSash.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        Composite labelContainer = new Composite(bottomSash, 0);
        labelContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 10, 3, 0, 0, false));
        ((GridLayout)labelContainer.getLayout()).marginBottom = 2;
        labelContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        Label explanationLabel = new Label(labelContainer, 0);
        explanationLabel.setText(Messages.NewsFilterDialog_PERFORM_ACTIONS);
        this.createActionControls(bottomSash);
        new Label(bottomSash, 258).setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        sashForm.setWeights(new int[]{50, 50});
        NewsFilterDialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new GridData(4, 1, true, false));
        buttonBar.setLayout((Layout)layout);
        Link previewLink = new Link(buttonBar, 0);
        previewLink.setText(Messages.NewsFilterDialog_PREVIEW_SEARCH);
        NewsFilterDialog.applyDialogFont((Control)previewLink);
        previewLink.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        previewLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsFilterDialog.this.onPreview();
            }
        });
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    private void onPreview() {
        final ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>();
        if (this.fMatchAllNewsRadio.getSelection()) {
            ISearchCondition locationCondition = this.fLocationControl.toScopeCondition();
            if (locationCondition != null) {
                locationCondition.setSpecifier(SearchSpecifier.IS);
                conditions.add(locationCondition);
            }
        } else {
            ISearchCondition locationCondition;
            conditions.addAll(this.fSearchConditionList.createConditions());
            if (!conditions.isEmpty() && (locationCondition = this.fLocationControl.toScopeCondition()) != null) {
                conditions.add(locationCondition);
            }
        }
        if (!conditions.isEmpty()) {
            JobRunner.runInUIThread((Widget)this.getShell(), new Runnable(){

                public void run() {
                    SearchNewsDialog dialog = new SearchNewsDialog(NewsFilterDialog.this.getShell(), conditions, NewsFilterDialog.this.fMatchAllRadio.getSelection(), true);
                    dialog.setBlockOnOpen(false);
                    dialog.open();
                }
            });
        }
    }

    void onGenerateName() {
        String name;
        ISearchCondition locationCondition = this.fLocationControl.toScopeCondition();
        if (this.fMatchAllNewsRadio.getSelection() && locationCondition == null) {
            name = Messages.NewsFilterDialog_ALL_NEWS;
        } else {
            List<ISearchCondition> conditions = this.fSearchConditionList.createConditions();
            if (locationCondition != null) {
                conditions.add(locationCondition);
            }
            name = CoreUtils.getName(conditions, (boolean)this.fMatchAllRadio.getSelection());
        }
        if (name.length() > 0) {
            this.fNameInput.setText(name);
            this.fNameInput.selectAll();
        }
    }

    private void createConditionControls(Composite container) {
        boolean matchAllConditions;
        Composite topControlsContainer = new Composite(container, 0);
        topControlsContainer.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        topControlsContainer.setLayout((Layout)LayoutUtils.createGridLayout(6, 10, 3));
        boolean matchAllNews = this.fEditedFilter != null ? this.fEditedFilter.matchAllNews() : this.fPresetMatchAll;
        boolean bl = matchAllConditions = !matchAllNews && this.fEditedFilter != null ? this.fEditedFilter.getSearch().matchAllConditions() : true;
        if (this.fPresetSearch != null) {
            matchAllConditions = this.fPresetSearch.matchAllConditions();
        }
        this.fMatchAllRadio = new Button(topControlsContainer, 16);
        this.fMatchAllRadio.setText(Messages.NewsFilterDialog_MATCH_ALL_CONDITIONS);
        this.fMatchAllRadio.setSelection(matchAllConditions && !matchAllNews);
        this.fMatchAnyRadio = new Button(topControlsContainer, 16);
        this.fMatchAnyRadio.setText(Messages.NewsFilterDialog_MATCH_ANY_CONDITION);
        this.fMatchAnyRadio.setSelection(!matchAllConditions && !matchAllNews);
        this.fMatchAllNewsRadio = new Button(topControlsContainer, 16);
        this.fMatchAllNewsRadio.setText(Messages.NewsFilterDialog_MATCH_ALL);
        this.fMatchAllNewsRadio.setSelection(matchAllNews);
        this.fMatchAllNewsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsFilterDialog.this.setControlEnabled((Control)NewsFilterDialog.this.fSearchConditionList, !NewsFilterDialog.this.fMatchAllNewsRadio.getSelection());
            }
        });
        Label sep = new Label(topControlsContainer, 514);
        sep.setLayoutData((Object)new GridData(-1, 16));
        Composite scopeContainer = new Composite(topControlsContainer, 0);
        scopeContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        scopeContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 5, false));
        ((GridLayout)scopeContainer.getLayout()).marginLeft = 2;
        Label locationLabel = new Label(scopeContainer, 0);
        locationLabel.setText(Messages.NewsFilterDialog_IN);
        this.fLocationControl = new LocationControl(scopeContainer, 64){

            protected String getDefaultLabel() {
                return Messages.NewsFilterDialog_ALL_NEWS;
            }
        };
        this.fLocationControl.setLayoutData(new GridData(4, 0x1000000, true, true));
        ((GridData)this.fLocationControl.getLayoutData()).widthHint = 100;
        this.fLocationControl.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        final ToolBarManager dialogToolBar = new ToolBarManager(0x820000);
        dialogToolBar.add((IContributionItem)new Separator());
        Action existingFilters = new Action(Messages.NewsFilterDialog_SHOW_NEWS_FILTER, 4){

            public void run() {
                OwlUI.positionDropDownMenu(this, dialogToolBar);
            }

            public ImageDescriptor getImageDescriptor() {
                return OwlUI.FILTER;
            }

            public String getId() {
                return NewsFilterDialog.FILTERS_ACTION;
            }
        };
        existingFilters.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                Set filters = CoreUtils.loadSortedNewsFilters();
                Menu menu = new Menu(parent);
                if (filters.isEmpty()) {
                    MenuItem item = new MenuItem(menu, 0);
                    item.setText(Messages.NewsFilterDialog_NO_FILTER);
                    item.setEnabled(false);
                }
                for (final ISearchFilter filter : filters) {
                    MenuItem item = new MenuItem(menu, 0);
                    item.setText(filter.getName());
                    item.setImage(OwlUI.getImage((ResourceManager)NewsFilterDialog.this.fResources, OwlUI.FILTER));
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (filter.getSearch() != null) {
                                NewsFilterDialog.this.showSearch(filter.getSearch());
                            }
                            if (filter.matchAllNews()) {
                                NewsFilterDialog.this.fMatchAnyRadio.setSelection(false);
                                NewsFilterDialog.this.fMatchAllRadio.setSelection(false);
                                NewsFilterDialog.this.fMatchAllNewsRadio.setSelection(true);
                                NewsFilterDialog.this.setControlEnabled((Control)NewsFilterDialog.this.fSearchConditionList, false);
                            }
                            NewsFilterDialog.this.fFilterActionList.showActions(filter.getActions());
                        }
                    });
                }
                return menu;
            }
        });
        dialogToolBar.add((IAction)existingFilters);
        Action savedSearches = new Action(Messages.NewsFilterDialog_SHOW_SAVED_SEARCH, 4){

            public void run() {
                OwlUI.positionDropDownMenu(this, dialogToolBar);
            }

            public ImageDescriptor getImageDescriptor() {
                return OwlUI.SEARCHMARK;
            }

            public String getId() {
                return NewsFilterDialog.SEARCHES_ACTION;
            }
        };
        savedSearches.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                Set searchMarks = CoreUtils.loadSortedSearchMarks();
                Menu menu = new Menu(parent);
                if (searchMarks.isEmpty()) {
                    MenuItem item = new MenuItem(menu, 0);
                    item.setText(Messages.NewsFilterDialog_NO_SAVED_SEARCH);
                    item.setEnabled(false);
                }
                for (final ISearchMark searchMark : searchMarks) {
                    if (!NewsFilterDialog.this.isSupported(searchMark)) continue;
                    MenuItem item = new MenuItem(menu, 0);
                    item.setText(searchMark.getName());
                    item.setImage(OwlUI.getImage((ResourceManager)NewsFilterDialog.this.fResources, OwlUI.SEARCHMARK));
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            NewsFilterDialog.this.showSearch((ISearch)searchMark);
                        }
                    });
                }
                return menu;
            }
        });
        dialogToolBar.add((IAction)savedSearches);
        dialogToolBar.createControl(topControlsContainer);
        dialogToolBar.getControl().setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        final Composite conditionsContainer = new Composite(container, 0);
        conditionsContainer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        conditionsContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 10));
        conditionsContainer.setBackground(container.getDisplay().getSystemColor(25));
        conditionsContainer.setBackgroundMode(2);
        conditionsContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Rectangle clArea = conditionsContainer.getClientArea();
                gc.setForeground(conditionsContainer.getDisplay().getSystemColor(18));
                gc.drawLine(clArea.x, clArea.y, clArea.x + clArea.width, clArea.y);
                gc.drawLine(clArea.x, clArea.y + clArea.height - 1, clArea.x + clArea.width, clArea.y + clArea.height - 1);
            }
        });
        this.fSearchConditionList = new SearchConditionList(conditionsContainer, 0, this.getDefaultConditions(), this.fExcludedConditions);
        this.fSearchConditionList.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.fSearchConditionList.setVisibleItemCount(3);
        List initialConditions = null;
        if (this.fEditedFilter != null && this.fEditedFilter.getSearch() != null) {
            initialConditions = this.fEditedFilter.getSearch().getSearchConditions();
        } else if (this.fPresetSearch != null) {
            initialConditions = this.fPresetSearch.getSearchConditions();
        }
        if (initialConditions != null) {
            Pair conditions = CoreUtils.splitScope((List)initialConditions);
            Long[][] locationValue = null;
            if (conditions.getFirst() != null && ((ISearchCondition)conditions.getFirst()).getValue() instanceof Long[][]) {
                locationValue = (Long[][])((ISearchCondition)conditions.getFirst()).getValue();
            }
            this.fLocationControl.select(locationValue);
            if (!((List)conditions.getSecond()).isEmpty()) {
                this.fSearchConditionList.showConditions((List)conditions.getSecond());
            }
            if (CoreUtils.isLocationConflict((List)initialConditions)) {
                this.setMessage(Messages.NewsFilterDialog_LOCATION_IN_WARNING, 2);
            }
        }
        this.setControlEnabled((Control)this.fSearchConditionList, !this.fMatchAllNewsRadio.getSelection());
        if (this.fPresetSearch != null) {
            this.onGenerateName();
        }
    }

    private void showSearch(ISearch search) {
        this.fMatchAllRadio.setSelection(search.matchAllConditions());
        this.fMatchAnyRadio.setSelection(!search.matchAllConditions());
        this.fMatchAllNewsRadio.setSelection(false);
        this.setControlEnabled((Control)this.fSearchConditionList, true);
        Pair conditions = CoreUtils.splitScope((List)search.getSearchConditions());
        Long[][] location = null;
        if (conditions.getFirst() != null && ((ISearchCondition)conditions.getFirst()).getValue() instanceof Long[][]) {
            location = (Long[][])((ISearchCondition)conditions.getFirst()).getValue();
        }
        this.fLocationControl.select(location);
        this.fSearchConditionList.showConditions((List)conditions.getSecond());
        this.fLocationControl.getParent().getParent().getParent().layout(true, true);
    }

    private void setControlEnabled(Control control, boolean enabled) {
        control.setEnabled(enabled);
        if (control instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)control;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setControlEnabled(child, enabled);
                ++n2;
            }
        }
    }

    private boolean isSupported(ISearchMark searchmark) {
        List conditions = searchmark.getSearchConditions();
        for (ISearchCondition condition : conditions) {
            if (!this.fExcludedConditions.contains(condition.getField().getId())) continue;
            return false;
        }
        return true;
    }

    private List<Integer> getExcludedConditions() {
        return Collections.emptyList();
    }

    private List<ISearchCondition> getDefaultConditions() {
        ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(1);
        IModelFactory factory = Owl.getModelFactory();
        ISearchField field = factory.createSearchField(-1, INews.class.getName());
        ISearchCondition condition = factory.createSearchCondition(field, SearchSpecifier.CONTAINS_ALL, (Object)"");
        conditions.add(condition);
        return conditions;
    }

    private void createActionControls(Composite container) {
        final Composite actionsContainer = new Composite(container, 0);
        actionsContainer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        actionsContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 10));
        actionsContainer.setBackground(container.getDisplay().getSystemColor(25));
        actionsContainer.setBackgroundMode(2);
        actionsContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Rectangle clArea = actionsContainer.getClientArea();
                gc.setForeground(actionsContainer.getDisplay().getSystemColor(18));
                gc.drawLine(clArea.x, clArea.y, clArea.x + clArea.width, clArea.y);
            }
        });
        this.fFilterActionList = new NewsActionList(actionsContainer, 0, this.getDefaultActions());
        this.fFilterActionList.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.fFilterActionList.setVisibleItemCount(3);
        if (this.fEditedFilter != null) {
            this.fFilterActionList.showActions(this.fEditedFilter.getActions());
        } else if (this.fPresetActions != null) {
            this.fFilterActionList.showActions(this.fPresetActions);
        }
    }

    private List<IFilterAction> getDefaultActions() {
        ArrayList<IFilterAction> defaultActions = new ArrayList<IFilterAction>(1);
        IModelFactory factory = Owl.getModelFactory();
        defaultActions.add(factory.createFilterAction("org.rssowl.core.MoveNewsAction"));
        return defaultActions;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fEditedFilter == null) {
            shell.setText(Messages.NewsFilterDialog_NEW_FILTER);
        } else {
            shell.setText(NLS.bind((String)Messages.NewsFilterDialog_EDIT_NEWS_FILTER_N, (Object)this.fEditedFilter.getName()));
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_SECTION);
        if (section != null) {
            return section;
        }
        return settings.addNewSection(SETTINGS_SECTION);
    }
}

