/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.search.LocationControl;
import org.rssowl.ui.internal.search.SearchConditionList;
import org.rssowl.ui.internal.util.FolderChooser;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.ModelUtils;

public class SearchMarkWizard
extends Wizard
implements INewWizard {
    private NewSearchMarkWizardPage fPage;
    private IFolderChild fPosition;
    private IFolder fFolder;
    private ResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Pair<IFolder, IFolderChild> pair = ModelUtils.getLocationAndPosition(selection);
        this.fFolder = (IFolder)pair.getFirst();
        this.fPosition = (IFolderChild)pair.getSecond();
    }

    public void addPages() {
        this.fPage = new NewSearchMarkWizardPage(Messages.SearchMarkWizard_NEW_SEARCH);
        this.setWindowTitle(Messages.SearchMarkWizard_SAVED_SEARCH);
        this.setHelpAvailable(false);
        this.addPage((IWizardPage)this.fPage);
    }

    public void dispose() {
        this.fResources.dispose();
        super.dispose();
    }

    public boolean performFinish() {
        String name = this.fPage.getSearchMarkName();
        IModelFactory factory = Owl.getModelFactory();
        if (!StringUtils.isSet((String)name)) {
            this.fPage.onGenerateName();
            name = this.fPage.getSearchMarkName();
        }
        if (this.fPage.fSearchConditionList.isEmpty()) {
            this.fPage.setErrorMessage(Messages.SearchMarkWizard_SPECIFY_SEARCH);
            return false;
        }
        IFolder folder = this.fPage.getFolder();
        ISearchMark searchMark = factory.createSearchMark(null, folder, name, this.fPosition, this.fPosition != null ? Boolean.valueOf(true) : null);
        searchMark.setMatchAllConditions(this.fPage.fMatchAllRadio.getSelection());
        this.fPage.fSearchConditionList.createConditions(searchMark);
        ISearchCondition locationCondition = this.fPage.getScopeCondition();
        if (locationCondition != null) {
            searchMark.addSearchCondition(locationCondition);
        }
        Map properties = folder.getProperties();
        for (Map.Entry property : properties.entrySet()) {
            searchMark.setProperty((String)property.getKey(), (Serializable)property.getValue());
        }
        DynamicDAO.save((IPersistable)folder);
        Controller.getDefault().getSavedSearchService().updateSavedSearches(Collections.singleton(searchMark));
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NewSearchMarkWizardPage
    extends WizardPage {
        private Text fNameInput;
        private FolderChooser fFolderChooser;
        private Button fMatchAllRadio;
        private Button fMatchAnyRadio;
        private SearchConditionList fSearchConditionList;
        private LocationControl fLocationControl;

        NewSearchMarkWizardPage(String pageName) {
            super(pageName, pageName, OwlUI.getImageDescriptor("icons/wizban/search.gif"));
            this.setMessage(Messages.SearchMarkWizard_SEARCH_WIZ_TITLE);
        }

        public void createControl(Composite parent) {
            Composite control = new Composite(parent, 0);
            control.setLayout((Layout)new GridLayout(2, false));
            Label nameLabel = new Label(control, 0);
            nameLabel.setText(Messages.SearchMarkWizard_NAME);
            Composite nameContainer = new Composite(control, 2048);
            nameContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            nameContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
            nameContainer.setBackground(control.getDisplay().getSystemColor(25));
            this.fNameInput = new Text(nameContainer, 4);
            OwlUI.makeAccessible((Control)this.fNameInput, (Control)nameLabel);
            this.fNameInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.fNameInput.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewSearchMarkWizardPage.this.setErrorMessage(null);
                }
            });
            ToolBar generateTitleBar = new ToolBar(nameContainer, 0x800000);
            OwlUI.makeAccessible((Control)generateTitleBar, Messages.SearchMarkDialog_CREATE_NAME_FROM_CONDITIONS);
            generateTitleBar.setBackground(control.getDisplay().getSystemColor(25));
            ToolItem generateTitleItem = new ToolItem(generateTitleBar, 8);
            generateTitleItem.setImage(OwlUI.getImage(SearchMarkWizard.this.fResources, "icons/etool16/info.gif"));
            generateTitleItem.setToolTipText(Messages.SearchMarkDialog_CREATE_NAME_FROM_CONDITIONS);
            generateTitleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewSearchMarkWizardPage.this.onGenerateName();
                }
            });
            Label folderLabel = new Label(control, 0);
            folderLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            folderLabel.setText(Messages.SearchMarkWizard_LOCATION);
            this.fFolderChooser = new FolderChooser(control, SearchMarkWizard.this.fFolder, 2048, true);
            this.fFolderChooser.setExpandStrategy(FolderChooser.ExpandStrategy.PACK);
            this.fFolderChooser.setLayoutData(new GridData(4, 1, true, false));
            this.fFolderChooser.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 2, 5, false));
            this.fFolderChooser.setBackground(control.getDisplay().getSystemColor(1));
            Composite topControlsContainer = new Composite(control, 0);
            topControlsContainer.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            topControlsContainer.setLayout((Layout)LayoutUtils.createGridLayout(4, 5, 0));
            ((GridLayout)topControlsContainer.getLayout()).marginTop = 10;
            this.fMatchAllRadio = new Button(topControlsContainer, 16);
            this.fMatchAllRadio.setText(Messages.SearchMarkDialog_MATCH_ALL_CONDITIONS);
            this.fMatchAllRadio.setSelection(true);
            this.fMatchAnyRadio = new Button(topControlsContainer, 16);
            this.fMatchAnyRadio.setText(Messages.SearchMarkDialog_MATCH_ANY_CONDITION);
            Label sep = new Label(topControlsContainer, 514);
            sep.setLayoutData((Object)new GridData(-1, 16));
            Composite scopeContainer = new Composite(topControlsContainer, 0);
            scopeContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            scopeContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 5, false));
            ((GridLayout)scopeContainer.getLayout()).marginLeft = 2;
            Label locationLabel = new Label(scopeContainer, 0);
            locationLabel.setText(Messages.SearchMarkDialog_SEARCH_IN);
            this.fLocationControl = new LocationControl(scopeContainer, 64){

                protected String getDefaultLabel() {
                    return Messages.SearchMarkWizard_ALL_NEWS;
                }
            };
            this.fLocationControl.setLayoutData(new GridData(4, 0x1000000, true, true));
            ((GridData)this.fLocationControl.getLayoutData()).widthHint = 100;
            this.fLocationControl.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
            Composite conditionsContainer = new Composite(control, 2048);
            conditionsContainer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            conditionsContainer.setLayout((Layout)LayoutUtils.createGridLayout(2));
            conditionsContainer.setBackground(control.getDisplay().getSystemColor(1));
            conditionsContainer.setBackgroundMode(2);
            this.fSearchConditionList = new SearchConditionList(conditionsContainer, 0, this.getDefaultConditions());
            this.fSearchConditionList.setLayoutData(new GridData(4, 4, true, true, 2, 1));
            this.fSearchConditionList.setVisibleItemCount(3);
            this.setControl((Control)control);
        }

        void onGenerateName() {
            String name;
            List<ISearchCondition> conditions = this.fSearchConditionList.createConditions();
            ISearchCondition locationCondition = this.fLocationControl.toScopeCondition();
            if (locationCondition != null) {
                conditions.add(locationCondition);
            }
            if ((name = CoreUtils.getName(conditions, (boolean)this.fMatchAllRadio.getSelection())).length() > 0) {
                this.fNameInput.setText(name);
                this.fNameInput.selectAll();
            }
        }

        private List<ISearchCondition> getDefaultConditions() {
            ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(1);
            IModelFactory factory = Owl.getModelFactory();
            ISearchField field = factory.createSearchField(-1, INews.class.getName());
            ISearchCondition condition = factory.createSearchCondition(field, SearchSpecifier.CONTAINS, (Object)"");
            conditions.add(condition);
            return conditions;
        }

        String getSearchMarkName() {
            return this.fNameInput.getText();
        }

        IFolder getFolder() {
            return this.fFolderChooser.getFolder();
        }

        ISearchCondition getScopeCondition() {
            return this.fLocationControl.toScopeCondition();
        }
    }
}

