/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.cleanup;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpOperations;
import org.rssowl.ui.internal.dialogs.cleanup.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

public class CleanUpOptionsPage
extends WizardPage {
    private Button fDeleteFeedByLastVisitCheck;
    private Button fDeleteFeedBySynchronizationCheck;
    private Spinner fMaxLastVisitSpinner;
    private Button fDeleteFeedByLastUpdateCheck;
    private Spinner fMaxLastUpdateSpinner;
    private Button fDeleteConErrorFeedCheck;
    private Button fDeleteDuplicateBookmarksCheck;
    private Button fDeleteNewsByCountCheck;
    private Spinner fMaxCountSpinner;
    private Button fDeleteNewsByAgeCheck;
    private Spinner fMaxAgeSpinner;
    private Button fDeleteReadNewsCheck;
    private Button fNeverDeleteUnreadNewsCheck;
    private Button fNeverDeleteLabeledNewsCheck;
    private IPreferenceScope fGlobalScope;
    private LocalResourceManager fResources;

    protected CleanUpOptionsPage(String pageName) {
        super(pageName, pageName, OwlUI.getImageDescriptor("icons/wizban/cleanup_wiz.gif"));
        this.setMessage(Messages.CleanUpOptionsPage_CHOOSE_OPS);
        this.fGlobalScope = Owl.getPreferenceService().getGlobalScope();
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    CleanUpOperations getOperations() {
        boolean lastVisitInDaysState = this.fDeleteFeedByLastVisitCheck.getSelection();
        int lastVisitInDays = this.fMaxLastVisitSpinner.getSelection();
        boolean lastUpdateInDaysState = this.fDeleteFeedByLastUpdateCheck.getSelection();
        int lastUpdateInDays = this.fMaxLastUpdateSpinner.getSelection();
        boolean deleteFeedsByConError = this.fDeleteConErrorFeedCheck.getSelection();
        boolean deleteFeedsByDuplicates = this.fDeleteDuplicateBookmarksCheck.getSelection();
        boolean deleteFeedsBySynchronization = this.fDeleteFeedBySynchronizationCheck != null ? this.fDeleteFeedBySynchronizationCheck.getSelection() : false;
        boolean maxNewsCountPerFeedState = this.fDeleteNewsByCountCheck.getSelection();
        int maxNewsCountPerFeed = this.fMaxCountSpinner.getSelection();
        boolean maxNewsAgeState = this.fDeleteNewsByAgeCheck.getSelection();
        int maxNewsAge = this.fMaxAgeSpinner.getSelection();
        boolean deleteReadNews = this.fDeleteReadNewsCheck.getSelection();
        boolean keepUnreadNews = this.fNeverDeleteUnreadNewsCheck.getSelection();
        boolean keepLabeledNews = this.fNeverDeleteLabeledNewsCheck.getSelection();
        return new CleanUpOperations(lastVisitInDaysState, lastVisitInDays, lastUpdateInDaysState, lastUpdateInDays, deleteFeedsByConError, deleteFeedsByDuplicates, deleteFeedsBySynchronization, maxNewsCountPerFeedState, maxNewsCountPerFeed, maxNewsAgeState, maxNewsAge, deleteReadNews, keepUnreadNews, keepLabeledNews);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 10, 5, false));
        this.createFeedOptions(container);
        this.createNewsOptions(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private void createFeedOptions(Composite parent) {
        Group container = new Group(parent, 0);
        container.setLayoutData((Object)new GridData(4, 1, true, false));
        container.setLayout((Layout)LayoutUtils.createGridLayout(3));
        container.setText(Messages.CleanUpOptionsPage_CLEANUP_BOOKMARKS);
        this.fDeleteFeedByLastVisitCheck = new Button((Composite)container, 32);
        this.fDeleteFeedByLastVisitCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fDeleteFeedByLastVisitCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.CLEAN_UP_BM_BY_LAST_VISIT_STATE));
        this.fDeleteFeedByLastVisitCheck.setText(Messages.CleanUpOptionsPage_DELETE_BY_AGE);
        this.fDeleteFeedByLastVisitCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpOptionsPage.this.fMaxLastVisitSpinner.setEnabled(CleanUpOptionsPage.this.fDeleteFeedByLastVisitCheck.getSelection());
            }
        });
        this.fMaxLastVisitSpinner = new Spinner((Composite)container, 2048);
        this.fMaxLastVisitSpinner.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fMaxLastVisitSpinner.setEnabled(this.fDeleteFeedByLastVisitCheck.getSelection());
        this.fMaxLastVisitSpinner.setMinimum(1);
        this.fMaxLastVisitSpinner.setMaximum(999);
        this.fMaxLastVisitSpinner.setSelection(this.fGlobalScope.getInteger(DefaultPreferences.CLEAN_UP_BM_BY_LAST_VISIT_VALUE));
        Label label = new Label((Composite)container, 0);
        label.setText(Messages.CleanUpOptionsPage_DAYS);
        this.fDeleteFeedByLastUpdateCheck = new Button((Composite)container, 32);
        this.fDeleteFeedByLastUpdateCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fDeleteFeedByLastUpdateCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.CLEAN_UP_BM_BY_LAST_UPDATE_STATE));
        this.fDeleteFeedByLastUpdateCheck.setText(Messages.CleanUpOptionsPage_DELETE_BY_UPDATE);
        this.fDeleteFeedByLastUpdateCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpOptionsPage.this.fMaxLastUpdateSpinner.setEnabled(CleanUpOptionsPage.this.fDeleteFeedByLastUpdateCheck.getSelection());
            }
        });
        this.fMaxLastUpdateSpinner = new Spinner((Composite)container, 2048);
        this.fMaxLastUpdateSpinner.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fMaxLastUpdateSpinner.setEnabled(this.fDeleteFeedByLastUpdateCheck.getSelection());
        this.fMaxLastUpdateSpinner.setMinimum(1);
        this.fMaxLastUpdateSpinner.setMaximum(999);
        this.fMaxLastUpdateSpinner.setSelection(this.fGlobalScope.getInteger(DefaultPreferences.CLEAN_UP_BM_BY_LAST_UPDATE_VALUE));
        label = new Label((Composite)container, 0);
        label.setText(Messages.CleanUpOptionsPage_DAYS);
        this.fDeleteDuplicateBookmarksCheck = new Button((Composite)container, 32);
        this.fDeleteDuplicateBookmarksCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.fDeleteDuplicateBookmarksCheck.setText(Messages.CleanUpOptionsPage_DELETE_DUPLICATES);
        this.fDeleteDuplicateBookmarksCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.CLEAN_UP_BM_BY_DUPLICATES));
        this.fDeleteConErrorFeedCheck = new Button((Composite)container, 32);
        this.fDeleteConErrorFeedCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.fDeleteConErrorFeedCheck.setText(Messages.CleanUpOptionsPage_DELETE_CON_ERROR);
        this.fDeleteConErrorFeedCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.CLEAN_UP_BM_BY_CON_ERROR));
    }

    private void createNewsOptions(Composite parent) {
        Group container = new Group(parent, 0);
        container.setLayoutData((Object)new GridData(4, 1, true, false));
        container.setLayout((Layout)LayoutUtils.createGridLayout(2));
        container.setText(Messages.CleanUpOptionsPage_CLEANUP_NEWS);
        this.fDeleteNewsByCountCheck = new Button((Composite)container, 32);
        this.fDeleteNewsByCountCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fDeleteNewsByCountCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.CLEAN_UP_NEWS_BY_COUNT_STATE));
        this.fDeleteNewsByCountCheck.setText(Messages.CleanUpOptionsPage_DELETE_BY_COUNT);
        this.fDeleteNewsByCountCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpOptionsPage.this.fMaxCountSpinner.setEnabled(CleanUpOptionsPage.this.fDeleteNewsByCountCheck.getSelection());
            }
        });
        this.fMaxCountSpinner = new Spinner((Composite)container, 2048);
        this.fMaxCountSpinner.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fMaxCountSpinner.setEnabled(this.fDeleteNewsByCountCheck.getSelection());
        this.fMaxCountSpinner.setMinimum(0);
        this.fMaxCountSpinner.setMaximum(9999);
        this.fMaxCountSpinner.setSelection(this.fGlobalScope.getInteger(DefaultPreferences.CLEAN_UP_NEWS_BY_COUNT_VALUE));
        this.fDeleteNewsByAgeCheck = new Button((Composite)container, 32);
        this.fDeleteNewsByAgeCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fDeleteNewsByAgeCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.CLEAN_UP_NEWS_BY_AGE_STATE));
        this.fDeleteNewsByAgeCheck.setText(Messages.CleanUpOptionsPage_DELETE_NEWS_BY_AGE);
        this.fDeleteNewsByAgeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpOptionsPage.this.fMaxAgeSpinner.setEnabled(CleanUpOptionsPage.this.fDeleteNewsByAgeCheck.getSelection());
            }
        });
        this.fMaxAgeSpinner = new Spinner((Composite)container, 2048);
        this.fMaxAgeSpinner.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fMaxAgeSpinner.setEnabled(this.fDeleteNewsByAgeCheck.getSelection());
        this.fMaxAgeSpinner.setMinimum(1);
        this.fMaxAgeSpinner.setMaximum(9999);
        this.fMaxAgeSpinner.setSelection(this.fGlobalScope.getInteger(DefaultPreferences.CLEAN_UP_NEWS_BY_AGE_VALUE));
        this.fDeleteReadNewsCheck = new Button((Composite)container, 32);
        this.fDeleteReadNewsCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fDeleteReadNewsCheck.setText(Messages.CleanUpOptionsPage_DELETE_READ);
        this.fDeleteReadNewsCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.CLEAN_UP_READ_NEWS_STATE));
        this.fNeverDeleteUnreadNewsCheck = new Button((Composite)container, 32);
        this.fNeverDeleteUnreadNewsCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fNeverDeleteUnreadNewsCheck.setText(Messages.CleanUpOptionsPage_DONT_DELETE_UNREAD);
        this.fNeverDeleteUnreadNewsCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.CLEAN_UP_NEVER_DEL_UNREAD_NEWS_STATE));
        this.fNeverDeleteLabeledNewsCheck = new Button((Composite)container, 32);
        this.fNeverDeleteLabeledNewsCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fNeverDeleteLabeledNewsCheck.setText(Messages.CleanUpOptionsPage_DONT_DELETE_LABELED);
        this.fNeverDeleteLabeledNewsCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.CLEAN_UP_NEVER_DEL_LABELED_NEWS_STATE));
        Composite infoContainer = new Composite((Composite)container, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        ((GridLayout)infoContainer.getLayout()).marginTop = 5;
        Label infoImg = new Label(infoContainer, 0);
        infoImg.setImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/obj16/info.gif"));
        infoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label infoText = new Label(infoContainer, 64);
        infoText.setText(Messages.CleanUpOptionsPage_CLEANUP_INFO);
        infoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public void dispose() {
        super.dispose();
        this.fResources.dispose();
    }
}

