/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.importer;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.importer.ImportElementsPage;
import org.rssowl.ui.internal.dialogs.importer.Messages;
import org.rssowl.ui.internal.dialogs.welcome.WelcomeWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportOptionsPage
extends WizardPage {
    private Button fImportLabelsCheck;
    private Button fImportFiltersCheck;
    private Button fImportPreferencesCheck;
    private boolean fFiltersUseLabels;

    ImportOptionsPage() {
        super(Messages.ImportOptionsPage_IMPORT_OPTIONS, Messages.ImportOptionsPage_IMPORT_OPTIONS, null);
        this.setMessage(Messages.ImportOptionsPage_SELECT_OPTIONS);
    }

    public void createControl(Composite parent) {
        this.setImageDescriptor(OwlUI.getImageDescriptor(this.getWizard() instanceof WelcomeWizard ? "icons/wizban/welcome_wiz.gif" : "icons/wizban/import_wiz.png"));
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        StyledText infoText = new StyledText(container, 72);
        infoText.setEnabled(false);
        infoText.setLayoutData((Object)new GridData(4, 4, true, false));
        ((GridData)infoText.getLayoutData()).widthHint = 300;
        infoText.setBackground(container.getDisplay().getSystemColor(22));
        infoText.setText(Messages.ImportOptionsPage_OPTIONS_INFO);
        this.fImportLabelsCheck = new Button(container, 32);
        this.fImportLabelsCheck.setImage(OwlUI.getImage((Control)this.fImportLabelsCheck, "icons/elcl16/labels.gif"));
        this.fImportLabelsCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fImportLabelsCheck.getLayoutData()).verticalIndent = 10;
        this.fImportFiltersCheck = new Button(container, 32);
        this.fImportFiltersCheck.setImage(OwlUI.getImage((Control)this.fImportFiltersCheck, OwlUI.FILTER));
        this.fImportFiltersCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fImportFiltersCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportOptionsPage.this.fImportFiltersCheck.getSelection() && !ImportOptionsPage.this.fImportLabelsCheck.getSelection() && ImportOptionsPage.this.fFiltersUseLabels) {
                    ImportOptionsPage.this.fImportLabelsCheck.setSelection(true);
                    ImportOptionsPage.this.setMessage(Messages.ImportOptionsPage_LABELS_INFO, 1);
                } else if (!ImportOptionsPage.this.fImportFiltersCheck.getSelection()) {
                    ImportOptionsPage.this.setMessage(Messages.ImportOptionsPage_SELECT_OPTIONS);
                }
            }
        });
        this.fImportPreferencesCheck = new Button(container, 32);
        this.fImportPreferencesCheck.setImage(OwlUI.getImage((Control)this.fImportPreferencesCheck, "icons/elcl16/preferences.gif"));
        this.fImportPreferencesCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        ImportElementsPage elementsPage = this.getPreviousPage() instanceof ImportElementsPage ? (ImportElementsPage)this.getPreviousPage() : (ImportElementsPage)this.getPreviousPage().getPreviousPage();
        this.update(elementsPage.getLabelsToImport().size(), elementsPage.getFiltersToImport().size(), !elementsPage.getPreferencesToImport().isEmpty());
        this.fFiltersUseLabels = this.filtersUseLabels(elementsPage.getFiltersToImport());
        super.setVisible(visible);
    }

    boolean importLabels() {
        return this.fImportLabelsCheck.getSelection();
    }

    boolean importFilters() {
        return this.fImportFiltersCheck.getSelection();
    }

    boolean importPreferences() {
        return this.fImportPreferencesCheck.getSelection();
    }

    private void update(int labelCount, int filterCount, boolean hasPreferences) {
        if (labelCount != 0) {
            this.fImportLabelsCheck.setText(NLS.bind((String)Messages.ImportOptionsPage_IMPORT_N_LABELS, (Object)labelCount));
        } else {
            this.fImportLabelsCheck.setText(Messages.ImportOptionsPage_IMPORT_LABELS);
        }
        this.fImportLabelsCheck.setEnabled(labelCount != 0);
        if (filterCount != 0) {
            this.fImportFiltersCheck.setText(NLS.bind((String)Messages.ImportOptionsPage_IMPORT_N_FILTERS, (Object)filterCount));
        } else {
            this.fImportFiltersCheck.setText(Messages.ImportOptionsPage_IMPORT_FILTERS);
        }
        this.fImportFiltersCheck.setEnabled(filterCount != 0);
        if (hasPreferences) {
            this.fImportPreferencesCheck.setText(Messages.ImportOptionsPage_IMPORT_PREFRENCES);
        } else {
            this.fImportPreferencesCheck.setText(Messages.ImportOptionsPage_IMPORT_PREFERENCES_UNAVAILABLE);
        }
        this.fImportPreferencesCheck.setEnabled(hasPreferences);
    }

    private boolean filtersUseLabels(Collection<ISearchFilter> filters) {
        for (ISearchFilter filter : filters) {
            List actions = filter.getActions();
            for (IFilterAction action : actions) {
                if (!"org.rssowl.core.LabelNewsAction".equals(action.getActionId())) continue;
                return true;
            }
        }
        return false;
    }
}

