/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.part.EditorPart;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.connection.IAbortable;
import org.rssowl.core.connection.IProtocolHandler;
import org.rssowl.core.internal.connection.DefaultProtocolHandler;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IBookMarkDAO;
import org.rssowl.core.persist.dao.INewsBinDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.dao.ISearchMarkDAO;
import org.rssowl.core.persist.event.BookMarkAdapter;
import org.rssowl.core.persist.event.BookMarkEvent;
import org.rssowl.core.persist.event.BookMarkListener;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.FeedAdapter;
import org.rssowl.core.persist.event.FeedEvent;
import org.rssowl.core.persist.event.FolderAdapter;
import org.rssowl.core.persist.event.FolderEvent;
import org.rssowl.core.persist.event.MarkEvent;
import org.rssowl.core.persist.event.NewsBinAdapter;
import org.rssowl.core.persist.event.NewsBinEvent;
import org.rssowl.core.persist.event.NewsBinListener;
import org.rssowl.core.persist.event.SearchConditionEvent;
import org.rssowl.core.persist.event.SearchConditionListener;
import org.rssowl.core.persist.event.SearchMarkAdapter;
import org.rssowl.core.persist.event.SearchMarkEvent;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.ITreeNode;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.RetentionStrategy;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.TreeTraversal;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.ApplicationServer;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.DeleteTypesAction;
import org.rssowl.ui.internal.actions.FindAction;
import org.rssowl.ui.internal.actions.ReloadTypesAction;
import org.rssowl.ui.internal.editors.feed.BrowserBar;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;
import org.rssowl.ui.internal.editors.feed.FeedViewSite;
import org.rssowl.ui.internal.editors.feed.FilterBar;
import org.rssowl.ui.internal.editors.feed.IFeedViewSite;
import org.rssowl.ui.internal.editors.feed.Messages;
import org.rssowl.ui.internal.editors.feed.NewsBrowserControl;
import org.rssowl.ui.internal.editors.feed.NewsBrowserLabelProvider;
import org.rssowl.ui.internal.editors.feed.NewsBrowserViewModel;
import org.rssowl.ui.internal.editors.feed.NewsBrowserViewer;
import org.rssowl.ui.internal.editors.feed.NewsColumn;
import org.rssowl.ui.internal.editors.feed.NewsComparator;
import org.rssowl.ui.internal.editors.feed.NewsContentProvider;
import org.rssowl.ui.internal.editors.feed.NewsFilter;
import org.rssowl.ui.internal.editors.feed.NewsGrouping;
import org.rssowl.ui.internal.editors.feed.NewsTableControl;
import org.rssowl.ui.internal.editors.feed.NewsTableViewer;
import org.rssowl.ui.internal.editors.feed.PerformAfterInputSet;
import org.rssowl.ui.internal.undo.NewsStateOperation;
import org.rssowl.ui.internal.undo.UndoStack;
import org.rssowl.ui.internal.util.CBrowser;
import org.rssowl.ui.internal.util.EditorUtils;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.UIBackgroundJob;
import org.rssowl.ui.internal.util.WidgetTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedView
extends EditorPart
implements IReusableEditor {
    private static final int HANDLE_NEWS_SEEN_DELAY = 100;
    private static final int HANDLE_NEWS_SEEN_BLOCK_DELAY = 800;
    private static final int BROWSER_OPERATIONS_DELAY = 100;
    private static final int CLEAN_UP_BLOCK_DELAY = 1000;
    private static final String CSV_SEPARATOR_PROPERTY = "csvSeparator";
    private static FeedView fgLastVisibleFeedView = null;
    private static boolean fgBlockFeedChangeEvent;
    public static final String ID = "org.rssowl.ui.FeedView";
    private FeedViewInput fInput;
    private IEditorSite fEditorSite;
    private IFeedViewSite fFeedViewSite;
    private NewsTableControl fNewsTableControl;
    private NewsBrowserControl fNewsBrowserControl;
    private FilterBar fFilterBar;
    private BrowserBar fBrowserBar;
    private NewsFilter fNewsFilter;
    private NewsGrouping fNewsGrouping;
    private NewsContentProvider fContentProvider;
    private Composite fNewsTableControlContainer;
    private Composite fBrowserViewerControlContainer;
    private IPartListener2 fPartListener;
    private BookMarkListener fBookMarkListener;
    private SearchMarkAdapter fSearchMarkListener;
    private FeedAdapter fFeedListener;
    private SearchConditionListener fSearchConditionListener;
    private NewsBinListener fNewsBinListener;
    private FolderAdapter fFolderListener;
    private Controller.BookMarkLoadListener fBookMarkLoadListener;
    NewsFilter.Type fInitialFilterType;
    NewsGrouping.Type fInitialGroupType;
    NewsFilter.SearchTarget fInitialSearchTarget;
    OwlUI.Layout fLayout;
    private int[] fInitialWeights;
    private int[] fCacheWeights;
    private IAction fReloadAction;
    private IAction fSelectAllAction;
    private IAction fDeleteAction;
    private IAction fCutAction;
    private IAction fCopyAction;
    private IAction fPasteAction;
    private IAction fPrintAction;
    private IAction fUndoAction;
    private IAction fRedoAction;
    private IAction fFindAction;
    private Composite fParent;
    private Composite fRootComposite;
    private SashForm fSashForm;
    private Label fHorizontalTableBrowserSep;
    private Label fVerticalTableBrowserSep;
    private LocalResourceManager fResourceManager;
    private IPreferenceScope fPreferences;
    private long fOpenTime;
    private boolean fCreated;
    private final Object fCacheJobIdentifier = new Object();
    private ImageDescriptor fTitleImageDescriptor;
    private Label fHorizontalFilterTableSep;
    private Label fHorizontalBrowserSep;
    private Label fVerticalBrowserSep;
    private final INewsDAO fNewsDao = Owl.getPersistenceService().getDAOService().getNewsDAO();
    private boolean fIsDisposed;
    private AtomicLong fLastCleanUpRun = new AtomicLong();

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
        if (this.fIsDisposed || Controller.getDefault().isShuttingDown()) {
            return;
        }
        FileDialog dialog = new FileDialog(this.getSite().getShell(), 8192);
        dialog.setOverwrite(true);
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("*.html");
        if (this.fInput.getMark() instanceof IBookMark) {
            extensions.add("*.xml");
        }
        if (this.isTableViewerVisible()) {
            extensions.add("*.csv");
        }
        dialog.setFilterExtensions(extensions.toArray(new String[extensions.size()]));
        String proposedName = Application.IS_WINDOWS ? CoreUtils.getSafeFileNameForWindows((String)this.fInput.getName()) : this.fInput.getName();
        proposedName = String.valueOf(proposedName) + ".html";
        dialog.setFileName(proposedName);
        String fileName = dialog.open();
        if (fileName == null) {
            return;
        }
        if (fileName.endsWith(".xml")) {
            this.saveAsXml(fileName);
        } else if (fileName.endsWith(".csv")) {
            this.saveAsCsv(fileName);
        } else {
            this.saveAsHtml(fileName);
        }
    }

    private void saveAsXml(final String fileName) {
        final IBookMark bm = (IBookMark)this.fInput.getMark();
        final URI feedLink = bm.getFeedLinkReference().getLink();
        try {
            final IProtocolHandler handler = Owl.getConnectionService().getHandler(feedLink);
            if (handler instanceof DefaultProtocolHandler) {
                Job downloadJob = new Job(Messages.FeedView_DOWNLOADING_FEED){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask(bm.getName(), -1);
                        InputStream in = null;
                        FileOutputStream out = null;
                        boolean canceled = false;
                        Throwable error = null;
                        try {
                            byte[] buffer = new byte[8192];
                            in = handler.openStream(feedLink, monitor, null);
                            out = new FileOutputStream(fileName);
                            while (true) {
                                if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) {
                                    canceled = true;
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                int read = in.read(buffer);
                                if (read == -1) {
                                    return Status.OK_STATUS;
                                }
                                out.write(buffer, 0, read);
                                continue;
                                break;
                            }
                        }
                        catch (FileNotFoundException e) {
                            error = e;
                            Activator.safeLogError(e.getMessage(), e);
                            return Status.OK_STATUS;
                        }
                        catch (IOException e) {
                            error = e;
                            Activator.safeLogError(e.getMessage(), e);
                            return Status.OK_STATUS;
                        }
                        catch (ConnectionException e) {
                            error = e;
                            Activator.safeLogError(e.getMessage(), e);
                            return Status.OK_STATUS;
                        }
                        finally {
                            monitor.done();
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException e) {
                                    Activator.safeLogError(e.getMessage(), e);
                                }
                            }
                            if (in != null) {
                                try {
                                    if ((canceled || error != null) && in instanceof IAbortable) {
                                        ((IAbortable)in).abort();
                                    } else {
                                        in.close();
                                    }
                                }
                                catch (IOException e) {
                                    Activator.safeLogError(e.getMessage(), e);
                                }
                            }
                        }
                    }
                };
                downloadJob.schedule();
            }
        }
        catch (ConnectionException e) {
            Activator.safeLogError(e.getMessage(), e);
        }
    }

    private void saveAsHtml(String fileName) {
        StringBuilder content = new StringBuilder();
        NewsBrowserLabelProvider labelProvider = (NewsBrowserLabelProvider)this.fNewsBrowserControl.getViewer().getLabelProvider();
        URI base = null;
        if (this.fInput.getMark() instanceof IBookMark) {
            try {
                base = URIUtils.toHTTP((URI)new URI(((IBookMark)this.fInput.getMark()).getFeedLinkReference().getLinkAsText()));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if (this.isTableViewerVisible()) {
            Tree tree = this.fNewsTableControl.getViewer().getTree();
            TreeItem[] items = tree.getItems();
            if (items.length > 0) {
                ArrayList<INews> newsToSave = new ArrayList<INews>();
                if (items[0].getItemCount() == 0) {
                    TreeItem[] treeItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        if (item.getData() instanceof INews) {
                            newsToSave.add((INews)item.getData());
                        }
                        ++n2;
                    }
                } else {
                    TreeItem[] treeItemArray = items;
                    int n = items.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TreeItem[] childItems;
                        TreeItem parentItem = treeItemArray[n3];
                        TreeItem[] treeItemArray2 = childItems = parentItem.getItems();
                        int n4 = childItems.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            TreeItem item = treeItemArray2[n5];
                            if (item.getData() instanceof INews) {
                                newsToSave.add((INews)item.getData());
                            }
                            ++n5;
                        }
                        ++n3;
                    }
                }
                String text = labelProvider.render(newsToSave.toArray(), base, false);
                content.append(text);
            }
        } else {
            NewsBrowserViewer viewer = this.fNewsBrowserControl.getViewer();
            Object[] elements = this.fContentProvider.getElements(this.fInput.getMark().toReference());
            elements = viewer.getFlattendChildren(elements, false);
            String text = labelProvider.render(elements, base, false);
            content.append(text);
        }
        if (content.length() > 0) {
            CoreUtils.write((String)fileName, (StringBuilder)content);
        }
    }

    private void saveAsCsv(String fileName) {
        StringBuilder content = new StringBuilder();
        String separator = System.getProperty(CSV_SEPARATOR_PROPERTY);
        if (separator == null || separator.length() == 0) {
            separator = ";";
        } else if (separator.equals("\\t")) {
            separator = "\t";
        }
        Tree tree = this.fNewsTableControl.getViewer().getTree();
        TreeItem[] items = tree.getItems();
        if (items.length > 0) {
            int n;
            int n2;
            Object[] objectArray;
            ArrayList<TreeItem> itemsToSave = new ArrayList<TreeItem>();
            if (items[0].getItemCount() == 0) {
                objectArray = items;
                n2 = items.length;
                n = 0;
                while (n < n2) {
                    TreeItem item = objectArray[n];
                    if (item.getData() instanceof INews) {
                        itemsToSave.add(item);
                    }
                    ++n;
                }
            } else {
                objectArray = items;
                n2 = items.length;
                n = 0;
                while (n < n2) {
                    TreeItem[] childItems;
                    TreeItem parentItem = objectArray[n];
                    TreeItem[] treeItemArray = childItems = parentItem.getItems();
                    int n3 = childItems.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeItem item = treeItemArray[n4];
                        if (item.getData() instanceof INews) {
                            itemsToSave.add(item);
                        }
                        ++n4;
                    }
                    ++n;
                }
            }
            int[] nArray = tree.getColumnOrder();
            objectArray = nArray;
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                TreeItem order = objectArray[n];
                TreeColumn column = tree.getColumn((int)order);
                String text = column.getText();
                if (text.length() > 0) {
                    content.append(this.toCSVEntry(text, separator)).append(separator);
                }
                ++n;
            }
            if (content.length() > 0) {
                content.delete(content.length() - separator.length(), content.length());
                content.append('\n');
            }
            for (TreeItem item : itemsToSave) {
                boolean lineAdded = false;
                int[] nArray2 = tree.getColumnOrder();
                int n5 = nArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    int order = nArray2[n6];
                    if (tree.getColumn(order).getText().length() > 0) {
                        String text = item.getText(order);
                        content.append(this.toCSVEntry(text, separator)).append(separator);
                        lineAdded = true;
                    }
                    ++n6;
                }
                if (!lineAdded) continue;
                content.delete(content.length() - separator.length(), content.length());
                content.append('\n');
            }
        }
        if (content.length() > 0) {
            CoreUtils.write((String)fileName, (StringBuilder)content);
        }
    }

    private String toCSVEntry(String value, String separator) {
        if (value.contains(separator)) {
            if (value.contains("\"")) {
                value = StringUtils.replaceAll((String)value, (String)"\"", (String)"\"\"");
            }
            return "\"" + value + "\"";
        }
        return value;
    }

    public void init(IEditorSite site, IEditorInput input) {
        Assert.isTrue((boolean)(input instanceof FeedViewInput));
        this.fEditorSite = site;
        this.fFeedViewSite = new FeedViewSite(this, site);
        this.setSite((IWorkbenchPartSite)site);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.fPreferences = Owl.getPreferenceService().getGlobalScope();
        this.loadSettings((FeedViewInput)input);
        this.setInput(input);
        this.createGlobalActions();
        this.setGlobalActions();
        this.registerListeners();
    }

    private boolean justOpened() {
        return System.currentTimeMillis() - this.fOpenTime < 800L;
    }

    private void registerListeners() {
        this.fPartListener = new IPartListener2(){

            public void partHidden(IWorkbenchPartReference partRef) {
                if (FeedView.this.justOpened()) {
                    return;
                }
                if (((Object)((Object)FeedView.this)).equals(partRef.getPart(false))) {
                    fgLastVisibleFeedView = FeedView.this;
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                if (((Object)((Object)FeedView.this)).equals(partRef.getPart(false))) {
                    FeedView.this.setGlobalActions();
                    OwlUI.updateWindowTitle(FeedView.this.fInput != null ? FeedView.this.fInput.getMark() : null);
                    if (fgLastVisibleFeedView != null && fgLastVisibleFeedView != FeedView.this && !fgLastVisibleFeedView.fIsDisposed) {
                        fgLastVisibleFeedView.notifyUIEvent(UIEvent.FEED_CHANGE);
                        fgLastVisibleFeedView = null;
                    }
                } else if (!FeedView.ID.equals(partRef.getId())) {
                    fgLastVisibleFeedView = null;
                }
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                IEditorReference[] editors = partRef.getPage().getEditorReferences();
                boolean equalsThis = ((Object)((Object)FeedView.this)).equals(partRef.getPart(false));
                if (editors.length == 0 && equalsThis) {
                    OwlUI.updateWindowTitle(null);
                }
                if (equalsThis) {
                    if (fgLastVisibleFeedView == FeedView.this) {
                        fgLastVisibleFeedView = null;
                    }
                    FeedView.this.notifyUIEvent(UIEvent.TAB_CLOSE);
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                if (((Object)((Object)FeedView.this)).equals(partRef.getPart(false))) {
                    OwlUI.updateWindowTitle(FeedView.this.fInput != null ? FeedView.this.fInput.getMark() : null);
                }
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
                if (((Object)((Object)FeedView.this)).equals(partRef.getPart(false))) {
                    OwlUI.updateWindowTitle(FeedView.this.fInput != null ? FeedView.this.fInput.getMark() : null);
                }
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                if (((Object)((Object)FeedView.this)).equals(partRef.getPart(false)) && FeedView.this.isVisible()) {
                    FeedView.this.fOpenTime = System.currentTimeMillis();
                    OwlUI.updateWindowTitle(FeedView.this.fInput != null ? FeedView.this.fInput.getMark() : null);
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (((Object)((Object)FeedView.this)).equals(partRef.getPart(false))) {
                    OwlUI.updateWindowTitle(FeedView.this.fInput != null ? FeedView.this.fInput.getMark() : null);
                }
            }
        };
        this.fEditorSite.getPage().addPartListener(this.fPartListener);
        this.fBookMarkListener = new BookMarkAdapter(){

            public void entitiesDeleted(Set<BookMarkEvent> events) {
                FeedView.this.onNewsMarksDeleted(events);
            }

            public void entitiesUpdated(Set<BookMarkEvent> events) {
                FeedView.this.onNewsMarksUpdated(events);
            }
        };
        DynamicDAO.addEntityListener(IBookMark.class, (EntityListener)this.fBookMarkListener);
        this.fFolderListener = new FolderAdapter(){

            public void entitiesDeleted(Set<FolderEvent> events) {
                FeedView.this.onFoldersDeleted(events);
            }

            public void entitiesUpdated(Set<FolderEvent> events) {
                FeedView.this.onNewsFoldersUpdated(events);
            }
        };
        DynamicDAO.addEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
        this.fSearchMarkListener = new SearchMarkAdapter(){

            public void entitiesDeleted(Set<SearchMarkEvent> events) {
                FeedView.this.onNewsMarksDeleted(events);
            }

            public void entitiesUpdated(Set<SearchMarkEvent> events) {
                FeedView.this.onNewsMarksUpdated(events);
            }
        };
        DynamicDAO.addEntityListener(ISearchMark.class, (EntityListener)this.fSearchMarkListener);
        this.fSearchConditionListener = new SearchConditionListener(){

            public void entitiesAdded(Set<SearchConditionEvent> events) {
                this.refreshIfRequired(events);
            }

            public void entitiesDeleted(Set<SearchConditionEvent> events) {
            }

            public void entitiesUpdated(Set<SearchConditionEvent> events) {
            }

            private void refreshIfRequired(Set<SearchConditionEvent> events) {
                if (FeedView.this.fInput.getMark() instanceof ISearchMark) {
                    ISearchMarkDAO dao = (ISearchMarkDAO)DynamicDAO.getDAO(ISearchMarkDAO.class);
                    for (SearchConditionEvent event : events) {
                        ISearchCondition condition = event.getEntity();
                        ISearchMark searchMark = dao.load(condition);
                        if (searchMark == null || !searchMark.equals(FeedView.this.fInput.getMark())) continue;
                        JobRunner.runUIUpdater(new UIBackgroundJob((Control)FeedView.this.fParent){

                            protected void runInBackground(IProgressMonitor monitor) {
                                if (!Controller.getDefault().isShuttingDown()) {
                                    FeedView.this.fContentProvider.refreshCache(monitor, FeedView.this.fInput.getMark());
                                }
                            }

                            protected void runInUI(IProgressMonitor monitor) {
                                if (!Controller.getDefault().isShuttingDown()) {
                                    FeedView.this.refresh(true, true);
                                }
                            }

                            public boolean belongsTo(Object family) {
                                return FeedView.this.fCacheJobIdentifier.equals(family);
                            }
                        });
                        break;
                    }
                }
            }
        };
        DynamicDAO.addEntityListener(ISearchCondition.class, (EntityListener)this.fSearchConditionListener);
        this.fNewsBinListener = new NewsBinAdapter(){

            public void entitiesDeleted(Set<NewsBinEvent> events) {
                FeedView.this.onNewsMarksDeleted(events);
            }

            public void entitiesUpdated(Set<NewsBinEvent> events) {
                FeedView.this.onNewsMarksUpdated(events);
            }
        };
        DynamicDAO.addEntityListener(INewsBin.class, (EntityListener)this.fNewsBinListener);
        this.fFeedListener = new FeedAdapter(){

            public void entitiesUpdated(Set<FeedEvent> events) {
                if (!(FeedView.this.fInput.getMark() instanceof IBookMark) || events.size() == 0) {
                    return;
                }
                for (FeedEvent event : events) {
                    FeedLinkReference feedRef = ((IBookMark)FeedView.this.fInput.getMark()).getFeedLinkReference();
                    if (!feedRef.references(event.getEntity())) continue;
                    ImageDescriptor imageDesc = FeedView.this.fInput.getImageDescriptor();
                    if (FeedView.this.fTitleImageDescriptor.equals(imageDesc)) break;
                    FeedView.this.fTitleImageDescriptor = imageDesc;
                    JobRunner.runInUIThread((Widget)FeedView.this.fParent, new Runnable(){

                        public void run() {
                            FeedView.this.setTitleImage(OwlUI.getImage((ResourceManager)FeedView.this.fResourceManager, FeedView.this.fTitleImageDescriptor));
                        }
                    });
                    break;
                }
            }
        };
        DynamicDAO.addEntityListener(IFeed.class, (EntityListener)this.fFeedListener);
        this.fBookMarkLoadListener = new Controller.BookMarkLoadListener(){

            public void bookMarkAboutToLoad(IBookMark bookmark) {
                if (!FeedView.this.fIsDisposed && bookmark.equals(FeedView.this.fInput.getMark())) {
                    FeedView.this.showBusyLoading(true);
                }
            }

            public void bookMarkDoneLoading(IBookMark bookmark) {
                if (!FeedView.this.fIsDisposed && bookmark.equals(FeedView.this.fInput.getMark())) {
                    FeedView.this.showBusyLoading(false);
                }
            }
        };
        Controller.getDefault().addBookMarkLoadListener(this.fBookMarkLoadListener);
    }

    private void showBusyLoading(final boolean busy) {
        JobRunner.runInUIThread((Widget)this.fParent, new Runnable(){

            public void run() {
                if (!FeedView.this.fIsDisposed && FeedView.this.getSite() instanceof PartSite) {
                    ((PartSite)FeedView.this.getSite()).getPane().setBusy(busy);
                }
            }
        });
    }

    private void onNewsFoldersUpdated(final Set<FolderEvent> events) {
        JobRunner.runInUIThread((Widget)this.fParent, new Runnable(){

            public void run() {
                if (!(FeedView.this.fInput.getMark() instanceof FolderNewsMark)) {
                    return;
                }
                IEditorPart activeFeedView = FeedView.this.fEditorSite.getPage().getActiveEditor();
                FolderNewsMark folderNewsMark = (FolderNewsMark)FeedView.this.fInput.getMark();
                for (FolderEvent event : events) {
                    IFolder folder = event.getEntity();
                    if (!folder.equals(folderNewsMark.getFolder())) continue;
                    FeedView.this.setPartName(folder.getName());
                    if (activeFeedView != FeedView.this) break;
                    OwlUI.updateWindowTitle((IMark)FeedView.this.fInput.getMark());
                    break;
                }
            }
        });
    }

    private void onFoldersDeleted(Set<FolderEvent> events) {
        if (!(this.fInput.getMark() instanceof FolderNewsMark)) {
            return;
        }
        FolderNewsMark folderNewsMark = (FolderNewsMark)this.fInput.getMark();
        for (FolderEvent event : events) {
            IFolder folder = event.getEntity();
            if (!folder.equals(folderNewsMark.getFolder())) continue;
            this.fInput.setDeleted();
            JobRunner.runInUIThread((Widget)this.fParent, new Runnable(){

                public void run() {
                    FeedView.this.fEditorSite.getPage().closeEditor((IEditorPart)FeedView.this, false);
                }
            });
            break;
        }
    }

    private void onNewsMarksUpdated(final Set<? extends MarkEvent> events) {
        JobRunner.runInUIThread((Widget)this.fParent, new Runnable(){

            public void run() {
                IEditorPart activeFeedView = FeedView.this.fEditorSite.getPage().getActiveEditor();
                for (MarkEvent event : events) {
                    IMark mark = event.getEntity();
                    if (!mark.getId().equals(FeedView.this.fInput.getMark().getId())) continue;
                    FeedView.this.setPartName(mark.getName());
                    if (activeFeedView != FeedView.this) break;
                    OwlUI.updateWindowTitle((IMark)FeedView.this.fInput.getMark());
                    break;
                }
            }
        });
    }

    private void onNewsMarksDeleted(Set<? extends MarkEvent> events) {
        for (MarkEvent markEvent : events) {
            IMark mark = markEvent.getEntity();
            if (!this.fInput.getMark().getId().equals(mark.getId())) continue;
            this.fInput.setDeleted();
            JobRunner.runInUIThread((Widget)this.fParent, new Runnable(){

                public void run() {
                    FeedView.this.fEditorSite.getPage().closeEditor((IEditorPart)FeedView.this, false);
                }
            });
            break;
        }
    }

    private void loadSettings(FeedViewInput input) {
        IPreferenceScope preferences = Owl.getPreferenceService().getEntityScope((IEntity)input.getMark());
        int iVal = preferences.getInteger(DefaultPreferences.BM_NEWS_FILTERING);
        this.fInitialFilterType = iVal >= 0 ? NewsFilter.Type.values()[iVal] : NewsFilter.Type.values()[this.fPreferences.getInteger(DefaultPreferences.FV_FILTER_TYPE)];
        iVal = preferences.getInteger(DefaultPreferences.BM_NEWS_GROUPING);
        this.fInitialGroupType = iVal >= 0 ? NewsGrouping.Type.values()[iVal] : NewsGrouping.Type.values()[this.fPreferences.getInteger(DefaultPreferences.FV_GROUP_TYPE)];
        this.fLayout = OwlUI.getLayout(preferences);
        this.fInitialWeights = this.fPreferences.getIntegers(DefaultPreferences.FV_SASHFORM_WEIGHTS);
        this.fInitialSearchTarget = NewsFilter.SearchTarget.values()[this.fPreferences.getInteger(DefaultPreferences.FV_SEARCH_TARGET)];
    }

    private void saveSettings() {
        int weightDiff;
        if (this.fCacheWeights != null && this.fCacheWeights[0] != this.fCacheWeights[1] && Math.abs(weightDiff = this.fInitialWeights[0] - this.fCacheWeights[0]) > 5) {
            int[] strWeights = new int[]{this.fCacheWeights[0], this.fCacheWeights[1]};
            this.fPreferences.putIntegers(DefaultPreferences.FV_SASHFORM_WEIGHTS, strWeights);
        }
    }

    private void createGlobalActions() {
        this.fReloadAction = new Action(){

            public void run() {
                new ReloadTypesAction((IStructuredSelection)new StructuredSelection((Object)FeedView.this.fInput.getMark()), FeedView.this.getEditorSite().getShell()).run();
            }
        };
        this.fSelectAllAction = new Action(){

            public void run() {
                Control focusControl = FeedView.this.fEditorSite.getShell().getDisplay().getFocusControl();
                if (focusControl instanceof Text) {
                    ((Text)focusControl).selectAll();
                } else {
                    ((Tree)FeedView.this.fNewsTableControl.getViewer().getControl()).selectAll();
                    FeedView.this.fNewsTableControl.getViewer().setSelection(FeedView.this.fNewsTableControl.getViewer().getSelection());
                }
            }
        };
        this.fDeleteAction = new Action(){

            public void run() {
                new DeleteTypesAction(FeedView.this.fParent.getShell(), (IStructuredSelection)FeedView.this.fNewsTableControl.getViewer().getSelection()).run();
            }
        };
        this.fCutAction = new Action(){

            public void run() {
                Control focusControl = FeedView.this.fEditorSite.getShell().getDisplay().getFocusControl();
                if (focusControl instanceof Text) {
                    ((Text)focusControl).cut();
                }
            }
        };
        this.fCopyAction = new Action(){

            public void run() {
                Control focusControl = FeedView.this.fEditorSite.getShell().getDisplay().getFocusControl();
                if (focusControl instanceof Text) {
                    ((Text)focusControl).copy();
                }
            }
        };
        this.fPasteAction = new Action(){

            public void run() {
                Control focusControl = FeedView.this.fEditorSite.getShell().getDisplay().getFocusControl();
                if (focusControl instanceof Text) {
                    ((Text)focusControl).paste();
                }
            }
        };
        this.fPrintAction = new Action(){

            public void run() {
                FeedView.this.print();
            }
        };
        this.fUndoAction = new Action(){

            public void run() {
                UndoStack.getInstance().undo();
            }
        };
        this.fRedoAction = new Action(){

            public void run() {
                UndoStack.getInstance().redo();
            }
        };
        this.fFindAction = new FindAction();
    }

    public void print() {
        if (!this.isBrowserViewerVisible()) {
            MessageDialog.openInformation((Shell)this.fRootComposite.getShell(), (String)Messages.FeedView_PRINT_NEWS, (String)Messages.FeedView_PRINT_NEWS_HEADLINES_LAYOUT);
            return;
        }
        if (this.fNewsBrowserControl != null) {
            this.fNewsBrowserControl.getViewer().getBrowser().print();
        }
    }

    public void find() {
        if (this.fFilterBar != null) {
            if (!this.fFilterBar.isVisible()) {
                this.fPreferences.putBoolean(DefaultPreferences.FV_FEED_TOOLBAR_HIDDEN, false);
                EditorUtils.updateToolbarVisibility();
            }
            this.fFilterBar.focusQuickSearch();
        }
    }

    private void setGlobalActions() {
        this.fEditorSite.getActionBars().setGlobalActionHandler("org.rssowl.ui.actions.Reload", this.fReloadAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.fSelectAllAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), this.fDeleteAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.fCutAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.fCopyAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.fPasteAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), this.fPrintAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), this.fUndoAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), this.fRedoAction);
        this.fEditorSite.getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), this.fFindAction);
        this.fEditorSite.getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId()).setEnabled(false);
        this.fEditorSite.getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()).setEnabled(false);
        this.fEditorSite.getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId()).setEnabled(false);
    }

    public void setSelection(final IStructuredSelection selection) {
        final AtomicBoolean unfilter = new AtomicBoolean(false);
        if (this.fNewsFilter.getType() != NewsFilter.Type.SHOW_ALL) {
            List elements = selection.toList();
            for (Object element : elements) {
                if (element instanceof NewsReference) {
                    INews news = this.fContentProvider.obtainFromCache(((NewsReference)element).getId());
                    element = news != null ? news : ((NewsReference)element).resolve();
                }
                if (this.fNewsFilter.select((Viewer)this.fNewsTableControl.getViewer(), null, element)) continue;
                unfilter.set(true);
                break;
            }
        }
        if (unfilter.get()) {
            Runnable joinUIRunnable = new Runnable(){

                public void run() {
                    FeedView.this.internalShowSelection(selection, unfilter);
                }
            };
            this.fFilterBar.doFilter(NewsFilter.Type.SHOW_ALL, true, false, joinUIRunnable);
        } else {
            this.internalShowSelection(selection, unfilter);
        }
    }

    private void internalShowSelection(final IStructuredSelection selection, final AtomicBoolean unfilter) {
        if (!this.isTableViewerVisible()) {
            JobRunner.runInUIThread(100, (Widget)this.fNewsBrowserControl.getViewer().getControl(), new Runnable(){

                public void run() {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            FeedView.this.fNewsBrowserControl.getViewer().showSelection((ISelection)selection);
                        }
                    };
                    if (unfilter.get()) {
                        FeedView.this.fNewsBrowserControl.getViewer().refresh();
                        JobRunner.runInUIThread(100, (Widget)FeedView.this.fNewsBrowserControl.getViewer().getControl(), runnable);
                    } else {
                        runnable.run();
                    }
                }
            });
        } else {
            this.fNewsTableControl.getViewer().setSelection((ISelection)selection, true);
        }
    }

    public void setInput(IEditorInput input) {
        Assert.isTrue((boolean)(input instanceof FeedViewInput));
        if (this.fCreated) {
            Collection<INews> cachedNewsCopy = this.fContentProvider.getCachedNewsCopy();
            Job.getJobManager().cancel(this.fCacheJobIdentifier);
            this.fContentProvider.dispose();
            if (this.fInput != null) {
                this.notifyUIEvent(UIEvent.FEED_CHANGE, cachedNewsCopy);
                this.rememberSelection((IMark)this.fInput.getMark(), this.fNewsTableControl.getLastSelection());
            }
        }
        super.setInput(input);
        this.fInput = (FeedViewInput)input;
        if (!this.fCreated) {
            this.updateTab(this.fInput);
        }
        if (this.fFilterBar != null) {
            this.fFilterBar.clearQuickSearch(false);
        }
        if (this.fCreated) {
            this.firePropertyChange(258);
            this.updateFilterAndGrouping(false);
            this.fContentProvider = new NewsContentProvider(this.fNewsTableControl.getViewer(), this.fNewsBrowserControl.getViewer(), this);
            this.fNewsTableControl.getViewer().setContentProvider((IContentProvider)this.fContentProvider);
            this.fNewsTableControl.onInputChanged(this.fInput);
            this.fNewsBrowserControl.getViewer().setContentProvider((IContentProvider)this.fContentProvider);
            this.fNewsBrowserControl.onInputChanged(this.fInput);
            if (this.fNewsFilter.isPatternSet()) {
                this.fNewsFilter.setPattern("");
            }
            this.fNewsFilter.setNewsMark(this.fInput.getMark());
            this.setInput(this.fInput.getMark(), true);
        }
    }

    private void updateTab(FeedViewInput input) {
        this.setPartName(input.getName());
        this.fTitleImageDescriptor = input.getImageDescriptor();
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResourceManager, this.fTitleImageDescriptor));
    }

    public void updateFilterAndGrouping(boolean refresh) {
        IPreferenceScope preferences = Owl.getPreferenceService().getEntityScope((IEntity)this.fInput.getMark());
        int iVal = preferences.getInteger(DefaultPreferences.BM_NEWS_FILTERING);
        if (iVal >= 0) {
            this.fFilterBar.doFilter(NewsFilter.Type.values()[iVal], refresh, false);
        } else {
            this.fFilterBar.doFilter(NewsFilter.Type.values()[this.fPreferences.getInteger(DefaultPreferences.FV_FILTER_TYPE)], refresh, false);
        }
        iVal = preferences.getInteger(DefaultPreferences.BM_NEWS_GROUPING);
        if (iVal >= 0) {
            this.fFilterBar.doGrouping(NewsGrouping.Type.values()[iVal], refresh, false);
        } else {
            this.fFilterBar.doGrouping(NewsGrouping.Type.values()[this.fPreferences.getInteger(DefaultPreferences.FV_GROUP_TYPE)], refresh, false);
        }
    }

    public void updateColumns() {
        if (this.fInput == null) {
            return;
        }
        if (this.fInput.getMark() instanceof FolderNewsMark && this.fInput.getMark().getNewsCount(INews.State.getVisible()) > 500) {
            FolderNewsMark folderMark = (FolderNewsMark)this.fInput.getMark();
            IPreferenceScope preferences = Owl.getPreferenceService().getEntityScope((IEntity)folderMark.getFolder());
            NewsComparator comparator = this.getComparator();
            NewsColumn oldSortBy = comparator.getSortBy();
            boolean oldIsAscending = comparator.isAscending();
            NewsColumn newSortBy = NewsColumn.values()[preferences.getInteger(DefaultPreferences.BM_NEWS_SORT_COLUMN)];
            boolean newIsAscending = preferences.getBoolean(DefaultPreferences.BM_NEWS_SORT_ASCENDING);
            if (oldSortBy != newSortBy || oldIsAscending != newIsAscending) {
                NewsComparator comparer = new NewsComparator();
                comparer.setSortBy(newSortBy);
                comparer.setAscending(newIsAscending);
                this.fContentProvider.refreshCache(null, folderMark, comparer);
            }
        }
        if (this.isTableViewerVisible()) {
            this.fNewsTableControl.updateColumns(this.fInput.getMark());
        }
        if (this.isBrowserViewerVisible()) {
            this.fNewsBrowserControl.updateSorting(this.fInput.getMark(), true);
        }
    }

    public void notifyUIEvent(UIEvent event) {
        this.notifyUIEvent(event, null);
    }

    private void notifyUIEvent(final UIEvent event, Collection<INews> visibleNews) {
        INewsMark inputMark = this.fInput.getMark();
        IStructuredSelection lastSelection = this.fNewsTableControl.getLastSelection();
        if (Controller.getDefault().isEmergencyShutdown()) {
            return;
        }
        if (Controller.getDefault().isRestarting()) {
            if (event == UIEvent.TAB_CLOSE && this.fInput.exists()) {
                this.rememberSelection((IMark)inputMark, lastSelection);
            }
            return;
        }
        if (Controller.getDefault().isShuttingDown()) {
            if (event == UIEvent.TAB_CLOSE && this.fInput.exists()) {
                this.rememberSelection((IMark)inputMark, lastSelection);
            }
            if (event != UIEvent.CLOSE) {
                return;
            }
        }
        final Collection<INews> news = visibleNews != null ? this.filterHidden(visibleNews) : this.filterHidden(this.fContentProvider.getCachedNewsCopy());
        IPreferenceScope inputPreferences = Owl.getPreferenceService().getEntityScope((IEntity)inputMark);
        if (news.isEmpty() || !this.fInput.exists()) {
            return;
        }
        final boolean markReadOnFeedChange = inputPreferences.getBoolean(DefaultPreferences.MARK_READ_ON_CHANGE);
        final boolean markReadOnTabClose = inputPreferences.getBoolean(DefaultPreferences.MARK_READ_ON_TAB_CLOSE);
        final boolean markReadOnMinimize = inputPreferences.getBoolean(DefaultPreferences.MARK_READ_ON_MINIMIZE);
        if (event == UIEvent.CLOSE) {
            ArrayList<INews> newsToUpdate = new ArrayList<INews>();
            for (INews newsItem : news) {
                if (newsItem.getState() != INews.State.NEW) continue;
                newsToUpdate.add(newsItem);
            }
            this.fNewsDao.setState(newsToUpdate, INews.State.UNREAD, OwlUI.markReadDuplicates(), false);
        } else if (event == UIEvent.FEED_CHANGE || event == UIEvent.MINIMIZE || event == UIEvent.TAB_CLOSE) {
            if (event == UIEvent.FEED_CHANGE && fgBlockFeedChangeEvent) {
                return;
            }
            int delay = 100;
            if (event == UIEvent.TAB_CLOSE) {
                delay += 100;
            }
            JobRunner.runInBackgroundThread(delay, new Runnable((IMark)inputMark, lastSelection){
                private final /* synthetic */ IMark val$inputMark;
                private final /* synthetic */ IStructuredSelection val$lastSelection;
                {
                    this.val$inputMark = iMark;
                    this.val$lastSelection = iStructuredSelection;
                }

                public void run() {
                    if (Controller.getDefault().isShuttingDown()) {
                        return;
                    }
                    boolean markRead = false;
                    switch (event) {
                        case FEED_CHANGE: {
                            markRead = markReadOnFeedChange;
                            break;
                        }
                        case TAB_CLOSE: {
                            markRead = markReadOnTabClose;
                            break;
                        }
                        case MINIMIZE: {
                            markRead = markReadOnMinimize;
                        }
                    }
                    ArrayList<INews> newsToUpdate = new ArrayList<INews>();
                    for (INews newsItem : news) {
                        if (newsItem.getState() == INews.State.NEW) {
                            newsToUpdate.add(newsItem);
                            continue;
                        }
                        if (!markRead || newsItem.getState() != INews.State.UPDATED && newsItem.getState() != INews.State.UNREAD) continue;
                        newsToUpdate.add(newsItem);
                    }
                    if (!newsToUpdate.isEmpty()) {
                        if (event == UIEvent.FEED_CHANGE || event == UIEvent.TAB_CLOSE) {
                            Controller.getDefault().getSavedSearchService().forceQuickUpdate();
                        }
                        UndoStack.getInstance().addOperation(new NewsStateOperation(newsToUpdate, markRead ? INews.State.READ : INews.State.UNREAD, OwlUI.markReadDuplicates()));
                        FeedView.this.fNewsDao.setState(newsToUpdate, markRead ? INews.State.READ : INews.State.UNREAD, OwlUI.markReadDuplicates(), false);
                    }
                    if (this.val$inputMark instanceof IBookMark) {
                        Object obj;
                        if ((event == UIEvent.FEED_CHANGE || event == UIEvent.MINIMIZE) && this.val$lastSelection != null && !this.val$lastSelection.isEmpty() && (obj = this.val$lastSelection.getFirstElement()) instanceof INews) {
                            news.remove(obj);
                        }
                        FeedView.this.performCleanUp((IBookMark)this.val$inputMark, news);
                    }
                    if (event == UIEvent.TAB_CLOSE) {
                        FeedView.this.rememberSelection(this.val$inputMark, this.val$lastSelection);
                    }
                }
            });
        }
    }

    private Collection<INews> filterHidden(Collection<INews> news) {
        NewsBrowserViewModel model;
        if ((this.fLayout == OwlUI.Layout.NEWSPAPER || this.fLayout == OwlUI.Layout.HEADLINES) && (model = this.fNewsBrowserControl.getViewer().getViewModel()) != null) {
            Iterator<INews> iterator = news.iterator();
            while (iterator.hasNext()) {
                Long id = iterator.next().getId();
                if (id == null || model.hasNews(id)) continue;
                iterator.remove();
            }
        }
        return news;
    }

    public boolean isHidden(INews news) {
        Long id = news.getId();
        return id != null && this.isHidden(id);
    }

    public boolean isHidden(NewsReference reference) {
        return this.isHidden(reference.getId());
    }

    private boolean isHidden(long newsId) {
        NewsBrowserViewModel model;
        if ((this.fLayout == OwlUI.Layout.NEWSPAPER || this.fLayout == OwlUI.Layout.HEADLINES) && (model = this.fNewsBrowserControl.getViewer().getViewModel()) != null) {
            return !model.hasNews(newsId);
        }
        return false;
    }

    public boolean contains(INews news) {
        return this.fContentProvider != null && this.fContentProvider.hasCachedNews(news);
    }

    public Collection<INews> getCachedNewsCopy() {
        return this.fContentProvider != null ? this.fContentProvider.getCachedNewsCopy() : Collections.emptyList();
    }

    private void performCleanUp(IBookMark bookmark, Collection<INews> news) {
        if (System.currentTimeMillis() - this.fLastCleanUpRun.get() > 1000L) {
            RetentionStrategy.process((IBookMark)bookmark, news);
            this.fLastCleanUpRun.set(System.currentTimeMillis());
        }
    }

    private void onInputSet() {
        PerformAfterInputSet perform = this.fInput.getPerformOnInputSet();
        this.perform(perform);
        JobRunner.runInBackgroundThread(new Runnable(){

            public void run() {
                if (FeedView.this.fInput == null) {
                    return;
                }
                INewsMark mark = FeedView.this.fInput.getMark();
                if (mark instanceof IBookMark) {
                    IBookMark bookmark = (IBookMark)mark;
                    if ((bookmark.getLastVisitDate() == null || bookmark.isErrorLoading()) && !FeedView.this.fContentProvider.hasCachedNews()) {
                        new ReloadTypesAction((IStructuredSelection)new StructuredSelection((Object)mark), FeedView.this.getEditorSite().getShell()).run();
                    }
                } else if (mark instanceof FolderNewsMark) {
                    IFolder folder = ((FolderNewsMark)mark).getFolder();
                    ArrayList bookMarksToReload = new ArrayList();
                    FeedView.this.fillBookMarksToReload(bookMarksToReload, folder);
                    if (!bookMarksToReload.isEmpty()) {
                        new ReloadTypesAction((IStructuredSelection)new StructuredSelection(bookMarksToReload.toArray()), FeedView.this.getEditorSite().getShell()).run();
                    }
                }
                if (mark instanceof IBookMark) {
                    ((IBookMarkDAO)DynamicDAO.getDAO(IBookMarkDAO.class)).visited((IBookMark)mark);
                } else if (mark instanceof ISearchMark) {
                    ((ISearchMarkDAO)DynamicDAO.getDAO(ISearchMarkDAO.class)).visited((ISearchMark)mark);
                } else if (mark instanceof INewsBin) {
                    ((INewsBinDAO)DynamicDAO.getDAO(INewsBinDAO.class)).visited((INewsBin)mark);
                }
            }
        });
    }

    public void perform(PerformAfterInputSet perform) {
        if (perform != null) {
            if (perform.getType() == PerformAfterInputSet.Kind.SELECT_FIRST_NEWS) {
                if (this.fLayout != OwlUI.Layout.NEWSPAPER) {
                    this.navigate(false, true, true, false);
                }
            } else if (perform.getType() == PerformAfterInputSet.Kind.SELECT_UNREAD_NEWS) {
                this.navigate(false, true, true, true);
            } else if (perform.getType() == PerformAfterInputSet.Kind.SELECT_SPECIFIC_NEWS) {
                this.setSelection((IStructuredSelection)new StructuredSelection((Object)perform.getNewsToSelect()));
            }
            if (perform.shouldActivate()) {
                this.fEditorSite.getPage().activate(this.fEditorSite.getPart());
            }
        }
    }

    private void fillBookMarksToReload(List<IBookMark> bookMarksToReload, IFolder folder) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            if (!(mark instanceof IBookMark) || ((IBookMark)mark).getMostRecentNewsDate() != null) continue;
            bookMarksToReload.add((IBookMark)mark);
        }
        List childs = folder.getFolders();
        for (IFolder child : childs) {
            this.fillBookMarksToReload(bookMarksToReload, child);
        }
    }

    private void setInput(final INewsMark mark, final boolean reused) {
        JobRunner.runUIUpdater(new UIBackgroundJob((Control)this.fParent){
            private IProgressMonitor fBgMonitor;

            public boolean belongsTo(Object family) {
                return FeedView.this.fCacheJobIdentifier.equals(family);
            }

            protected void runInBackground(IProgressMonitor monitor) {
                this.fBgMonitor = monitor;
                if (!monitor.isCanceled()) {
                    FeedView.this.fContentProvider.refreshCache(monitor, mark);
                }
            }

            protected void runInUI(IProgressMonitor monitor) {
                StructuredSelection oldSelection = null;
                IPreferenceScope entityPreferences = Owl.getPreferenceService().getEntityScope((IEntity)mark);
                long value = entityPreferences.getLong(DefaultPreferences.NM_SELECTED_NEWS);
                if (value > 0L) {
                    boolean isListLayout = OwlUI.getLayout(entityPreferences) == OwlUI.Layout.LIST;
                    boolean openEmptyNews = entityPreferences.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_EMPTY_NEWS);
                    boolean openAllNews = entityPreferences.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_NEWS);
                    boolean useTransformer = entityPreferences.getBoolean(DefaultPreferences.BM_USE_TRANSFORMER);
                    boolean useExternalBrowser = OwlUI.useExternalBrowser();
                    if (!useExternalBrowser || isListLayout || useTransformer || !openAllNews && !openEmptyNews) {
                        oldSelection = new StructuredSelection((Object)new NewsReference(value));
                    }
                }
                if (reused) {
                    FeedView.this.updateLayout(false);
                }
                if (reused) {
                    FeedView.this.fNewsBrowserControl.setInfoBarVisible(false);
                }
                if (!this.fBgMonitor.isCanceled() && FeedView.this.isTableViewerVisible()) {
                    FeedView.this.stableSetInputToNewsTable(mark, oldSelection);
                } else if (!this.fBgMonitor.isCanceled() && reused) {
                    FeedView.this.fNewsTableControl.setPartInput(null);
                }
                if (!this.fBgMonitor.isCanceled() && !FeedView.this.isTableViewerVisible()) {
                    FeedView.this.fNewsBrowserControl.setPartInput(mark);
                } else if (!this.fBgMonitor.isCanceled() && oldSelection != null && FeedView.this.isBrowserViewerVisible()) {
                    ISelection selection = FeedView.this.fNewsTableControl.getViewer().getSelection();
                    if (!selection.isEmpty()) {
                        FeedView.this.fNewsBrowserControl.setPartInput(oldSelection.getFirstElement());
                    }
                } else if (!this.fBgMonitor.isCanceled() && reused) {
                    FeedView.this.fNewsBrowserControl.setPartInput(null);
                }
                if (reused) {
                    FeedView.this.updateTab(FeedView.this.fInput);
                }
                FeedView.this.onInputSet();
            }
        });
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setFocus() {
        if (this.isTableViewerVisible()) {
            this.fNewsTableControl.setFocus();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    FeedView.this.fNewsBrowserControl.setFocus();
                }
            };
            Browser browser = this.fNewsBrowserControl.getViewer().getBrowser().getControl();
            if (!StringUtils.isSet((String)browser.getUrl())) {
                JobRunner.runDelayedInUIThread((Widget)browser, runnable);
            } else {
                runnable.run();
            }
        }
    }

    public void dispose() {
        this.saveSettings();
        this.unregisterListeners();
        super.dispose();
        this.fContentProvider.dispose();
        this.fNewsTableControl.dispose();
        this.fNewsBrowserControl.dispose();
        this.fResourceManager.dispose();
        this.fIsDisposed = true;
    }

    private void unregisterListeners() {
        this.fEditorSite.getPage().removePartListener(this.fPartListener);
        DynamicDAO.removeEntityListener(IBookMark.class, (EntityListener)this.fBookMarkListener);
        DynamicDAO.removeEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
        DynamicDAO.removeEntityListener(ISearchMark.class, (EntityListener)this.fSearchMarkListener);
        DynamicDAO.removeEntityListener(IFeed.class, (EntityListener)this.fFeedListener);
        DynamicDAO.removeEntityListener(ISearchCondition.class, (EntityListener)this.fSearchConditionListener);
        DynamicDAO.removeEntityListener(INewsBin.class, (EntityListener)this.fNewsBinListener);
        Controller.getDefault().removeBookMarkLoadListener(this.fBookMarkLoadListener);
    }

    public void updateLayout() {
        this.fRootComposite.setRedraw(false);
        try {
            this.updateLayout(true);
        }
        finally {
            this.fRootComposite.setRedraw(true);
        }
    }

    private void updateLayout(boolean updateInput) {
        IPreferenceScope preferences = Owl.getPreferenceService().getEntityScope((IEntity)this.fInput.getMark());
        OwlUI.Layout layout = OwlUI.getLayout(preferences);
        if (this.fLayout == layout) {
            return;
        }
        this.fFilterBar.doLayout(layout, false);
        this.fNewsTableControl.onLayoutChanged(layout);
        this.fNewsBrowserControl.onLayoutChanged(layout);
        if (layout == OwlUI.Layout.CLASSIC) {
            this.restoreTable(updateInput);
            this.fSashForm.setOrientation(512);
        } else if (layout == OwlUI.Layout.VERTICAL) {
            this.restoreTable(updateInput);
            this.fSashForm.setOrientation(256);
        } else if (layout == OwlUI.Layout.LIST) {
            this.maximizeTable(updateInput);
        } else if (layout == OwlUI.Layout.NEWSPAPER || layout == OwlUI.Layout.HEADLINES) {
            this.maximizeBrowser(updateInput);
            if (updateInput && (this.fLayout == OwlUI.Layout.NEWSPAPER || this.fLayout == OwlUI.Layout.HEADLINES)) {
                this.refreshBrowserViewer();
            }
        }
        this.updateSeparators(layout);
        this.fNewsBrowserControl.setInfoBarVisible(false);
        this.fNewsTableControlContainer.layout();
        this.fBrowserViewerControlContainer.layout();
        this.fLayout = layout;
    }

    private void maximizeTable(boolean updateInput) {
        Control maximizedControl = this.fSashForm.getMaximizedControl();
        if (this.fNewsTableControlContainer.equals(maximizedControl)) {
            return;
        }
        this.fSashForm.setMaximizedControl((Control)this.fNewsTableControlContainer);
        if (updateInput) {
            if (this.fBrowserViewerControlContainer.equals(maximizedControl)) {
                this.fNewsTableControl.setPartInput(this.fInput.getMark());
                this.fNewsTableControl.adjustScrollPosition();
                if (this.fNewsGrouping.getType() != NewsGrouping.Type.NO_GROUPING) {
                    this.expandNewsTableViewerGroups(true, (ISelection)StructuredSelection.EMPTY);
                }
            }
            this.fNewsBrowserControl.setPartInput(null);
        }
        this.fNewsTableControl.setFocus();
    }

    private void maximizeBrowser(boolean updateInput) {
        Control maximizedControl = this.fSashForm.getMaximizedControl();
        if (this.fBrowserViewerControlContainer.equals(maximizedControl)) {
            return;
        }
        this.fSashForm.setMaximizedControl((Control)this.fBrowserViewerControlContainer);
        if (updateInput) {
            this.fNewsTableControl.getViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            this.fNewsBrowserControl.setPartInput(this.fInput.getMark());
            this.fNewsTableControl.setPartInput(null);
        }
        this.fNewsBrowserControl.setFocus();
    }

    private void restoreTable(boolean updateInput) {
        Control maximizedControl = this.fSashForm.getMaximizedControl();
        if (maximizedControl == null) {
            return;
        }
        this.fSashForm.setMaximizedControl(null);
        if (updateInput) {
            this.fNewsTableControl.setPartInput(this.fInput.getMark());
            this.fNewsTableControl.adjustScrollPosition();
            if (this.fNewsGrouping.getType() != NewsGrouping.Type.NO_GROUPING) {
                this.expandNewsTableViewerGroups(true, (ISelection)StructuredSelection.EMPTY);
            }
            this.fNewsBrowserControl.setPartInput(null);
        }
        this.fNewsTableControl.setFocus();
    }

    private void updateSeparators(OwlUI.Layout layout) {
        boolean showFilterTableSeparator = false;
        if (!Application.IS_MAC || layout != OwlUI.Layout.CLASSIC) {
            showFilterTableSeparator = this.fFilterBar.isVisible();
        }
        ((GridData)this.fHorizontalFilterTableSep.getLayoutData()).exclude = !showFilterTableSeparator;
        ((GridData)this.fVerticalTableBrowserSep.getLayoutData()).exclude = layout != OwlUI.Layout.VERTICAL;
        ((GridData)this.fHorizontalTableBrowserSep.getLayoutData()).exclude = layout != OwlUI.Layout.CLASSIC;
        boolean bl = ((GridData)this.fVerticalBrowserSep.getLayoutData()).exclude = layout != OwlUI.Layout.VERTICAL;
        if (layout == OwlUI.Layout.CLASSIC) {
            this.fHorizontalBrowserSep.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            ((GridData)this.fHorizontalBrowserSep.getLayoutData()).exclude = false;
        } else if (layout == OwlUI.Layout.VERTICAL) {
            this.fHorizontalBrowserSep.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
            ((GridData)this.fHorizontalBrowserSep.getLayoutData()).exclude = !this.fBrowserBar.isVisible();
        } else if (layout == OwlUI.Layout.NEWSPAPER || layout == OwlUI.Layout.HEADLINES) {
            this.fHorizontalBrowserSep.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            ((GridData)this.fHorizontalBrowserSep.getLayoutData()).exclude = !this.fBrowserBar.isVisible();
        }
        this.fHorizontalFilterTableSep.setVisible(!((GridData)this.fHorizontalFilterTableSep.getLayoutData()).exclude);
        this.fVerticalTableBrowserSep.setVisible(!((GridData)this.fVerticalTableBrowserSep.getLayoutData()).exclude);
        this.fHorizontalTableBrowserSep.setVisible(!((GridData)this.fHorizontalTableBrowserSep.getLayoutData()).exclude);
        this.fVerticalBrowserSep.setVisible(!((GridData)this.fVerticalBrowserSep.getLayoutData()).exclude);
        this.fHorizontalBrowserSep.setVisible(!((GridData)this.fHorizontalBrowserSep.getLayoutData()).exclude);
    }

    public void updateToolbarVisibility() {
        this.fFilterBar.updateVisibility();
        this.fBrowserBar.updateVisibility();
        this.updateSeparators(this.fLayout);
        this.fRootComposite.layout(true, true);
    }

    public void toggleNewspaperLayout() {
        boolean isClassicLayout;
        boolean isNewspaperLayout = !this.isTableViewerVisible();
        boolean bl = isClassicLayout = (this.fSashForm.getOrientation() & 0x200) != 0;
        OwlUI.Layout newLayout = isNewspaperLayout ? (isClassicLayout ? OwlUI.Layout.CLASSIC : OwlUI.Layout.VERTICAL) : OwlUI.Layout.NEWSPAPER;
        FeedViewInput input = (FeedViewInput)this.getEditorInput();
        IPreferenceScope entityPreferences = input.getMark() instanceof FolderNewsMark ? Owl.getPreferenceService().getEntityScope((IEntity)((FolderNewsMark)input.getMark()).getFolder()) : Owl.getPreferenceService().getEntityScope((IEntity)input.getMark());
        if (entityPreferences.hasKey(DefaultPreferences.FV_LAYOUT)) {
            entityPreferences.putInteger(DefaultPreferences.FV_LAYOUT, newLayout.ordinal());
            entityPreferences.flush();
            this.updateLayout();
        } else {
            this.fPreferences.putInteger(DefaultPreferences.FV_LAYOUT, newLayout.ordinal());
            EditorUtils.updateLayout();
        }
    }

    void refresh(boolean delayRedraw, boolean updateLabels) {
        this.refreshTableViewer(delayRedraw, updateLabels);
        this.refreshBrowserViewer();
    }

    void handleQuicksearchTraversalEvent(int traversal, boolean clear) {
        if ((traversal & 4) != 0) {
            if (this.isTableViewerVisible()) {
                Tree tree = (Tree)this.fNewsTableControl.getViewer().getControl();
                if (tree.getItemCount() > 0) {
                    IStructuredSelection lastSelection = this.fNewsTableControl.getLastNonEmptySelection();
                    if (lastSelection.isEmpty() || !clear) {
                        lastSelection = new StructuredSelection(tree.getItem(0).getData());
                    }
                    this.fNewsTableControl.getViewer().setSelection((ISelection)lastSelection);
                    this.fNewsTableControl.setFocus();
                }
            } else {
                this.fNewsBrowserControl.setFocus();
            }
        } else if ((traversal & 0x200) != 0 || (traversal & 0x100) != 0) {
            this.setFocus();
        }
    }

    void refreshTableViewer(boolean delayRedraw, boolean updateLabels) {
        if (Controller.getDefault().isShuttingDown()) {
            return;
        }
        if (this.isTableViewerVisible()) {
            boolean groupingEnabled = this.fNewsGrouping.getType() != NewsGrouping.Type.NO_GROUPING;
            StructuredSelection selection = StructuredSelection.EMPTY;
            if (groupingEnabled) {
                selection = this.fNewsTableControl.getViewer().getSelection();
            }
            if (delayRedraw) {
                this.fNewsTableControl.getViewer().getControl().getParent().setRedraw(false);
            }
            try {
                this.fNewsTableControl.getViewer().refresh(updateLabels);
                if (groupingEnabled) {
                    this.expandNewsTableViewerGroups(false, (ISelection)selection);
                }
            }
            finally {
                if (delayRedraw) {
                    this.fNewsTableControl.getViewer().getControl().getParent().setRedraw(true);
                }
            }
        }
    }

    private void expandNewsTableViewerGroups(boolean delayRedraw, ISelection oldSelection) {
        TreeItem topItem;
        NewsTableViewer viewer = this.fNewsTableControl.getViewer();
        Tree tree = (Tree)viewer.getControl();
        TreeItem treeItem = topItem = oldSelection.isEmpty() ? tree.getTopItem() : null;
        if (delayRedraw) {
            tree.getParent().setRedraw(false);
        }
        try {
            viewer.expandAll();
            if (!oldSelection.isEmpty() && viewer.getSelection().isEmpty()) {
                viewer.setSelection(oldSelection, true);
            } else if (topItem != null) {
                tree.setTopItem(topItem);
            }
        }
        finally {
            if (delayRedraw) {
                tree.getParent().setRedraw(true);
            }
        }
    }

    private void stableSetInputToNewsTable(Object input, ISelection oldSelection) {
        NewsTableViewer viewer = this.fNewsTableControl.getViewer();
        Tree tree = (Tree)viewer.getControl();
        tree.getParent().setRedraw(false);
        try {
            this.fNewsTableControl.setPartInput(input);
            if (oldSelection != null) {
                this.fNewsTableControl.setBlockNewsStateTracker(true);
                try {
                    viewer.setSelection(oldSelection);
                }
                finally {
                    this.fNewsTableControl.setBlockNewsStateTracker(false);
                }
            }
            this.fNewsTableControl.adjustScrollPosition();
        }
        finally {
            tree.getParent().setRedraw(true);
        }
    }

    private void rememberSelection(final IMark inputMark, final IStructuredSelection selection) {
        SafeRunnable.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                Object obj;
                IPreferenceScope inputPrefs = Owl.getPreferenceService().getEntityScope((IEntity)inputMark);
                long oldSelectionValue = inputPrefs.getLong(DefaultPreferences.NM_SELECTED_NEWS);
                long newSelectionValue = 0L;
                if (!selection.isEmpty() && (obj = selection.getFirstElement()) instanceof INews) {
                    newSelectionValue = ((INews)obj).getId();
                }
                boolean needToSave = false;
                if (newSelectionValue > 0L) {
                    if (oldSelectionValue != newSelectionValue) {
                        needToSave = true;
                        inputPrefs.putLong(DefaultPreferences.NM_SELECTED_NEWS, newSelectionValue);
                    }
                } else if (oldSelectionValue > 0L) {
                    needToSave = true;
                    inputPrefs.delete(DefaultPreferences.NM_SELECTED_NEWS);
                }
                Object entityToSave = FeedView.this.fInput.getMark() instanceof FolderNewsMark ? ((FolderNewsMark)FeedView.this.fInput.getMark()).getFolder() : FeedView.this.fInput.getMark();
                if (needToSave) {
                    DynamicDAO.save((IPersistable)entityToSave);
                }
            }
        });
    }

    void refreshBrowserViewer() {
        if (Controller.getDefault().isShuttingDown()) {
            return;
        }
        if (this.isBrowserViewerVisible()) {
            this.fNewsBrowserControl.getViewer().refresh();
        }
    }

    boolean isTableViewerVisible() {
        return this.fSashForm.getMaximizedControl() == null || this.fSashForm.getMaximizedControl() == this.fNewsTableControlContainer;
    }

    boolean isBrowserViewerVisible() {
        return this.fSashForm.getMaximizedControl() == null || this.fSashForm.getMaximizedControl() == this.fBrowserViewerControlContainer;
    }

    NewsFilter getFilter() {
        return this.fNewsFilter;
    }

    NewsComparator getComparator() {
        if (this.isTableViewerVisible()) {
            return (NewsComparator)this.fNewsTableControl.getViewer().getComparator();
        }
        return (NewsComparator)this.fNewsBrowserControl.getViewer().getComparator();
    }

    NewsGrouping getGrouper() {
        return this.fNewsGrouping;
    }

    NewsBrowserControl getNewsBrowserControl() {
        return this.fNewsBrowserControl;
    }

    NewsTableControl getNewsTableControl() {
        return this.fNewsTableControl;
    }

    public void createPartControl(Composite parent) {
        this.fCreated = true;
        this.fParent = parent;
        this.fNewsFilter = new NewsFilter();
        this.fNewsFilter.setType(this.fInitialFilterType);
        this.fNewsFilter.setSearchTarget(this.fInitialSearchTarget);
        this.fNewsFilter.setNewsMark(this.fInput.getMark());
        this.fNewsGrouping = new NewsGrouping();
        this.fNewsGrouping.setType(this.fInitialGroupType);
        this.fRootComposite = new Composite(this.fParent, 0);
        this.fRootComposite.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        ((GridLayout)this.fRootComposite.getLayout()).verticalSpacing = 0;
        this.fFilterBar = new FilterBar(this, this.fRootComposite);
        boolean showSeparator = false;
        if (!Application.IS_MAC || this.fLayout != OwlUI.Layout.CLASSIC) {
            showSeparator = this.fFilterBar.isVisible();
        }
        this.fHorizontalFilterTableSep = new Label(this.fRootComposite, 258);
        this.fHorizontalFilterTableSep.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fHorizontalFilterTableSep.getLayoutData()).exclude = !showSeparator;
        this.fHorizontalFilterTableSep.setVisible(showSeparator);
        boolean useClassicLayout = this.fLayout != OwlUI.Layout.VERTICAL;
        this.fSashForm = new SashForm(this.fRootComposite, (useClassicLayout ? 512 : 256) | 0x10000);
        this.fSashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fNewsTableControlContainer = new Composite((Composite)this.fSashForm, 0);
        this.fNewsTableControlContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 0, false));
        this.fNewsTableControlContainer.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FeedView.this.fCacheWeights = FeedView.this.fSashForm.getWeights();
            }
        });
        this.fNewsTableControl = new NewsTableControl();
        this.fNewsTableControl.init(this.fFeedViewSite);
        this.fNewsTableControl.onInputChanged(this.fInput);
        this.fNewsTableControl.createPart(this.fNewsTableControlContainer);
        NewsTableViewer tableViewer = this.fNewsTableControl.getViewer();
        tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    FeedView.this.fFilterBar.clearQuickSearch(true);
                }
            }
        });
        this.fVerticalTableBrowserSep = new Label(this.fNewsTableControlContainer, 514);
        this.fVerticalTableBrowserSep.setLayoutData((Object)new GridData(1, 4, false, false));
        ((GridData)this.fVerticalTableBrowserSep.getLayoutData()).exclude = this.fLayout != OwlUI.Layout.VERTICAL;
        this.fHorizontalTableBrowserSep = new Label(this.fNewsTableControlContainer, 258);
        this.fHorizontalTableBrowserSep.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        ((GridData)this.fHorizontalTableBrowserSep.getLayoutData()).exclude = this.fLayout != OwlUI.Layout.CLASSIC;
        this.fBrowserViewerControlContainer = new Composite((Composite)this.fSashForm, 0);
        this.fBrowserViewerControlContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 0, false));
        this.fBrowserViewerControlContainer.setBackground(parent.getDisplay().getSystemColor(25));
        this.fVerticalBrowserSep = new Label(this.fBrowserViewerControlContainer, 514);
        this.fVerticalBrowserSep.setLayoutData((Object)new GridData(1, 4, false, false, 1, 3));
        ((GridData)this.fVerticalBrowserSep.getLayoutData()).exclude = this.fLayout != OwlUI.Layout.VERTICAL;
        this.fBrowserBar = new BrowserBar(this, this.fBrowserViewerControlContainer);
        this.fHorizontalBrowserSep = new Label(this.fBrowserViewerControlContainer, 258);
        if (this.fLayout == OwlUI.Layout.CLASSIC) {
            this.fHorizontalBrowserSep.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            ((GridData)this.fHorizontalBrowserSep.getLayoutData()).exclude = false;
        } else if (this.fLayout == OwlUI.Layout.VERTICAL) {
            this.fHorizontalBrowserSep.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
            ((GridData)this.fHorizontalBrowserSep.getLayoutData()).exclude = !this.fBrowserBar.isVisible();
        } else if (this.fLayout == OwlUI.Layout.NEWSPAPER || this.fLayout == OwlUI.Layout.HEADLINES) {
            this.fHorizontalBrowserSep.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            ((GridData)this.fHorizontalBrowserSep.getLayoutData()).exclude = !this.fBrowserBar.isVisible();
        }
        this.fNewsBrowserControl = new NewsBrowserControl();
        this.fNewsBrowserControl.init(this.fFeedViewSite);
        this.fNewsBrowserControl.onInputChanged(this.fInput);
        this.fNewsBrowserControl.createPart(this.fBrowserViewerControlContainer);
        NewsBrowserViewer browserViewer = this.fNewsBrowserControl.getViewer();
        browserViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    FeedView.this.fFilterBar.clearQuickSearch(true);
                }
            }
        });
        this.fBrowserBar.init(browserViewer.getBrowser());
        this.fSashForm.setWeights(this.fInitialWeights);
        if (this.fLayout == OwlUI.Layout.NEWSPAPER || this.fLayout == OwlUI.Layout.HEADLINES) {
            this.fSashForm.setMaximizedControl((Control)this.fBrowserViewerControlContainer);
        } else if (this.fLayout == OwlUI.Layout.LIST) {
            this.fSashForm.setMaximizedControl((Control)this.fNewsTableControlContainer);
        }
        this.fContentProvider = new NewsContentProvider(tableViewer, browserViewer, this);
        this.fNewsTableControl.initViewer((IStructuredContentProvider)this.fContentProvider, this.fNewsFilter);
        this.fNewsBrowserControl.initViewer((IStructuredContentProvider)this.fContentProvider, this.fNewsFilter);
        this.setInput(this.fInput.getMark(), false);
    }

    void revalidateCaches() {
        this.fContentProvider.refreshCache(null, this.fInput.getMark());
    }

    public boolean navigate(boolean respectSelection, final boolean onInputSet, final boolean next, final boolean unread) {
        if (unread && this.fInput.getMark().getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED)) == 0) {
            return false;
        }
        if (!this.isTableViewerVisible()) {
            if (onInputSet) {
                JobRunner.runInUIThread(100, (Widget)this.fNewsBrowserControl.getViewer().getControl(), new Runnable(){

                    public void run() {
                        FeedView.this.fNewsBrowserControl.getViewer().navigate(next, unread, onInputSet);
                    }
                });
            } else {
                this.fNewsBrowserControl.getViewer().navigate(next, unread, onInputSet);
            }
            return true;
        }
        Tree newsTree = this.fNewsTableControl.getViewer().getTree();
        if (newsTree.getItemCount() == 0 || newsTree.isDisposed()) {
            return false;
        }
        return this.navigate(newsTree, respectSelection, next, unread);
    }

    private boolean navigate(Tree tree, boolean respectSelection, boolean next, boolean unread) {
        if (respectSelection && tree.getSelectionCount() > 0) {
            WidgetTreeNode startingNode = new WidgetTreeNode(tree.getSelection()[0], (TreeViewer)this.fNewsTableControl.getViewer());
            return this.navigate(startingNode, next, unread);
        }
        WidgetTreeNode startingNode = new WidgetTreeNode(tree, (TreeViewer)this.fNewsTableControl.getViewer());
        return this.navigate(startingNode, true, unread);
    }

    private boolean navigate(ITreeNode startingNode, boolean next, final boolean unread) {
        ITreeNode targetNode;
        TreeTraversal traverse = new TreeTraversal(startingNode){

            public boolean select(ITreeNode node) {
                return FeedView.this.isValidNavigation(node, unread);
            }
        };
        ITreeNode iTreeNode = targetNode = next ? traverse.nextNode() : traverse.previousNode();
        if (targetNode != null) {
            StructuredSelection selection = new StructuredSelection(targetNode.getData());
            this.fNewsTableControl.getViewer().setSelection((ISelection)selection, true);
            return true;
        }
        return false;
    }

    private boolean isValidNavigation(ITreeNode node, boolean unread) {
        Object data = node.getData();
        if (!(data instanceof INews)) {
            return false;
        }
        INews news = (INews)data;
        return !unread || CoreUtils.isUnread((INews.State)news.getState());
    }

    public boolean isVisible() {
        return this.fEditorSite.getPage().isPartVisible(this.fEditorSite.getPart());
    }

    Composite getEditorControl() {
        return this.fParent;
    }

    public static void setBlockFeedChangeEvent(boolean blockFeedChangeEvent) {
        fgBlockFeedChangeEvent = blockFeedChangeEvent;
    }

    public boolean isBrowserShowingNews() {
        CBrowser browser;
        if (this.fNewsBrowserControl != null && this.fNewsBrowserControl.getViewer() != null && this.isBrowserViewerVisible() && (browser = this.fNewsBrowserControl.getViewer().getBrowser()) != null && browser.getControl() != null && !browser.getControl().isDisposed()) {
            String url = browser.getControl().getUrl();
            return StringUtils.isSet((String)url) && ApplicationServer.getDefault().isNewsServerUrl(url);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UIEvent {
        FEED_CHANGE,
        MINIMIZE,
        CLOSE,
        TAB_CLOSE;

    }
}

