/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.rssowl.core.persist.INews;
import org.rssowl.core.util.ITreeNode;
import org.rssowl.core.util.TreeTraversal;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.util.WidgetTreeNode;

public class NewsTableViewer
extends TreeViewer {
    private boolean fBlockRefresh;

    public NewsTableViewer(Tree tree) {
        super(tree);
    }

    public void refresh() {
        if (!this.fBlockRefresh) {
            super.refresh();
        }
    }

    public void setContentProvider(IContentProvider provider) {
        this.fBlockRefresh = true;
        try {
            super.setContentProvider(provider);
        }
        finally {
            this.fBlockRefresh = false;
        }
    }

    public void remove(final Object[] elements) {
        this.updateSelectionAfterDelete(new Runnable(){

            public void run() {
                NewsTableViewer.this.internalRemove(elements);
            }
        });
    }

    void updateSelectionAfterDelete(Runnable runnable) {
        WidgetTreeNode startingNode;
        ISelection newSelection;
        Tree tree = this.getTree();
        TreeItem[] oldSelection = tree.getSelection();
        if (oldSelection.length == 0) {
            runnable.run();
            return;
        }
        if (OwlUI.isMinimized()) {
            runnable.run();
            return;
        }
        ArrayList<Object> oldSelectionObjects = new ArrayList<Object>(oldSelection.length);
        TreeItem[] treeItemArray = oldSelection;
        int n = oldSelection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            oldSelectionObjects.add(item.getData());
            ++n2;
        }
        TreeItem lastSelectedItem = oldSelection[oldSelection.length - 1];
        if (lastSelectedItem.getData() instanceof EntityGroup) {
            int indexOfEntityGroup = tree.indexOf(lastSelectedItem);
            if (tree.getItemCount() > indexOfEntityGroup + 1) {
                lastSelectedItem = tree.getItem(indexOfEntityGroup + 1);
            } else if (indexOfEntityGroup > 0) {
                lastSelectedItem = tree.getItem(indexOfEntityGroup - 1);
            }
        }
        if ((newSelection = this.navigate(startingNode = new WidgetTreeNode(lastSelectedItem, (TreeViewer)this), true)) == null) {
            newSelection = this.navigate(startingNode, false);
        }
        runnable.run();
        boolean updateSelection = false;
        int i = 0;
        while (i < oldSelection.length) {
            TreeItem oldSelectedItem = oldSelection[i];
            Object oldSelectedObject = oldSelectionObjects.get(i);
            if (oldSelectedItem.isDisposed() || oldSelectedObject != null && !oldSelectedObject.equals(oldSelectedItem.getData())) {
                updateSelection = true;
                break;
            }
            ++i;
        }
        if (updateSelection) {
            this.setSelection(newSelection);
        }
    }

    private ISelection navigate(ITreeNode startingNode, boolean next) {
        ITreeNode targetNode;
        TreeTraversal traverse = new TreeTraversal(startingNode){

            public boolean select(ITreeNode node) {
                return node.getData() instanceof INews;
            }
        };
        ITreeNode iTreeNode = targetNode = next ? traverse.nextNode() : traverse.previousNode();
        if (targetNode != null) {
            StructuredSelection selection = new StructuredSelection(targetNode.getData());
            return selection;
        }
        return null;
    }
}

