/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.filter.Messages;
import org.rssowl.ui.internal.filter.NewsActionDescriptor;
import org.rssowl.ui.internal.filter.NewsActionItem;
import org.rssowl.ui.internal.filter.NewsActionPresentationManager;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsActionList
extends ScrolledComposite {
    private final NewsActionPresentationManager fNewsActionPresentationManager = NewsActionPresentationManager.getInstance();
    private List<NewsActionItem> fItems = new ArrayList<NewsActionItem>();
    private int fVisibleItemCount;
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
    private Image fAddIcon;
    private Image fDeleteIcon;
    private Composite fContainer;

    public NewsActionList(Composite parent, int style, List<IFilterAction> actions) {
        super(parent, style | 0x200);
        this.initResources();
        this.initComponents(actions);
    }

    public void setVisibleItemCount(int count) {
        Assert.isLegal((count >= 0 ? 1 : 0) != 0);
        this.fVisibleItemCount = count;
    }

    public boolean isEmpty() {
        for (NewsActionItem item : this.fItems) {
            if (!item.hasValue()) continue;
            return false;
        }
        return true;
    }

    public void focusInput() {
        if (!this.fItems.isEmpty()) {
            this.fItems.get(0).focusInput();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point point = super.computeSize(wHint, hHint, changed);
        if (this.fVisibleItemCount > 0 && this.fItems.size() > 0) {
            int itemHeight = this.fItems.get((int)0).computeSize((int)wHint, (int)hHint).y + 4;
            point.y = this.fVisibleItemCount * itemHeight;
        }
        return point;
    }

    public List<IFilterAction> createActions() {
        ArrayList<IFilterAction> actions = new ArrayList<IFilterAction>(this.fItems.size());
        for (NewsActionItem item : this.fItems) {
            IFilterAction action = item.createFilterAction(true);
            if (action == null) continue;
            actions.add(action);
        }
        ArrayList<IFilterAction> duplicateActions = new ArrayList<IFilterAction>(0);
        for (IFilterAction action : actions) {
            if (duplicateActions.contains(action)) continue;
            for (IFilterAction otherAction : actions) {
                Object[] otherData;
                if (action == otherAction || !action.getActionId().equals(otherAction.getActionId())) continue;
                if (action.getData() == null && otherAction.getData() == null) {
                    duplicateActions.add(otherAction);
                    continue;
                }
                if (action.getData() != null && action.getData().equals(otherAction.getData())) {
                    duplicateActions.add(otherAction);
                    continue;
                }
                if (action.getData() == null || !(action.getData() instanceof Object[])) continue;
                Object[] data = (Object[])action.getData();
                if (!(otherAction.getData() instanceof Object[]) || !Arrays.equals(data, otherData = (Object[])otherAction.getData())) continue;
                duplicateActions.add(otherAction);
            }
        }
        actions.removeAll(duplicateActions);
        return actions;
    }

    public void showActions(List<IFilterAction> actions) {
        this.setRedraw(false);
        try {
            ArrayList<NewsActionItem> itemsToRemove = new ArrayList<NewsActionItem>(this.fItems);
            for (NewsActionItem itemToRemove : itemsToRemove) {
                itemToRemove.getParent().dispose();
                this.removeItem(itemToRemove);
            }
            if (actions != null) {
                boolean addDefaultAction = true;
                for (IFilterAction action : actions) {
                    if (!this.fNewsActionPresentationManager.hasNewsAction(action.getActionId())) continue;
                    this.addItem(action);
                    addDefaultAction = false;
                }
                if (addDefaultAction) {
                    this.addItem(this.getDefaultAction());
                }
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    private void initResources() {
        this.fAddIcon = OwlUI.getImage((ResourceManager)this.fResources, "icons/etool16/add.gif");
        this.fDeleteIcon = OwlUI.getImage((ResourceManager)this.fResources, "icons/etool16/remove.gif");
    }

    private void initComponents(List<IFilterAction> actions) {
        this.setLayout((Layout)new GridLayout(1, false));
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().setIncrement(10);
        }
        this.fContainer = new Composite((Composite)this, 0);
        this.fContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        this.fContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setContent((Control)this.fContainer);
        if (actions != null) {
            for (IFilterAction action : actions) {
                this.addItem(action);
            }
        }
        this.updateSize();
    }

    NewsActionItem addItem(IFilterAction action) {
        return this.addItem(action, this.fItems.size());
    }

    NewsActionItem addItem(IFilterAction action, int index) {
        return this.addItem(action, index, false);
    }

    NewsActionItem addItem(IFilterAction action, int index, boolean scroll) {
        boolean wasScrollbarShowing = this.getVerticalBar() != null ? this.getVerticalBar().isVisible() : false;
        final Composite itemContainer = new Composite(this.fContainer, 0);
        itemContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 0, false));
        itemContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        final NewsActionItem item = new NewsActionItem(itemContainer, 0, action);
        item.setLayoutData(new GridData(4, 1, true, false));
        final ToolBar buttonBar = new ToolBar(itemContainer, 0x800000);
        buttonBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        ToolItem addButton = new ToolItem(buttonBar, 4);
        addButton.setImage(this.fAddIcon);
        addButton.setToolTipText(Messages.NewsActionList_ADD_ACTION);
        final Menu actionMenu = new Menu((Control)buttonBar);
        this.createActionMenu(actionMenu, item);
        addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle rect = item.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = buttonBar.toDisplay(pt);
                    actionMenu.setLocation(pt.x, pt.y);
                    actionMenu.setVisible(true);
                } else {
                    NewsActionList.this.onAdd(item);
                }
            }
        });
        buttonBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OwlUI.safeDispose(actionMenu);
            }
        });
        ToolItem deleteButton = new ToolItem(buttonBar, 8);
        deleteButton.setImage(this.fDeleteIcon);
        deleteButton.setToolTipText(Messages.NewsActionList_DELETE_ACTION);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobRunner.runInUIThread(0, true, (Widget)buttonBar, new Runnable(){

                    public void run() {
                        NewsActionList.this.onDelete(item, itemContainer);
                    }
                });
            }
        });
        boolean addedToEnd = false;
        if (index == this.fItems.size()) {
            addedToEnd = true;
            this.fItems.add(item);
        } else {
            NewsActionItem oldItem = this.fItems.get(index);
            this.fItems.add(index, item);
            item.getParent().moveAbove((Control)oldItem.getParent());
        }
        this.layout(true, true);
        this.update();
        this.updateSize();
        OwlUI.adjustSizeForScrollbar(this.getShell(), this.getVerticalBar(), wasScrollbarShowing);
        if (scroll && addedToEnd) {
            this.setOrigin(0, this.getContent().getSize().y);
        }
        return item;
    }

    private void createActionMenu(Menu menu, NewsActionItem item) {
        NewsActionPresentationManager manager = NewsActionPresentationManager.getInstance();
        Collection<NewsActionDescriptor> actions = manager.getSortedNewsActions();
        String lastSortKey = null;
        for (NewsActionDescriptor action : actions) {
            if (lastSortKey != null && lastSortKey.charAt(0) != action.getSortKey().charAt(0)) {
                new MenuItem(menu, 2);
            }
            MenuItem mItem = new MenuItem(menu, 8);
            mItem.setText(action.getName());
            this.hookSelectionListener(mItem, item, action.getActionId());
            lastSortKey = action.getSortKey();
        }
    }

    private void hookSelectionListener(MenuItem item, final NewsActionItem action, final String actionId) {
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsActionList.this.onAdd(action, actionId);
            }
        });
    }

    void onAdd(NewsActionItem selectedItem) {
        IFilterAction filterAction = this.createAction(selectedItem.createFilterAction(false));
        this.addItem(filterAction, this.indexOf(selectedItem) + 1, true);
    }

    void onAdd(NewsActionItem selectedItem, String actionId) {
        IFilterAction filterAction = Owl.getModelFactory().createFilterAction(actionId);
        this.addItem(filterAction, this.indexOf(selectedItem) + 1, true);
    }

    int indexOf(NewsActionItem item) {
        return this.fItems.indexOf((Object)item);
    }

    void onDelete(NewsActionItem item, Composite itemContainer) {
        boolean wasScrollbarShowing = this.getVerticalBar() != null ? this.getVerticalBar().isVisible() : false;
        itemContainer.dispose();
        this.removeItem(item);
        if (this.fItems.size() == 0) {
            this.addItem(this.getDefaultAction());
        }
        OwlUI.adjustSizeForScrollbar(this.getShell(), this.getVerticalBar(), wasScrollbarShowing);
    }

    private IFilterAction createAction(IFilterAction current) {
        IModelFactory factory = Owl.getModelFactory();
        return factory.createFilterAction(current.getActionId());
    }

    private IFilterAction getDefaultAction() {
        IModelFactory factory = Owl.getModelFactory();
        return factory.createFilterAction("org.rssowl.core.MoveNewsAction");
    }

    void removeItem(NewsActionItem item) {
        item.dispose();
        this.fItems.remove((Object)item);
        this.layout(true, true);
        this.update();
        this.updateSize();
    }

    private void updateSize() {
        this.setMinSize(this.fContainer.computeSize(-1, -1));
    }

    public boolean isModified() {
        return true;
    }
}

