/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.search;

import java.util.EnumSet;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolTip;
import org.rssowl.core.persist.INews;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.search.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateConditionControl
extends Composite {
    private Button fNewState;
    private Button fUnreadState;
    private Button fUpdatedState;
    private Button fReadState;

    StateConditionControl(Composite parent, int style) {
        super(parent, style);
        this.initComponents();
    }

    EnumSet<INews.State> getSelection() {
        EnumSet<INews.State> set = null;
        if (this.fNewState.getSelection()) {
            set = EnumSet.of(INews.State.NEW);
        }
        if (this.fUnreadState.getSelection()) {
            if (set == null) {
                set = EnumSet.of(INews.State.UNREAD);
            } else {
                set.add(INews.State.UNREAD);
            }
        }
        if (this.fUpdatedState.getSelection()) {
            if (set == null) {
                set = EnumSet.of(INews.State.UPDATED);
            } else {
                set.add(INews.State.UPDATED);
            }
        }
        if (this.fReadState.getSelection()) {
            if (set == null) {
                set = EnumSet.of(INews.State.READ);
            } else {
                set.add(INews.State.READ);
            }
        }
        return set;
    }

    void select(EnumSet<INews.State> selectedStates) {
        this.fNewState.setSelection(selectedStates != null && selectedStates.contains(INews.State.NEW));
        this.fUnreadState.setSelection(selectedStates != null && selectedStates.contains(INews.State.UNREAD));
        this.fUpdatedState.setSelection(selectedStates != null && selectedStates.contains(INews.State.UPDATED));
        this.fReadState.setSelection(selectedStates != null && selectedStates.contains(INews.State.READ));
    }

    private void initComponents() {
        this.setLayout((Layout)LayoutUtils.createGridLayout(4, 0, 0));
        this.fNewState = new Button((Composite)this, 32);
        this.fNewState.setText(Messages.StateConditionControl_NEW);
        this.fNewState.setToolTipText(Messages.StateConditionControl_NEW_INFO);
        this.fNewState.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.fUnreadState = new Button((Composite)this, 32);
        this.fUnreadState.setText(Messages.StateConditionControl_UNREAD);
        this.fUnreadState.setToolTipText(Messages.StateConditionControl_UNREAD_INFO);
        this.fUnreadState.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        if (Application.IS_MAC) {
            final ControlDecoration newControlDeco = new ControlDecoration((Control)this.fNewState, 16512);
            newControlDeco.setImage(OwlUI.getImage((Control)this.fNewState, "icons/obj16/dotempty.gif"));
            newControlDeco.hide();
            final ControlDecoration unreadControlDeco = new ControlDecoration((Control)this.fUnreadState, 16512);
            unreadControlDeco.setImage(OwlUI.getImage((Control)this.fUnreadState, "icons/obj16/dotempty.gif"));
            unreadControlDeco.hide();
            this.fNewState.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (StateConditionControl.this.fNewState.getSelection() && !StateConditionControl.this.fUnreadState.getSelection()) {
                        unreadControlDeco.show();
                        unreadControlDeco.showHoverText(Messages.StateConditionControl_UNREAD_HINT);
                    } else {
                        unreadControlDeco.hide();
                        unreadControlDeco.hideHover();
                    }
                }
            });
            this.fUnreadState.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (StateConditionControl.this.fUnreadState.getSelection() && !StateConditionControl.this.fNewState.getSelection()) {
                        newControlDeco.show();
                        newControlDeco.showHoverText(Messages.StateConditionControl_NEW_HINT);
                    } else {
                        newControlDeco.hide();
                        newControlDeco.hideHover();
                    }
                }
            });
            this.fNewState.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    newControlDeco.hide();
                    newControlDeco.hideHover();
                }
            });
            this.fUnreadState.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    unreadControlDeco.hide();
                    unreadControlDeco.hideHover();
                }
            });
        } else {
            final ToolTip newStateToolTip = new ToolTip(this.getShell(), 4096);
            newStateToolTip.setMessage(Messages.StateConditionControl_NEW_HINT);
            newStateToolTip.setAutoHide(false);
            final ToolTip unreadStateToolTip = new ToolTip(this.getShell(), 4096);
            unreadStateToolTip.setMessage(Messages.StateConditionControl_UNREAD_HINT);
            unreadStateToolTip.setAutoHide(false);
            this.fNewState.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (StateConditionControl.this.fNewState.getSelection() && !StateConditionControl.this.fUnreadState.getSelection()) {
                        Point toolTipLocation = StateConditionControl.this.toDisplay(StateConditionControl.this.fUnreadState.getLocation());
                        toolTipLocation.y += ((StateConditionControl)StateConditionControl.this).fUnreadState.getSize().y;
                        if (Application.IS_WINDOWS) {
                            toolTipLocation.x += 5;
                        } else if (Application.IS_LINUX) {
                            toolTipLocation.x += 12;
                        }
                        unreadStateToolTip.setLocation(toolTipLocation);
                        unreadStateToolTip.setVisible(true);
                    } else {
                        unreadStateToolTip.setVisible(false);
                    }
                }
            });
            this.fUnreadState.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (StateConditionControl.this.fUnreadState.getSelection() && !StateConditionControl.this.fNewState.getSelection()) {
                        Point toolTipLocation = StateConditionControl.this.toDisplay(StateConditionControl.this.fNewState.getLocation());
                        toolTipLocation.y += ((StateConditionControl)StateConditionControl.this).fNewState.getSize().y;
                        if (Application.IS_WINDOWS) {
                            toolTipLocation.x += 5;
                        } else if (Application.IS_LINUX) {
                            toolTipLocation.x += 12;
                        }
                        newStateToolTip.setLocation(toolTipLocation);
                        newStateToolTip.setVisible(true);
                    } else {
                        newStateToolTip.setVisible(false);
                    }
                }
            });
            this.fNewState.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    newStateToolTip.setVisible(false);
                }

                public void focusLost(FocusEvent e) {
                    unreadStateToolTip.setVisible(false);
                }
            });
            this.fUnreadState.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    unreadStateToolTip.setVisible(false);
                }

                public void focusLost(FocusEvent e) {
                    newStateToolTip.setVisible(false);
                }
            });
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    unreadStateToolTip.dispose();
                    newStateToolTip.dispose();
                }
            });
        }
        this.fUpdatedState = new Button((Composite)this, 32);
        this.fUpdatedState.setText(Messages.StateConditionControl_UPDATED);
        this.fUpdatedState.setToolTipText(Messages.StateConditionControl_UPDATED_INFO);
        this.fUpdatedState.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.fReadState = new Button((Composite)this, 32);
        this.fReadState.setText(Messages.StateConditionControl_READ);
        this.fReadState.setToolTipText(Messages.StateConditionControl_READ_INFO);
        this.fReadState.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StateConditionControl.this.notifyListeners(24, new Event());
            }
        };
        this.fNewState.addSelectionListener((SelectionListener)selectionListener);
        this.fUnreadState.addSelectionListener((SelectionListener)selectionListener);
        this.fUpdatedState.addSelectionListener((SelectionListener)selectionListener);
        this.fReadState.addSelectionListener((SelectionListener)selectionListener);
    }
}

