/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.util.CColumnLayoutData;

public class CTable {
    private static final String LAYOUT_DATA = "org.rssowl.ui.internal.CTreeLayoutData";
    private Table fTable;
    private List<TableColumn> fCols = new ArrayList<TableColumn>();

    public CTable(Composite parent, int style) {
        this.fTable = new Table(parent, style);
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                CTable.this.onTableResize();
            }
        });
    }

    public Table getControl() {
        return this.fTable;
    }

    public void update() {
        this.onTableResize();
    }

    public void clear() {
        for (TableColumn cols : this.fCols) {
            cols.dispose();
        }
        this.fCols.clear();
    }

    public TableColumn manageColumn(TableColumn col, CColumnLayoutData layoutData, String text, String tooltip, Image image, boolean moveable, boolean resizable) {
        col.setData(LAYOUT_DATA, (Object)layoutData);
        col.setMoveable(moveable);
        col.setResizable(resizable);
        if (text != null) {
            col.setText(text);
        }
        if (tooltip != null) {
            col.setToolTipText(tooltip);
        }
        if (image != null) {
            col.setImage(image);
        }
        this.fCols.add(col);
        return col;
    }

    private void onTableResize() {
        CColumnLayoutData data;
        int totalWidth = this.fTable.getParent().getClientArea().width;
        totalWidth -= this.fTable.getBorderWidth() * 2;
        ScrollBar verticalBar = this.fTable.getVerticalBar();
        if (verticalBar != null) {
            int barWidth = verticalBar.getSize().x;
            if (Application.IS_MAC && barWidth == 0) {
                barWidth = 16;
            }
            totalWidth -= barWidth;
        }
        if (Application.IS_MAC) {
            totalWidth -= 3;
            if ((this.fTable.getStyle() & 0x20) != 0) {
                totalWidth -= 24;
            }
        } else if (Application.IS_LINUX) {
            totalWidth -= 3;
        }
        int freeWidth = totalWidth;
        int occupiedWidth = 0;
        int totalFillSum = 0;
        for (TableColumn column : this.fCols) {
            data = (CColumnLayoutData)column.getData(LAYOUT_DATA);
            if (data.getSize() == CColumnLayoutData.Size.FIXED && data.getWidthHint() == -1) {
                column.pack();
                int width = column.getWidth();
                freeWidth -= width;
                occupiedWidth += width;
                continue;
            }
            if (data.getSize() == CColumnLayoutData.Size.FIXED) {
                freeWidth -= data.getWidthHint();
                occupiedWidth += data.getWidthHint();
                if (column.getWidth() == data.getWidthHint()) continue;
                column.setWidth(data.getWidthHint());
                continue;
            }
            if (data.getSize() != CColumnLayoutData.Size.FILL) continue;
            totalFillSum += data.getWidthHint();
        }
        for (TableColumn column : this.fCols) {
            data = (CColumnLayoutData)column.getData(LAYOUT_DATA);
            if (data.getSize() != CColumnLayoutData.Size.FILL) continue;
            int colWidth = freeWidth * data.getWidthHint() / totalFillSum;
            if (occupiedWidth + colWidth >= totalWidth) {
                colWidth = totalWidth - occupiedWidth;
            }
            occupiedWidth += colWidth;
            if (column.getWidth() == colWidth) continue;
            column.setWidth(colWidth);
        }
    }
}

