/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.FolderAdapter;
import org.rssowl.core.persist.event.FolderEvent;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.NewFolderAction;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.Messages;
import org.rssowl.ui.internal.views.explorer.BookMarkLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderChooser
extends Composite
implements DisposeListener {
    private static final int SELECTION_DELAY = 20;
    private static final int DEFAULT_ITEM_HEIGHT = 10;
    private Composite fParent;
    private IFolder fSelectedFolder;
    private ResourceManager fResources;
    private Composite fFolderViewerContainer;
    private ToolItem fToggleItem;
    private TreeViewer fFolderViewer;
    private Label fFolderIcon;
    private Label fFolderName;
    private int fViewerHeight;
    private FolderAdapter fFolderListener;
    private ToolBar fAddFolderBar;
    private List<IFolder> fExcludes;
    private final boolean fExpandable;
    private int fItemHeight;
    private ExpandStrategy fExpandStrategy = ExpandStrategy.RESIZE;

    public FolderChooser(Composite parent, IFolder initial, int style, boolean expandable) {
        this(parent, initial, null, style, expandable);
    }

    public FolderChooser(Composite parent, IFolder initial, List<IFolder> excludes, int style, boolean expandable) {
        this(parent, initial, excludes, style, expandable, 10);
    }

    public FolderChooser(Composite parent, IFolder initial, List<IFolder> excludes, int style, boolean expandable, int itemHeight) {
        super(parent, style);
        this.fParent = parent;
        this.fSelectedFolder = initial;
        this.fExcludes = excludes;
        this.fExpandable = expandable;
        this.fItemHeight = itemHeight;
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.initComponents();
        this.addDisposeListener(this);
    }

    public IFolder getFolder() {
        return this.fSelectedFolder;
    }

    public void setExpandStrategy(ExpandStrategy expandStrategy) {
        this.fExpandStrategy = expandStrategy;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.unregisterListeners();
    }

    private void registerListeners() {
        this.fFolderListener = new FolderAdapter(){

            public void entitiesUpdated(final Set<FolderEvent> events) {
                if (events.isEmpty()) {
                    return;
                }
                JobRunner.runInUIThread((Widget)FolderChooser.this.fFolderViewer.getControl(), new Runnable(){

                    public void run() {
                        FolderChooser.this.fFolderViewer.refresh();
                        FolderEvent event = (FolderEvent)events.iterator().next();
                        FolderChooser.this.expand(event.getEntity());
                    }
                });
            }

            public void entitiesAdded(final Set<FolderEvent> events) {
                if (events.isEmpty()) {
                    return;
                }
                JobRunner.runInUIThread(20, (Widget)FolderChooser.this.fFolderViewer.getControl(), new Runnable(){

                    public void run() {
                        FolderEvent event = (FolderEvent)events.iterator().next();
                        FolderChooser.this.fFolderViewer.setSelection((ISelection)new StructuredSelection((Object)event.getEntity()));
                    }
                });
            }
        };
        DynamicDAO.addEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
    }

    private void expand(IFolder folder) {
        IFolder parent = folder.getParent();
        if (parent != null) {
            this.expand(parent);
        }
        this.fFolderViewer.setExpandedState((Object)folder, true);
    }

    private void unregisterListeners() {
        DynamicDAO.removeEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
    }

    private void initComponents() {
        Composite headerContainer = new Composite((Composite)this, 0);
        headerContainer.setLayout((Layout)LayoutUtils.createGridLayout(3, 0, 0));
        ((GridLayout)headerContainer.getLayout()).marginLeft = 3;
        headerContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        headerContainer.setBackground(this.fParent.getDisplay().getSystemColor(25));
        if (this.fExpandable) {
            headerContainer.setCursor(this.fParent.getDisplay().getSystemCursor(21));
            headerContainer.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    FolderChooser.this.onToggle();
                    FolderChooser.this.notifyListeners(13, new Event());
                }
            });
        }
        this.fFolderIcon = new Label(headerContainer, 0);
        this.fFolderIcon.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.fFolderIcon.setBackground(this.fParent.getDisplay().getSystemColor(25));
        if (this.fExpandable) {
            this.fFolderIcon.setCursor(this.fParent.getDisplay().getSystemCursor(21));
            this.fFolderIcon.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    FolderChooser.this.onToggle();
                    FolderChooser.this.notifyListeners(13, new Event());
                }
            });
        }
        this.fFolderName = new Label(headerContainer, 0);
        this.fFolderName.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fFolderName.setBackground(this.fParent.getDisplay().getSystemColor(25));
        if (this.fExpandable) {
            this.fFolderName.setCursor(this.fParent.getDisplay().getSystemCursor(21));
            this.fFolderName.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    FolderChooser.this.onToggle();
                    FolderChooser.this.notifyListeners(13, new Event());
                }
            });
        }
        Composite toolbarContainer = new Composite(headerContainer, 0);
        toolbarContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 1, false));
        toolbarContainer.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        toolbarContainer.setBackground(this.fParent.getDisplay().getSystemColor(25));
        this.fAddFolderBar = new ToolBar(toolbarContainer, 0x800000);
        OwlUI.makeAccessible((Control)this.fAddFolderBar, Messages.FolderChooser_NEW_FOLDER);
        this.fAddFolderBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        this.fAddFolderBar.setBackground(this.fParent.getDisplay().getSystemColor(25));
        this.fAddFolderBar.setCursor(headerContainer.getDisplay().getSystemCursor(0));
        this.fAddFolderBar.setVisible(!this.fExpandable);
        ToolItem addFolderItem = new ToolItem(this.fAddFolderBar, 8);
        addFolderItem.setImage(OwlUI.getImage(this.fResources, "icons/etool16/add_crop.gif"));
        addFolderItem.setToolTipText(Messages.FolderChooser_NEW_FOLDER);
        addFolderItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderChooser.this.onNewFolder();
                FolderChooser.this.notifyListeners(13, new Event());
            }
        });
        ToolBar toggleBar = new ToolBar(toolbarContainer, 0x800000);
        OwlUI.makeAccessible((Control)toggleBar, Messages.FolderChooser_SHOW_FOLDERS);
        toggleBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        ((GridData)toggleBar.getLayoutData()).exclude = !this.fExpandable;
        toggleBar.setBackground(this.fParent.getDisplay().getSystemColor(25));
        toggleBar.setCursor(headerContainer.getDisplay().getSystemCursor(0));
        this.fToggleItem = new ToolItem(toggleBar, 8);
        this.fToggleItem.setImage(OwlUI.getImage(this.fResources, "icons/ovr16/arrow_down.gif"));
        this.fToggleItem.setToolTipText(Messages.FolderChooser_SHOW_FOLDERS);
        this.fToggleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderChooser.this.onToggle();
                FolderChooser.this.notifyListeners(13, new Event());
            }
        });
        this.fFolderViewerContainer = new Composite((Composite)this, 0);
        this.fFolderViewerContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 2, 0, false));
        this.fFolderViewerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fFolderViewerContainer.setBackground(this.fParent.getDisplay().getSystemColor(25));
        Label separator = new Label(this.fFolderViewerContainer, 258);
        separator.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fFolderViewer = new TreeViewer(this.fFolderViewerContainer, 0);
        this.fFolderViewer.setAutoExpandLevel(2);
        this.fFolderViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fFolderViewer.getTree().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        ((GridData)this.fFolderViewerContainer.getLayoutData()).heightHint = this.fViewerHeight = this.fFolderViewer.getTree().getItemHeight() * this.fItemHeight + 12;
        ((GridData)this.fFolderViewerContainer.getLayoutData()).exclude = this.fExpandable;
        if (Owl.getPreferenceService().getGlobalScope().getBoolean(DefaultPreferences.BE_SORT_BY_NAME)) {
            this.fFolderViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    IFolder f1 = (IFolder)e1;
                    IFolder f2 = (IFolder)e2;
                    return f1.getName().compareTo(f2.getName());
                }
            });
        }
        this.fFolderViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (FolderChooser.this.fExcludes == null) {
                    return true;
                }
                return !FolderChooser.this.fExcludes.contains(element) && !FolderChooser.this.fExcludes.contains(parentElement);
            }
        });
        this.fFolderViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                Set rootFolders = CoreUtils.loadRootFolders();
                return rootFolders.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IFolder) {
                    IFolder folder = (IFolder)parentElement;
                    return folder.getFolders().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    return folder.getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    return !folder.getFolders().isEmpty();
                }
                return false;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        boolean usedInDialog = this.fParent.getShell().getParent() != null;
        this.fFolderViewer.setLabelProvider((IBaseLabelProvider)new BookMarkLabelProvider(false, usedInDialog));
        this.fFolderViewer.setInput(new Object());
        this.fFolderViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    FolderChooser.this.onFolderSelected((IFolder)selection.getFirstElement());
                }
                FolderChooser.this.notifyListeners(13, new Event());
            }
        });
        this.fFolderViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IFolder folder = (IFolder)selection.getFirstElement();
                if (!folder.getFolders().isEmpty()) {
                    boolean expandedState = !FolderChooser.this.fFolderViewer.getExpandedState((Object)folder);
                    FolderChooser.this.fFolderViewer.setExpandedState((Object)folder, expandedState);
                } else if (FolderChooser.this.fExpandable) {
                    FolderChooser.this.onToggle();
                }
            }
        });
        this.fFolderViewer.setSelection((ISelection)new StructuredSelection((Object)this.fSelectedFolder));
        this.fFolderViewer.setExpandedState((Object)this.fSelectedFolder, true);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action(Messages.FolderChooser_NEW_FOLDER){

            public void run() {
                FolderChooser.this.onNewFolder();
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.fFolderViewer.getTree());
        this.fFolderViewer.getTree().setMenu(menu);
        this.registerListeners();
    }

    private void onNewFolder() {
        if (((GridData)this.fFolderViewerContainer.getLayoutData()).exclude && this.fExpandable) {
            this.onToggle();
        }
        IStructuredSelection selection = (IStructuredSelection)this.fFolderViewer.getSelection();
        NewFolderAction action = new NewFolderAction(this.fFolderViewer.getTree().getShell(), (IFolder)selection.getFirstElement(), null);
        action.run(null);
    }

    private void onFolderSelected(IFolder folder) {
        this.fSelectedFolder = folder;
        this.fFolderIcon.setImage(OwlUI.getImage(this.fResources, folder.getParent() != null ? OwlUI.FOLDER : OwlUI.BOOKMARK_SET));
        this.fFolderName.setText(folder.getName());
    }

    private void onToggle() {
        boolean excluded = ((GridData)this.fFolderViewerContainer.getLayoutData()).exclude;
        this.fToggleItem.setImage(OwlUI.getImage(this.fResources, excluded ? "icons/ovr16/arrow_up.gif" : "icons/ovr16/arrow_down.gif"));
        this.fToggleItem.setToolTipText(excluded ? Messages.FolderChooser_HIDE_FOLDERS : Messages.FolderChooser_SHOW_FOLDERS);
        ((GridData)this.fFolderViewerContainer.getLayoutData()).exclude = !excluded;
        Shell shell = this.fFolderViewerContainer.getShell();
        shell.layout();
        this.fAddFolderBar.setVisible(excluded);
        if (this.fExpandStrategy == ExpandStrategy.RESIZE) {
            Point size = shell.getSize();
            shell.setSize(size.x, size.y + (excluded ? this.fViewerHeight : -this.fViewerHeight));
        } else {
            int currentWidth = shell.getSize().x;
            Point desiredSize = shell.computeSize(currentWidth, -1);
            if (desiredSize.y > shell.getSize().y) {
                shell.setSize(currentWidth, desiredSize.y);
            } else {
                shell.layout(true, true);
            }
        }
        if (excluded) {
            this.fFolderViewer.getTree().setFocus();
        } else {
            this.fFolderViewer.getTree().getShell().setFocus();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpandStrategy {
        PACK,
        RESIZE;

    }
}

