/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.ArrayIterator4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.SortedCollection4;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.BTreeRangeSingle;
import com.db4o.internal.btree.BTreeRangeVisitor;
import com.db4o.internal.btree.algebra.BTreeRangeUnionIntersect;
import com.db4o.internal.btree.algebra.BTreeRangeUnionUnion;

public class BTreeRangeUnion
implements BTreeRange {
    private final BTreeRangeSingle[] _ranges;

    public BTreeRangeUnion(BTreeRangeSingle[] bTreeRangeSingleArray) {
        this(BTreeRangeUnion.toSortedCollection(bTreeRangeSingleArray));
    }

    public BTreeRangeUnion(SortedCollection4 sortedCollection4) {
        if (null == sortedCollection4) {
            throw new ArgumentNullException();
        }
        this._ranges = BTreeRangeUnion.toArray(sortedCollection4);
    }

    public void accept(BTreeRangeVisitor bTreeRangeVisitor) {
        bTreeRangeVisitor.visit(this);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this._ranges.length; ++i) {
            if (this._ranges[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static SortedCollection4 toSortedCollection(BTreeRangeSingle[] bTreeRangeSingleArray) {
        if (null == bTreeRangeSingleArray) {
            throw new ArgumentNullException();
        }
        SortedCollection4 sortedCollection4 = new SortedCollection4(BTreeRangeSingle.COMPARISON);
        for (int i = 0; i < bTreeRangeSingleArray.length; ++i) {
            BTreeRangeSingle bTreeRangeSingle = bTreeRangeSingleArray[i];
            if (bTreeRangeSingle.isEmpty()) continue;
            sortedCollection4.add(bTreeRangeSingle);
        }
        return sortedCollection4;
    }

    private static BTreeRangeSingle[] toArray(SortedCollection4 sortedCollection4) {
        return (BTreeRangeSingle[])sortedCollection4.toArray(new BTreeRangeSingle[sortedCollection4.size()]);
    }

    public BTreeRange extendToFirst() {
        throw new NotImplementedException();
    }

    public BTreeRange extendToLast() {
        throw new NotImplementedException();
    }

    public BTreeRange extendToLastOf(BTreeRange bTreeRange) {
        throw new NotImplementedException();
    }

    public BTreeRange greater() {
        throw new NotImplementedException();
    }

    public BTreeRange intersect(BTreeRange bTreeRange) {
        if (null == bTreeRange) {
            throw new ArgumentNullException();
        }
        return new BTreeRangeUnionIntersect(this).dispatch(bTreeRange);
    }

    public Iterator4 pointers() {
        return Iterators.concat(Iterators.map(this._ranges, new Function4(){

            public Object apply(Object object) {
                return ((BTreeRange)object).pointers();
            }
        }));
    }

    public Iterator4 keys() {
        return Iterators.concat(Iterators.map(this._ranges, new Function4(){

            public Object apply(Object object) {
                return ((BTreeRange)object).keys();
            }
        }));
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this._ranges.length; ++i) {
            n += this._ranges[i].size();
        }
        return n;
    }

    public BTreeRange smaller() {
        throw new NotImplementedException();
    }

    public BTreeRange union(BTreeRange bTreeRange) {
        if (null == bTreeRange) {
            throw new ArgumentNullException();
        }
        return new BTreeRangeUnionUnion(this).dispatch(bTreeRange);
    }

    public Iterator4 ranges() {
        return new ArrayIterator4(this._ranges);
    }

    public BTreePointer lastPointer() {
        throw new NotImplementedException();
    }
}

