/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ix;

import com.db4o.foundation.IntObjectVisitor;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.freespace.FreespaceVisitor;
import com.db4o.internal.ix.IndexTransaction;
import com.db4o.internal.ix.Indexable4;
import com.db4o.internal.ix.IxFileRangeReader;
import com.db4o.internal.ix.IxTree;

class IxFileRange
extends IxTree {
    final int _address;
    int _addressOffset;
    int _entries;
    private int[] _lowerAndUpperMatches;

    public IxFileRange(IndexTransaction indexTransaction, int n, int n2, int n3) {
        super(indexTransaction);
        this._address = n;
        this._addressOffset = n2;
        this._entries = n3;
        this._size = n3;
    }

    public Tree add(Tree tree) {
        return this.reader().add(this, tree);
    }

    public int compare(Tree tree) {
        this._lowerAndUpperMatches = new int[2];
        return this.reader().compare(this, this._lowerAndUpperMatches);
    }

    int[] lowerAndUpperMatch() {
        return this._lowerAndUpperMatches;
    }

    private final IxFileRangeReader reader() {
        return this._fieldTransaction.i_index.fileRangeReader();
    }

    public void incrementAddress(int n) {
        this._addressOffset += n;
    }

    public int ownSize() {
        return this._entries;
    }

    public String toString() {
        return super.toString();
    }

    public void visit(Object object) {
        this.visit((Visitor4)object, null);
    }

    public void visit(Visitor4 visitor4, int[] nArray) {
        int n;
        IxFileRangeReader ixFileRangeReader = this.reader();
        if (nArray == null) {
            nArray = new int[]{0, this._entries - 1};
        }
        if ((n = nArray[1] - nArray[0] + 1) > 0) {
            Buffer buffer = new Buffer(n * ixFileRangeReader._slotLength);
            buffer.read(this.stream(), this._address, this._addressOffset + nArray[0] * ixFileRangeReader._slotLength);
            for (int i = nArray[0]; i <= nArray[1]; ++i) {
                buffer.incrementOffset(ixFileRangeReader._linkLegth);
                visitor4.visit(new Integer(buffer.readInt()));
            }
        }
    }

    public int write(Indexable4 indexable4, StatefulBuffer statefulBuffer) {
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)statefulBuffer.getStream();
        int n = this._entries * this.slotLength();
        localObjectContainer.copy(this._address, this._addressOffset, statefulBuffer.getAddress(), statefulBuffer.addressOffset(), n);
        statefulBuffer.moveForward(n);
        return this._entries;
    }

    public void visitAll(IntObjectVisitor intObjectVisitor) {
        LocalObjectContainer localObjectContainer = this.stream();
        Transaction transaction = this.trans();
        Buffer buffer = new Buffer(this.slotLength());
        for (int i = 0; i < this._entries; ++i) {
            int n = this._address + i * this.slotLength();
            buffer.read(localObjectContainer, n, this._addressOffset);
            buffer._offset = 0;
            Object object = this.handler().comparableObject(transaction, this.handler().readIndexEntry(buffer));
            intObjectVisitor.visit(buffer.readInt(), object);
        }
    }

    public void visitFirst(FreespaceVisitor freespaceVisitor) {
        if (this._preceding != null) {
            ((IxTree)this._preceding).visitFirst(freespaceVisitor);
            if (freespaceVisitor.visited()) {
                return;
            }
        }
        this.freespaceVisit(freespaceVisitor, 0);
    }

    public void visitLast(FreespaceVisitor freespaceVisitor) {
        if (this._subsequent != null) {
            ((IxTree)this._subsequent).visitLast(freespaceVisitor);
            if (freespaceVisitor.visited()) {
                return;
            }
        }
        this.freespaceVisit(freespaceVisitor, this._entries - 1);
    }

    public void freespaceVisit(FreespaceVisitor freespaceVisitor, int n) {
        IxFileRangeReader ixFileRangeReader = this.reader();
        Buffer buffer = new Buffer(ixFileRangeReader._slotLength);
        buffer.read(this.stream(), this._address, this._addressOffset + n * ixFileRangeReader._slotLength);
        int n2 = buffer.readInt();
        int n3 = buffer.readInt();
        freespaceVisitor.visit(n3, n2);
    }

    public Object shallowClone() {
        IxFileRange ixFileRange = new IxFileRange(this._fieldTransaction, this._address, this._addressOffset, this._entries);
        super.shallowCloneInternal(ixFileRange);
        if (this._lowerAndUpperMatches != null) {
            ixFileRange._lowerAndUpperMatches = new int[]{this._lowerAndUpperMatches[0], this._lowerAndUpperMatches[1]};
        }
        return ixFileRange;
    }
}

