/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ix;

import com.db4o.foundation.Tree;
import com.db4o.internal.Buffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.ix.Indexable4;
import com.db4o.internal.ix.IxFileRange;
import com.db4o.internal.ix.IxPatch;
import com.db4o.internal.ix.IxRemove;

class IxFileRangeReader {
    private int _baseAddress;
    private int _baseAddressOffset;
    private int _addressOffset;
    private final Indexable4 _handler;
    private int _lower;
    private int _upper;
    private int _cursor;
    private final Buffer _reader;
    final int _slotLength;
    final int _linkLegth;

    IxFileRangeReader(Indexable4 indexable4) {
        this._handler = indexable4;
        this._linkLegth = indexable4.linkLength();
        this._slotLength = this._linkLegth + 4;
        this._reader = new Buffer(this._slotLength);
    }

    Tree add(IxFileRange ixFileRange, Tree tree) {
        int n;
        this.setFileRange(ixFileRange);
        LocalObjectContainer localObjectContainer = ixFileRange.stream();
        Transaction transaction = ixFileRange.trans();
        do {
            this._reader.read(localObjectContainer, this._baseAddress, this._baseAddressOffset + this._addressOffset);
            this._reader._offset = 0;
            n = this.compare(transaction);
            if (n == 0) {
                int n2 = this._reader.readInt();
                n = n2 - ((IxPatch)tree)._parentID;
            }
            if (n > 0) {
                this._upper = this._cursor - 1;
                if (this._upper >= this._lower) continue;
                this._upper = this._lower;
                continue;
            }
            if (n < 0) {
                this._lower = this._cursor + 1;
                if (this._lower <= this._upper) continue;
                this._lower = this._upper;
                continue;
            }
            if (tree instanceof IxRemove) {
                if (this._cursor == 0) {
                    tree._preceding = ixFileRange._preceding;
                    if (ixFileRange._entries == 1) {
                        tree._subsequent = ixFileRange._subsequent;
                        return tree.balanceCheckNulls();
                    }
                    --ixFileRange._entries;
                    ixFileRange.incrementAddress(this._slotLength);
                    ixFileRange._preceding = null;
                    tree._subsequent = ixFileRange;
                } else if (this._cursor + 1 == ixFileRange._entries) {
                    tree._preceding = ixFileRange;
                    tree._subsequent = ixFileRange._subsequent;
                    ixFileRange._subsequent = null;
                    --ixFileRange._entries;
                } else {
                    return this.insert(ixFileRange, tree, this._cursor, 0);
                }
                ixFileRange.calculateSize();
                return tree.balanceCheckNulls();
            }
            if (this._cursor == 0) {
                tree._subsequent = ixFileRange;
                return tree.rotateLeft();
            }
            if (this._cursor == ixFileRange._entries) {
                tree._preceding = ixFileRange;
                return tree.rotateRight();
            }
            return this.insert(ixFileRange, tree, this._cursor, n);
        } while (this.adjustCursor());
        if (this._cursor == 0 && n > 0) {
            return ixFileRange.add(tree, 1);
        }
        if (this._cursor == ixFileRange._entries - 1 && n < 0) {
            return ixFileRange.add(tree, -1);
        }
        return this.insert(ixFileRange, tree, this._cursor, n);
    }

    private boolean adjustCursor() {
        if (this._upper < this._lower) {
            return false;
        }
        int n = this._cursor;
        this._cursor = this._lower + (this._upper - this._lower) / 2;
        if (this._cursor == n && this._cursor == this._lower && this._lower < this._upper) {
            ++this._cursor;
        }
        this._addressOffset = this._cursor * this._slotLength;
        return this._cursor != n;
    }

    int compare(IxFileRange ixFileRange, int[] nArray) {
        int n;
        block14: {
            int n2;
            int n3;
            Transaction transaction;
            LocalObjectContainer localObjectContainer;
            block13: {
                block12: {
                    this.setFileRange(ixFileRange);
                    localObjectContainer = ixFileRange.stream();
                    transaction = ixFileRange.trans();
                    n = 0;
                    do {
                        this._reader.read(localObjectContainer, this._baseAddress, this._baseAddressOffset + this._addressOffset);
                        this._reader._offset = 0;
                        n3 = this.compare(transaction);
                        if (n3 > 0) {
                            this._upper = this._cursor - 1;
                            continue;
                        }
                        if (n3 >= 0) break block12;
                        this._lower = this._cursor + 1;
                    } while (this.adjustCursor());
                    if (this._cursor <= 0) {
                        if (n3 >= 0 || ixFileRange._entries <= 1) {
                            n = n3;
                        }
                    } else if (this._cursor >= ixFileRange._entries - 1 && n3 < 0) {
                        n = n3;
                    }
                }
                nArray[0] = this._lower;
                nArray[1] = this._upper;
                if (this._lower > this._upper) {
                    return n;
                }
                n3 = this._cursor;
                this._upper = this._cursor;
                this.adjustCursor();
                do {
                    this._reader.read(localObjectContainer, this._baseAddress, this._baseAddressOffset + this._addressOffset);
                    this._reader._offset = 0;
                    n2 = this.compare(transaction);
                    if (n2 == 0) {
                        this._upper = this._cursor;
                        continue;
                    }
                    this._lower = this._cursor + 1;
                    if (this._lower <= this._upper) continue;
                    nArray[0] = this._upper;
                    break block13;
                } while (this.adjustCursor());
                nArray[0] = this._upper;
            }
            this._upper = nArray[1];
            this._lower = n3;
            if (this._lower > this._upper) {
                this._lower = this._upper;
            }
            this.adjustCursor();
            do {
                this._reader.read(localObjectContainer, this._baseAddress, this._baseAddressOffset + this._addressOffset);
                this._reader._offset = 0;
                n2 = this.compare(transaction);
                if (n2 == 0) {
                    this._lower = this._cursor;
                    continue;
                }
                this._upper = this._cursor - 1;
                if (this._upper >= this._lower) continue;
                nArray[1] = this._lower;
                break block14;
            } while (this.adjustCursor());
            nArray[1] = this._lower;
        }
        return n;
    }

    private final int compare(Transaction transaction) {
        return this._handler.compareTo(this._handler.comparableObject(transaction, this._handler.readIndexEntry(this._reader)));
    }

    private Tree insert(IxFileRange ixFileRange, Tree tree, int n, int n2) {
        int n3 = n2 <= 0 ? 1 : 0;
        int n4 = (n + n3) * this._slotLength;
        int n5 = ixFileRange._entries - n - n3;
        ixFileRange._entries = n2 < 0 ? n + 1 : n;
        IxFileRange ixFileRange2 = new IxFileRange(ixFileRange._fieldTransaction, this._baseAddress, this._baseAddressOffset + n4, n5);
        ixFileRange2._subsequent = ixFileRange._subsequent;
        ixFileRange._subsequent = null;
        tree._preceding = ixFileRange.balanceCheckNulls();
        tree._subsequent = ixFileRange2.balanceCheckNulls();
        return tree.balance();
    }

    private void setFileRange(IxFileRange ixFileRange) {
        this._lower = 0;
        this._upper = ixFileRange._entries - 1;
        this._baseAddress = ixFileRange._address;
        this._baseAddressOffset = ixFileRange._addressOffset;
        this.adjustCursor();
    }
}

