/*
# Docsis cable modem diagnostics (cmdiag)
#
# Copyright (C) 2006-2007 Emil Penchev
#
# This program is free software, distributed under the terms of
# the GNU General Public License 2.0
#
*/


#ifndef CMODEM_H
#define CMODEM_H

#include <string>
#include <sstream>

using namespace std;

class CModem
{
	private:
		int cm_state; //0 is offline 1 is online
		int cmts_state;
		char * ip;
		char * cmts_ip;
		char * community_string;
		char * cmts_community_string;
		string mac;
		string uptime;
		string sys_descrpition;
		string ds_power;
		string us_power;
		string snr_downstream;
		string snr_upstream;
		string rf_downstrem_flow;
		string rf_upsteam_flow;
		string rf_downstrem_err;
		string rf_upstream_err;
		string freq_downstream;
		string freq_upstream;
		string channel_width_downstream;
		string channel_width_upstream;
		string modulation_upstream;
		string modulation_downstream;
		string receive_power_at_cmts;
		string resets;
		string received_inv_rang_resp;
		string received_inv_reg_resp;
		string aborted_rangings;
		string sig_unerroreds;
		string sig_correcteds;
		string sig_uncorrecteds;
		char * snmp_session_init(const char * docsis_oid, char * ip, char * community_string);
		char * get_cable_parameter(const char * docsis_oid, char * ip);
		char * get_cm_oidsid(char * cm_ip, char * cmts_ip, char * docsis_oid);
		char * get_channel_parameter(const char * docsis_oid);
		
	public:
		CModem(char * cmip, char * cmtsip, char * community_str, char * ctstring);
		~CModem() { delete ip; delete cmts_ip; delete community_string; delete cmts_community_string; }
		string * Get_Ds_Power();
		string * Get_Us_Power();
		string * Get_Ds_Snr();
		string * Get_Us_Snr();
		string * Get_RfDs_Data();
		string * Get_RfUs_Data();
		string * Get_RfDs_Err();
		string * Get_RfUs_Err();
		string * Get_CMTS_Rx_Power();
		string * Get_Ds_Freq();
		string * Get_Us_Freq();
		string * Get_Ds_Width();
		string * Get_Us_Width();
		string * Get_Ds_Modulation();
		string * Get_Us_Modulation();
		string * Get_Uptime();
		string * Get_Mac();
		string * Get_SysDesc();
		string * Get_CM_Resets();
		string * Get_Recv_Inv_Reg();
		string * Get_Recv_Inv_Rang();
		string * Get_Abort_Rang();
		string * Get_Unerror_Words();
		string * Get_Corerror_Words();
		string * Get_Uncorerror_Words();
		   int	 CM_Online();
		   int	 CMTS_Online();
};


#endif
