/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: client.h 112 2009-03-15 17:30:28Z loos-br $
 */

#ifndef CLIENT_H
#define CLIENT_H

#include <sys/types.h>
#include <sys/time.h>

#include <event.h>

#include "command.h"

typedef struct client__ {
    int			fd;		/* client connection fd */
    string		*xfr;		/* old xfr address */
    commands		commands;	/* command queue */
    struct event	read;		/* event queues */
    struct event	write;		/*      -       */
    struct event	listen;		/*      -       */
} client_;

#define read_client_command(a, b, c) read_command(&a->commands, a->fd, b, c)

void	new_client(const int listenfd, short event, void *ev);
void	client_write(int evfd, short event, void *client_);
void	client_read(const int evfd, short event, void *client_);
void	client_sched_read(client_ *client);
void	client_sched_write(client_ *client);
client_ *client_alloc(  int client_fd,
                        void (*fn_read)(int, short, void *),
                        void (*fn_write)(int, short, void *),
                        void *arg);
client_ *client_disconnect(client_ *client);
void	real_client_disconnect(client_ *client);
void	shift_client_commands(client_ *client, command *cmd);
int	client_flush_commands(client_ *client);

#endif
