/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: sql.h 96 2009-01-20 15:34:19Z loos-br $
 */

#ifndef SQL_H
#define SQL_H

#include "user.h"
#include "contacts.h"

int	sql_read_user_acl(struct user_ *user);
int	sql_disconnect_all(void);
int	sql_user_disconnect(string *email);
int	sql_users_update(struct user_ *user);
int	sql_set_status(struct user_ *user);
int	sql_update_user_dn(struct user_ *user);
__uint32_t	sql_insert_sb(struct user_ *user);
int	sql_remove_sb(int id);
int	sql_log_join(int sb_id, string *email, string *dn);
int	sql_log_stop2(struct sb_ *sb, string *email, string *contact_email);
int	sql_log_stop(struct sb_ *sb, string *email, string *dn);
int	sql_log_start(int sb_id, string *email, string *dn);
int	sql_log_msg(int sb_id, string *email, string *dn, string *to,
		string *msg);
int	sql_read_defaults(void);
int	sql_check_connect(string *email);
int	sql_connection_denied(string *email);
int	sql_version_denied(string *email);
int	sql_password_error(string *email);
int	sql_contact_save(struct user_ *user, struct contact_ *contact);
int	sql_contact_save_all(struct user_ *user);
int	sql_save_contactgroup(string *email, string *name, string *id);
int	sql_contact_load(struct user_ *user, struct contact_ *contact);
int	sql_contact_load_all(struct user_ *user);
int	sql_zero_ubx(string *email, string *contact);
int	sql_read_warning(string *warndn, string *warnmsg, string *warnemail,
		string *msgfont, string *msgcolor);

#endif
