/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.control;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.control.ProgressChangeType;
import javax.swing.SwingUtilities;

public class SetProgressAction
extends SystemInstallOrUninstallAction {
    private ProgressChangeType progressChangeType = ProgressChangeType.SET_PERCENT;
    private int percentValue;
    private int timerPeriod = 1000;
    private int timerMaxPercentValue = 100;
    private static TimerThread timerThread;

    protected boolean execute(Context context) throws UserCanceledException {
        ProgressInterface progressInterface = context.getProgressInterface();
        SetProgressAction.cancelTimer();
        if (this.progressChangeType == ProgressChangeType.SET_PERCENT) {
            progressInterface.setIndeterminateProgress(false);
            progressInterface.setPercentCompleted(this.percentValue);
        } else if (this.progressChangeType == ProgressChangeType.ADD_PERCENT) {
            progressInterface.setIndeterminateProgress(false);
            progressInterface.setPercentCompleted(this.percentValue + progressInterface.getPercentCompleted());
        } else if (this.progressChangeType == ProgressChangeType.SET_INDETERMINATE) {
            progressInterface.setIndeterminateProgress(true);
        } else if (this.progressChangeType == ProgressChangeType.SET_DETERMINATE) {
            progressInterface.setIndeterminateProgress(false);
        } else if (this.progressChangeType == ProgressChangeType.SET_TIMER) {
            progressInterface.setIndeterminateProgress(false);
            timerThread = new TimerThread(progressInterface, this.timerPeriod, this.timerMaxPercentValue);
            timerThread.start();
        }
        return true;
    }

    public ProgressChangeType getProgressChangeType() {
        return this.progressChangeType;
    }

    public void setProgressChangeType(ProgressChangeType progressChangeType) {
        this.progressChangeType = progressChangeType;
    }

    public int getPercentValue() {
        return this.percentValue;
    }

    public void setPercentValue(int n) {
        this.percentValue = n;
    }

    public int getTimerPeriod() {
        return this.timerPeriod;
    }

    public void setTimerPeriod(int n) {
        this.timerPeriod = n;
    }

    public int getTimerMaxPercentValue() {
        return this.timerMaxPercentValue;
    }

    public void setTimerMaxPercentValue(int n) {
        this.timerMaxPercentValue = n;
    }

    private static void cancelTimer() {
        if (timerThread != null && timerThread.isAlive()) {
            timerThread.cancel();
            timerThread.interrupt();
            try {
                timerThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            timerThread = null;
        }
    }

    private static class TimerThread
    extends Thread {
        private boolean canceled;
        private ProgressInterface progressInterface;
        private int timerPeriod;
        private int timerMaxPercentValue;

        public TimerThread(ProgressInterface progressInterface, int n, int n2) {
            super("progress timer");
            this.progressInterface = progressInterface;
            this.timerPeriod = n;
            this.timerMaxPercentValue = Math.min(n2, 100);
        }

        public void run() {
            while (!this.canceled && this.progressInterface.getPercentCompleted() < this.timerMaxPercentValue) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TimerThread.this.progressInterface.setPercentCompleted(TimerThread.this.progressInterface.getPercentCompleted() + 1);
                    }
                });
                try {
                    Thread.sleep(this.timerPeriod);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void cancel() {
            this.canceled = true;
        }
    }
}

