/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class RunExecutableAction
extends SystemInstallOrUninstallAction
implements PropertyLoggingInterceptor {
    public static final String PROPERTY_ARGUMENTS = "arguments";
    private File executable;
    private File workingDirectory;
    private String[] arguments;
    private boolean wait = false;
    private boolean logArguments = false;

    public Object getLogValueForProperty(String string, Object object) {
        if (string.equals(PROPERTY_ARGUMENTS) && !this.logArguments) {
            return "[logging of arguments is disabled]";
        }
        return object;
    }

    protected boolean execute(Context context) throws UserCanceledException {
        Process process;
        File file;
        for (file = context.getDestinationFile(this.getWorkingDirectory()); file != null && !file.exists(); file = file.getParentFile()) {
        }
        Logger.getInstance().info(this, "used working dir: " + file);
        File file2 = context.getDestinationFile(this.getExecutable());
        if (!file2.exists()) {
            Logger.getInstance().info(this, "executable does not exist: " + file2.getAbsolutePath());
        }
        if ((process = InstallerUtil.launchApplication(file2, file, this.getArguments())) == null) {
            Logger.getInstance().error(this, "process could not be created");
            return false;
        }
        new ConsumerThread(process.getInputStream()).start();
        new ConsumerThread(process.getErrorStream()).start();
        if (!this.wait) {
            return true;
        }
        try {
            int n = process.waitFor();
            if (n != 0) {
                Logger.getInstance().error(this, "return value is " + n);
            }
            return n == 0;
        }
        catch (InterruptedException interruptedException) {
            Logger.getInstance().info(this, interruptedException.toString());
            interruptedException.printStackTrace();
            return false;
        }
    }

    public File getExecutable() {
        return RunExecutableAction.replaceVariables(this.executable);
    }

    public void setExecutable(File file) {
        this.executable = file;
    }

    public File getWorkingDirectory() {
        return RunExecutableAction.replaceVariables(this.workingDirectory);
    }

    public void setWorkingDirectory(File file) {
        this.workingDirectory = file;
    }

    public String[] getArguments() {
        return RunExecutableAction.replaceVariables(this.arguments);
    }

    public void setArguments(String[] stringArray) {
        this.arguments = stringArray;
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean bl) {
        this.wait = bl;
    }

    public boolean isLogArguments() {
        return this.logArguments;
    }

    public void setLogArguments(boolean bl) {
        this.logArguments = bl;
    }

    private class ConsumerThread
    extends Thread {
        private boolean canceled;
        private InputStream stream;

        public ConsumerThread(InputStream inputStream) {
            this.stream = inputStream;
        }

        public void run() {
            byte[] byArray = new byte[512];
            while (!this.canceled) {
                try {
                    int n = this.stream.read(byArray);
                    if (n != -1) continue;
                    this.cancel();
                }
                catch (IOException iOException) {
                    this.cancel();
                }
            }
        }

        public synchronized void cancel() {
            this.canceled = true;
        }
    }
}

