/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.util.FileUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class Logger
implements InstallerEventListener {
    private static Logger instance;
    public static final String KEEP_LOGFILE_PROP = "install4j.keepLog";
    public static final String LOGTOSTDERR_FILE_PROP = "install4j.logToStderr";
    private PrintWriter out;
    private File logFile;
    private boolean moved;

    public static Logger getInstance() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    private Logger() {
        try {
            this.logFile = File.createTempFile("i4j_log", ".log");
            Runtime.getRuntime().addShutdownHook(new Thread("delete_log"){

                public void run() {
                    if (!Boolean.getBoolean(Logger.KEEP_LOGFILE_PROP) && Logger.this.logFile != null && !Logger.this.moved) {
                        Logger.this.out.close();
                        Logger.this.logFile.delete();
                    }
                }
            });
            this.out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.logFile)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(FileDescriptor.out)));
        }
        InstallerVariables.registerVariableProvider("sys.logFile", new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                try {
                    return Logger.this.logFile.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return Logger.this.logFile.getAbsolutePath();
                }
            }

            public void setVariable(Object object) {
            }
        });
        this.info(null, "logger started at " + new Date());
        this.info(null, "exectuable name: " + System.getProperty("exe4j.moduleName"));
        this.info(null, "Properties: ");
        System.getProperties().list(this.out);
    }

    public synchronized void moveLogFile(File file) {
        if (this.logFile != null) {
            this.moved = true;
            this.out.close();
            file.delete();
            if (!this.logFile.renameTo(file)) {
                try {
                    FileUtil.copyFile(this.logFile, file);
                    this.logFile.delete();
                    this.logFile = file;
                }
                catch (IOException iOException) {
                    System.err.println("could not move log file: " + iOException.getMessage());
                }
            }
            try {
                this.out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.logFile.getAbsolutePath(), true)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    public void installerEvent(InstallerEvent installerEvent) {
        this.log(installerEvent.getSource(), installerEvent.getVerbose(), installerEvent.wasSuccessful());
        if (installerEvent.getType() == EventType.BEFORE_EXECUTE_ACTION) {
            this.logActionProperties(installerEvent.getSource());
        }
    }

    public synchronized void log(Throwable throwable) {
        this.error(null, throwable.toString());
        throwable.printStackTrace(this.out);
        this.out.flush();
    }

    public synchronized void log(Object object, String string, boolean bl) {
        String string2 = this.getPrefix(bl);
        if (object != null) {
            string2 = object instanceof Class ? string2 + ((Class)object).getName() + ": " : string2 + object.getClass().getName() + ": ";
        }
        String string3 = string2 + string;
        this.out.println(string3);
        this.out.flush();
        if (Boolean.getBoolean(LOGTOSTDERR_FILE_PROP)) {
            System.err.println(string3);
        }
    }

    private String getPrefix(boolean bl) {
        if (bl) {
            return "[INFO] ";
        }
        return "[ERROR] ";
    }

    public void error(Object object, String string) {
        this.log(object, string, false);
    }

    public void info(Object object, String string) {
        this.log(object, string, true);
    }

    private void logActionProperties(Object object) {
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string = method.getName();
            if (method.getParameterTypes().length != 0 || string.equals("getClass") || (!string.startsWith("get") || string.length() <= 3) && (!string.startsWith("is") || string.length() <= 2)) continue;
            try {
                this.logProperty(object, string, method.invoke(object, null));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private void logProperty(Object object, String string, Object list) {
        String string2 = string.startsWith("get") ? string.substring(3, 4).toLowerCase() + string.substring(4) : string.substring(2, 3).toLowerCase() + string.substring(3);
        if (object instanceof PropertyLoggingInterceptor) {
            list = ((PropertyLoggingInterceptor)object).getLogValueForProperty(string2, list);
        }
        List<Object> list2 = list instanceof Object[] ? Arrays.asList((Object[])list) : list;
        this.info(object, "Property " + string2 + ": " + list2);
    }
}

