/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart.impl;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.BodyPartEntity;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.FormDataParam;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.server.impl.inject.InjectableValuesProvider;
import com.sun.jersey.server.impl.model.method.dispatch.AbstractResourceMethodDispatchProvider;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorProvider;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.container.JavaMethodInvoker;
import com.sun.jersey.spi.container.JavaMethodInvokerFactory;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import com.sun.jersey.spi.inject.Injectable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;

public class FormDataMultiPartDispatchProvider
extends AbstractResourceMethodDispatchProvider {
    private static final String FORM_MULTIPART_PROPERTY = "com.sun.jersey.api.representation.form.multipart";
    @Context
    private MessageBodyWorkers mbws;
    @Context
    private MultivaluedParameterExtractorProvider mpep;

    public RequestDispatcher create(AbstractResourceMethod abstractResourceMethod) {
        return this.create(abstractResourceMethod, JavaMethodInvokerFactory.getDefault());
    }

    public RequestDispatcher create(AbstractResourceMethod method, JavaMethodInvoker invoker) {
        MediaType m;
        if ("GET".equals(method.getHttpMethod())) {
            return null;
        }
        boolean found = false;
        Iterator i$ = method.getSupportedInputTypes().iterator();
        while (i$.hasNext() && !(found = !(m = (MediaType)i$.next()).isWildcardSubtype() && m.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE))) {
        }
        if (!found) {
            return null;
        }
        return super.create(method, invoker);
    }

    protected InjectableValuesProvider getInjectableValuesProvider(AbstractResourceMethod method) {
        if (method.getParameters().isEmpty()) {
            return null;
        }
        boolean hasFormParam = false;
        for (int i = 0; i < method.getParameters().size(); ++i) {
            Parameter parameter = (Parameter)method.getParameters().get(i);
            if (parameter.getAnnotation() == null) continue;
            hasFormParam |= parameter.getAnnotation().annotationType() == FormDataParam.class;
        }
        if (!hasFormParam) {
            return null;
        }
        return new FormDataInjectableValuesProvider(this.getInjectables(method));
    }

    private List<Injectable> getInjectables(AbstractResourceMethod method) {
        ArrayList<Injectable> list = new ArrayList<Injectable>(method.getParameters().size());
        for (int i = 0; i < method.getParameters().size(); ++i) {
            Parameter p = (Parameter)method.getParameters().get(i);
            if (Parameter.Source.ENTITY == p.getSource()) {
                if (FormDataMultiPart.class.isAssignableFrom(p.getParameterClass())) {
                    list.add((Injectable)((Object)new FormDataMultiPartInjectable()));
                    continue;
                }
                list.add(null);
                continue;
            }
            if (p.getAnnotation().annotationType() == FormDataParam.class) {
                if (Collection.class == p.getParameterClass() || List.class == p.getParameterClass()) {
                    Class c = ReflectionHelper.getGenericClass(p.getParameterType());
                    if (FormDataBodyPart.class == c) {
                        list.add((Injectable)((Object)new ListFormDataBodyPartMultiPartInjectable(p.getSourceName())));
                        continue;
                    }
                    if (FormDataContentDisposition.class != c) continue;
                    list.add((Injectable)((Object)new ListFormDataContentDispositionMultiPartInjectable(p.getSourceName())));
                    continue;
                }
                if (FormDataBodyPart.class == p.getParameterClass()) {
                    list.add((Injectable)((Object)new FormDataBodyPartMultiPartInjectable(p.getSourceName())));
                    continue;
                }
                if (FormDataContentDisposition.class == p.getParameterClass()) {
                    list.add((Injectable)((Object)new FormDataContentDispositionMultiPartInjectable(p.getSourceName())));
                    continue;
                }
                list.add((Injectable)((Object)new FormDataMultiPartParamInjectable(p)));
                continue;
            }
            Injectable injectable = this.getInjectableProviderContext().getInjectable(p, ComponentScope.PerRequest);
            list.add(injectable);
        }
        return list;
    }

    private final class FormDataMultiPartParamInjectable
    extends AbstractHttpContextInjectable<Object> {
        private final Parameter param;
        private final MultivaluedParameterExtractor extractor;

        FormDataMultiPartParamInjectable(Parameter param) {
            this.param = param;
            this.extractor = FormDataMultiPartDispatchProvider.this.mpep.get(param);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getValue(HttpContext context) {
            FormDataMultiPart fdmp = (FormDataMultiPart)context.getProperties().get(FormDataMultiPartDispatchProvider.FORM_MULTIPART_PROPERTY);
            List<FormDataBodyPart> fdbps = fdmp.getFields(this.param.getSourceName());
            FormDataBodyPart fdbp = fdbps != null ? fdbps.get(0) : null;
            MediaType mediaType = fdbp != null ? fdbp.getMediaType() : MediaType.TEXT_PLAIN_TYPE;
            MessageBodyReader messageBodyReader = FormDataMultiPartDispatchProvider.this.mbws.getMessageBodyReader(this.param.getParameterClass(), this.param.getParameterType(), this.param.getAnnotations(), mediaType);
            if (messageBodyReader != null) {
                InputStream in = null;
                if (fdbp == null) {
                    if (this.param.getDefaultValue() == null) return null;
                    in = new ByteArrayInputStream(this.param.getDefaultValue().getBytes());
                } else {
                    in = ((BodyPartEntity)fdbp.getEntity()).getInputStream();
                }
                try {
                    return messageBodyReader.readFrom(this.param.getParameterClass(), this.param.getParameterType(), this.param.getAnnotations(), mediaType, context.getRequest().getRequestHeaders(), in);
                }
                catch (IOException e) {
                    throw new ContainerException((Throwable)e);
                }
            }
            if (this.extractor == null) return null;
            MultivaluedMapImpl map = new MultivaluedMapImpl();
            if (fdbp == null) return this.extractor.extract((MultivaluedMap)map);
            try {
                for (FormDataBodyPart p : fdbps) {
                    mediaType = p.getMediaType();
                    MessageBodyReader<String> messageBodyReader2 = FormDataMultiPartDispatchProvider.this.mbws.getMessageBodyReader(String.class, (Type)((Object)String.class), this.param.getAnnotations(), mediaType);
                    String value = messageBodyReader2.readFrom(String.class, (Type)((Object)String.class), this.param.getAnnotations(), mediaType, context.getRequest().getRequestHeaders(), ((BodyPartEntity)p.getEntity()).getInputStream());
                    map.add(this.param.getSourceName(), value);
                }
                return this.extractor.extract((MultivaluedMap)map);
            }
            catch (IOException e) {
                throw new ContainerException((Throwable)e);
            }
        }
    }

    private static final class ListFormDataContentDispositionMultiPartInjectable
    extends AbstractHttpContextInjectable<List<FormDataContentDisposition>> {
        private final String name;

        ListFormDataContentDispositionMultiPartInjectable(String name) {
            this.name = name;
        }

        public List<FormDataContentDisposition> getValue(HttpContext context) {
            FormDataMultiPart fdmp = (FormDataMultiPart)context.getProperties().get(FormDataMultiPartDispatchProvider.FORM_MULTIPART_PROPERTY);
            List<FormDataBodyPart> fdbps = fdmp.getFields(this.name);
            if (fdbps == null) {
                return null;
            }
            ArrayList<FormDataContentDisposition> l = new ArrayList<FormDataContentDisposition>(fdbps.size());
            for (FormDataBodyPart fdbp : fdbps) {
                l.add(fdbp.getFormDataContentDisposition());
            }
            return l;
        }
    }

    private static final class FormDataContentDispositionMultiPartInjectable
    extends AbstractHttpContextInjectable<FormDataContentDisposition> {
        private final String name;

        FormDataContentDispositionMultiPartInjectable(String name) {
            this.name = name;
        }

        public FormDataContentDisposition getValue(HttpContext context) {
            FormDataMultiPart fdmp = (FormDataMultiPart)context.getProperties().get(FormDataMultiPartDispatchProvider.FORM_MULTIPART_PROPERTY);
            FormDataBodyPart fdbp = fdmp.getField(this.name);
            if (fdbp == null) {
                return null;
            }
            return fdmp.getField(this.name).getFormDataContentDisposition();
        }
    }

    private static final class ListFormDataBodyPartMultiPartInjectable
    extends AbstractHttpContextInjectable<List<FormDataBodyPart>> {
        private final String name;

        ListFormDataBodyPartMultiPartInjectable(String name) {
            this.name = name;
        }

        public List<FormDataBodyPart> getValue(HttpContext context) {
            FormDataMultiPart fdmp = (FormDataMultiPart)context.getProperties().get(FormDataMultiPartDispatchProvider.FORM_MULTIPART_PROPERTY);
            return fdmp.getFields(this.name);
        }
    }

    private static final class FormDataBodyPartMultiPartInjectable
    extends AbstractHttpContextInjectable<FormDataBodyPart> {
        private final String name;

        FormDataBodyPartMultiPartInjectable(String name) {
            this.name = name;
        }

        public FormDataBodyPart getValue(HttpContext context) {
            FormDataMultiPart fdmp = (FormDataMultiPart)context.getProperties().get(FormDataMultiPartDispatchProvider.FORM_MULTIPART_PROPERTY);
            return fdmp.getField(this.name);
        }
    }

    private static final class FormDataMultiPartInjectable
    extends AbstractHttpContextInjectable<Object> {
        private FormDataMultiPartInjectable() {
        }

        public Object getValue(HttpContext context) {
            return context.getProperties().get(FormDataMultiPartDispatchProvider.FORM_MULTIPART_PROPERTY);
        }
    }

    private static final class FormDataInjectableValuesProvider
    extends InjectableValuesProvider {
        public FormDataInjectableValuesProvider(List<Injectable> is) {
            super(is);
        }

        public Object[] getInjectableValues(HttpContext context) {
            FormDataMultiPart form = (FormDataMultiPart)context.getRequest().getEntity(FormDataMultiPart.class);
            context.getProperties().put(FormDataMultiPartDispatchProvider.FORM_MULTIPART_PROPERTY, form);
            return super.getInjectableValues(context);
        }
    }
}

