/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class ByteOption
extends Option {
    private byte value;

    public ByteOption() {
        this(0);
    }

    public ByteOption(ByteOption op) {
        super(op);
        op.value = op.getValue();
    }

    public ByteOption(byte value) {
        this(value, null);
    }

    public ByteOption(byte value, String longOption) {
        this(value, longOption, '\u0000');
    }

    public ByteOption(byte value, char shortOption) {
        this(value, null, shortOption);
    }

    public ByteOption(byte value, String longOption, char shortOption) {
        super(longOption, shortOption);
        this.value = value;
    }

    @Override
    public Object getObject() {
        return new Byte(this.value);
    }

    @Override
    public void modify(String value) throws OptionModificationException {
        try {
            this.value = Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            throw new OptionModificationException("Error. A byte must be specified, not '" + value + "'.");
        }
    }

    public void setValue(String value) throws OptionModificationException {
        this.modify(value);
    }

    public void setValue(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return Byte.toString(this.value);
    }

    @Override
    public String getTypeName() {
        return "BYTE";
    }

    public String toString() {
        return this.getStringValue();
    }
}

