/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldEditorFocusListener;
import net.sf.jabref.FieldNameLabel;
import net.sf.jabref.FieldTextMenu;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.gui.AutoCompleteListener;

public class FieldTextField
extends JTextField
implements FieldEditor {
    protected String fieldName;
    protected JLabel label;
    protected UndoManager undo;
    private AutoCompleteListener autoCompleteListener = null;

    public FieldTextField(String fieldName_, String content, boolean changeColorOnFocus) {
        super(content);
        this.setupUndoRedo();
        this.updateFont();
        this.addFocusListener(Globals.focusListener);
        if (changeColorOnFocus) {
            this.addFocusListener(new FieldEditorFocusListener());
        }
        this.fieldName = fieldName_;
        this.label = new FieldNameLabel(" " + Util.nCase(this.fieldName) + " ");
        this.setBackground(GUIGlobals.validFieldBackgroundColor);
        this.setForeground(GUIGlobals.editorTextColor);
        FieldTextMenu popMenu = new FieldTextMenu(this);
        this.addMouseListener(popMenu);
        this.label.addMouseListener(popMenu);
    }

    protected void setupUndoRedo() {
        this.undo = new UndoManager();
        Document doc = this.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                FieldTextField.this.undo.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (FieldTextField.this.undo.canUndo()) {
                        FieldTextField.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(Globals.prefs.getKey("Undo"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (FieldTextField.this.undo.canRedo()) {
                        FieldTextField.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(Globals.prefs.getKey("Redo"), "Redo");
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        if (this.undo != null) {
            this.undo.discardAllEdits();
        }
    }

    @Override
    public void append(String text) {
        this.setText(this.getText() + text);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void setLabelColor(Color c) {
        this.label.setForeground(c);
        throw new NullPointerException("ok");
    }

    @Override
    public JComponent getPane() {
        return this;
    }

    @Override
    public JComponent getTextComponent() {
        return this;
    }

    @Override
    public void setActiveBackgroundColor() {
        this.setBackground(GUIGlobals.activeBackground);
    }

    @Override
    public void setValidBackgroundColor() {
        this.setBackground(GUIGlobals.validFieldBackgroundColor);
    }

    @Override
    public void setInvalidBackgroundColor() {
        this.setBackground(GUIGlobals.invalidFieldBackgroundColor);
    }

    @Override
    public void updateFontColor() {
        this.setForeground(GUIGlobals.editorTextColor);
    }

    @Override
    public void updateFont() {
        this.setFont(GUIGlobals.CURRENTFONT);
    }

    @Override
    public void paste(String textToInsert) {
        int sel = this.getSelectionEnd() - this.getSelectionStart();
        if (sel < 1) {
            int cPos = this.getCaretPosition();
            this.select(cPos, cPos);
        }
        this.replaceSelection(textToInsert);
    }

    @Override
    public boolean hasUndoInformation() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean hasRedoInformation() {
        return false;
    }

    @Override
    public void redo() {
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        this.getDocument().addUndoableEditListener(listener);
    }

    @Override
    public void setAutoCompleteListener(AutoCompleteListener listener) {
        this.autoCompleteListener = listener;
    }

    @Override
    public void clearAutoCompleteSuggestion() {
        if (this.autoCompleteListener != null) {
            this.autoCompleteListener.clearCurrentSuggestion(this);
        }
    }
}

