/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import net.sf.jabref.FontSelectorDialog;

class FontSelector
extends JButton {
    private static final long serialVersionUID = 7745223550102664896L;
    static final String PLAIN = "plain";
    static final String BOLD = "bold";
    static final String BOLD_ITALIC = "bold-italic";
    static final String ITALIC = "italic";

    public FontSelector() {
        this(new Font("SansSerif", 0, 10));
    }

    public FontSelector(Font font) {
        this.setFont(font);
        this.setRequestFocusEnabled(false);
        this.addActionListener(new ActionHandler());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateText();
    }

    private void updateText() {
        String styleString;
        Font font = this.getFont();
        switch (font.getStyle()) {
            case 0: {
                styleString = PLAIN;
                break;
            }
            case 1: {
                styleString = BOLD;
                break;
            }
            case 2: {
                styleString = ITALIC;
                break;
            }
            case 3: {
                styleString = BOLD_ITALIC;
                break;
            }
            default: {
                styleString = "UNKNOWN!!!???";
            }
        }
        this.setText(font.getFamily() + " " + font.getSize() + " " + styleString);
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Font font = new FontSelectorDialog(FontSelector.this, FontSelector.this.getFont()).getSelectedFont();
            if (font != null) {
                FontSelector.this.setFont(font);
            }
        }
    }
}

