/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchTextListener;

public class JTextAreaWithHighlighting
extends JTextArea
implements SearchTextListener {
    private ArrayList<String> wordsToHighlight;
    private UndoManager undo;

    public JTextAreaWithHighlighting() {
        this.setupUndoRedo();
    }

    public JTextAreaWithHighlighting(String text) {
        super(text);
        this.setupUndoRedo();
    }

    public JTextAreaWithHighlighting(Document doc) {
        super(doc);
        this.setupUndoRedo();
    }

    public JTextAreaWithHighlighting(int rows, int columns) {
        super(rows, columns);
        this.setupUndoRedo();
    }

    public JTextAreaWithHighlighting(String text, int rows, int columns) {
        super(text, rows, columns);
        this.setupUndoRedo();
    }

    public JTextAreaWithHighlighting(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.setupUndoRedo();
    }

    protected void setupUndoRedo() {
        this.undo = new UndoManager();
        Document doc = this.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                JTextAreaWithHighlighting.this.undo.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (JTextAreaWithHighlighting.this.undo.canUndo()) {
                        JTextAreaWithHighlighting.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(Globals.prefs.getKey("Undo"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (JTextAreaWithHighlighting.this.undo.canRedo()) {
                        JTextAreaWithHighlighting.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(Globals.prefs.getKey("Redo"), "Redo");
    }

    private void highLight(ArrayList<String> words) {
        Highlighter h = this.getHighlighter();
        h.removeAllHighlights();
        if (words == null || words.isEmpty() || words.get(0).isEmpty()) {
            return;
        }
        String content = this.getText();
        if (content.isEmpty()) {
            return;
        }
        Matcher matcher = Globals.getPatternForWords(words).matcher(content);
        while (matcher.find()) {
            try {
                h.addHighlight(matcher.start(), matcher.end(), DefaultHighlighter.DefaultPainter);
            }
            catch (BadLocationException ble) {
                System.out.println(ble);
            }
        }
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        if (Globals.prefs.getBoolean("highLightWords")) {
            this.highLight(this.wordsToHighlight);
        }
        if (this.undo != null) {
            this.undo.discardAllEdits();
        }
    }

    @Override
    public void searchText(ArrayList<String> words) {
        if (Globals.prefs.getBoolean("highLightWords")) {
            this.wordsToHighlight = words;
            this.highLight(words);
        } else if (this.wordsToHighlight != null) {
            this.wordsToHighlight = null;
            this.highLight(null);
        }
    }
}

