/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.text.JTextComponent;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldTextArea;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.undo.UndoablePreambleChange;

public class PreambleEditor
extends JDialog {
    BibtexDatabase base;
    BasePanel panel;
    JabRefFrame baseFrame;
    JabRefPreferences prefs;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JLabel lab;
    Container conPane = this.getContentPane();
    JPanel pan = new JPanel();
    FieldEditor ed;
    StoreFieldAction storeFieldAction = new StoreFieldAction();
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    CloseAction closeAction = new CloseAction();

    public PreambleEditor(JabRefFrame baseFrame, BasePanel panel, BibtexDatabase base, JabRefPreferences prefs) {
        super(baseFrame);
        this.baseFrame = baseFrame;
        this.panel = panel;
        this.base = base;
        this.prefs = prefs;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PreambleEditor.this.closeAction.actionPerformed(null);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                PreambleEditor.this.ed.requestFocus();
            }
        });
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component c) {
                return super.accept(c) && c instanceof FieldEditor;
            }
        });
        int prefHeight = (int)(2.0 * (double)GUIGlobals.FORM_HEIGHT[prefs.getInt("entryTypeFormHeightFactor")]);
        this.setSize(GUIGlobals.FORM_WIDTH[prefs.getInt("entryTypeFormWidth")], prefHeight);
        this.pan.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.weighty = 1.0;
        this.con.insets = new Insets(10, 5, 10, 5);
        String content = base.getPreamble();
        this.ed = new FieldTextArea(Globals.lang("Preamble"), content != null ? content : "");
        this.setupJTextComponent((FieldTextArea)this.ed);
        this.gbl.setConstraints(this.ed.getLabel(), this.con);
        this.pan.add(this.ed.getLabel());
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.ed.getPane(), this.con);
        this.pan.add(this.ed.getPane());
        this.conPane.add((Component)this.pan, "Center");
        this.setTitle(Globals.lang("Edit preamble"));
    }

    private void setupJTextComponent(JTextComponent ta) {
        ta.getInputMap().put(this.prefs.getKey("Close preamble editor"), "close");
        ta.getActionMap().put("close", this.closeAction);
        ta.getInputMap().put(this.prefs.getKey("Preamble editor, store changes"), "store");
        ta.getActionMap().put("store", this.storeFieldAction);
        ta.getInputMap().put(this.prefs.getKey("Close preamble editor"), "close");
        ta.getActionMap().put("close", this.closeAction);
        ta.getInputMap().put(this.prefs.getKey("Undo"), "undo");
        ta.getActionMap().put("undo", this.undoAction);
        ta.getInputMap().put(this.prefs.getKey("Redo"), "redo");
        ta.getActionMap().put("redo", this.redoAction);
        ta.addFocusListener(new FieldListener());
    }

    public void updatePreamble() {
        this.ed.setText(this.base.getPreamble());
    }

    public FieldEditor getFieldEditor() {
        return this.ed;
    }

    public void storeCurrentEdit() {
        this.storeFieldAction.actionPerformed(null);
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Globals.lang("Close window"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreambleEditor.this.storeFieldAction.actionPerformed(null);
            PreambleEditor.this.panel.preambleEditorClosing();
            PreambleEditor.this.dispose();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Undo", GUIGlobals.getImage("redo"));
            this.putValue("ShortDescription", "Redo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PreambleEditor.this.panel.runCommand("redo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", GUIGlobals.getImage("undo"));
            this.putValue("ShortDescription", "Undo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PreambleEditor.this.panel.runCommand("undo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class StoreFieldAction
    extends AbstractAction {
        public StoreFieldAction() {
            super("Store field value");
            this.putValue("ShortDescription", "Store field value");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String toSet = null;
            if (PreambleEditor.this.ed.getText().length() > 0) {
                toSet = PreambleEditor.this.ed.getText();
            }
            boolean set = toSet == null ? PreambleEditor.this.base.getPreamble() != null : PreambleEditor.this.base.getPreamble() == null || !toSet.equals(PreambleEditor.this.base.getPreamble());
            if (set) {
                PreambleEditor.this.panel.undoManager.addEdit(new UndoablePreambleChange(PreambleEditor.this.base, PreambleEditor.this.panel, PreambleEditor.this.base.getPreamble(), toSet));
                PreambleEditor.this.base.setPreamble(toSet);
                if (toSet != null && toSet.length() > 0) {
                    PreambleEditor.this.ed.setLabelColor(GUIGlobals.entryEditorLabelColor);
                    PreambleEditor.this.ed.setValidBackgroundColor();
                } else {
                    PreambleEditor.this.ed.setLabelColor(GUIGlobals.nullFieldColor);
                    PreambleEditor.this.ed.setValidBackgroundColor();
                }
                if (PreambleEditor.this.ed.getTextComponent().hasFocus()) {
                    PreambleEditor.this.ed.setActiveBackgroundColor();
                }
                PreambleEditor.this.panel.markBaseChanged();
            }
        }
    }

    class FieldListener
    extends FocusAdapter {
        FieldListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                PreambleEditor.this.storeFieldAction.actionPerformed(new ActionEvent(e.getSource(), 0, ""));
            }
        }
    }
}

