/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.export.LatexFieldFormatter;

public class TransferableBibtexEntry
implements Transferable {
    private BibtexEntry[] data;
    public static DataFlavor entryFlavor = new DataFlavor(BibtexEntry.class, "JabRef entry");

    public TransferableBibtexEntry(BibtexEntry[] data) {
        this.data = data;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{entryFlavor, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(entryFlavor) || flavor.equals(DataFlavor.stringFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(entryFlavor)) {
            return this.data;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            try {
                StringWriter sw = new StringWriter();
                LatexFieldFormatter ff = new LatexFieldFormatter();
                for (int i = 0; i < this.data.length; ++i) {
                    this.data[i].write(sw, ff, false);
                }
                return sw.toString();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Could not paste entry as text:\n" + ex.getMessage(), "Clipboard", 0);
                return "";
            }
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

