/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.about;

import java.awt.Color;
import java.awt.Font;
import java.util.Random;
import javax.swing.UIManager;

public class AboutTextLine {
    private String text;
    private double[] direction;
    private double[] pos;
    private double speed;
    private double accel;
    private int tag;
    private Font font;
    private Color color;
    private boolean visible;

    public AboutTextLine(String txt) {
        Random rand = new Random(System.currentTimeMillis() * (long)this.hashCode());
        this.text = txt;
        this.pos = new double[2];
        this.pos[0] = rand.nextDouble() * 100.0;
        this.pos[1] = rand.nextDouble() * 100.0;
        this.direction = new double[2];
        this.direction[0] = rand.nextDouble();
        this.direction[1] = rand.nextDouble();
        this.accel = 0.0;
        this.speed = 1.0;
        this.tag = 0;
        this.color = Color.black;
        this.visible = true;
        this.font = UIManager.getFont("Label.font");
    }

    public void performTimeStep(double time) {
        this.accel *= time;
        this.speed += this.accel;
        double move = this.speed * time;
        this.pos[0] = this.pos[0] + move * this.direction[0];
        this.pos[1] = this.pos[1] + move * this.direction[1];
    }

    public String toString() {
        return this.text + "<" + this.pos[0] + ", " + this.pos[1] + ">" + "<" + this.direction[0] + ", " + this.direction[1] + ">";
    }

    public int getPosX() {
        return (int)this.pos[0];
    }

    public int getPosY() {
        return (int)this.pos[1];
    }

    public double[] getPos() {
        return this.pos;
    }

    public void setPos(double posX, double posY) {
        this.pos[0] = posX;
        this.pos[1] = posY;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String pText) {
        this.text = pText;
    }

    public double[] getDirection() {
        return this.direction;
    }

    public void setDirection(double dirX, double dirY) {
        this.direction[0] = dirX;
        this.direction[1] = dirY;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double pSpeed) {
        this.speed = pSpeed;
    }

    public double getAccel() {
        return this.accel;
    }

    public void setAccel(double pAccel) {
        this.accel = pAccel;
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int pTag) {
        this.tag = pTag;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font pFont) {
        this.font = pFont;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color pColor) {
        this.color = pColor;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean pVisible) {
        this.visible = pVisible;
    }
}

