/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.export.IExportFormat;

public class ExportFileFilter
extends FileFilter
implements Comparable<ExportFileFilter> {
    private IExportFormat format;
    private String extension;
    private String name;

    public ExportFileFilter(IExportFormat format, String extension) {
        this.format = format;
        this.extension = extension;
        this.name = format.getDisplayName() + " (*" + extension + ")";
    }

    public IExportFormat getExportFormat() {
        return this.format;
    }

    public String getExtension() {
        return this.extension;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getPath().toLowerCase().endsWith(this.extension);
    }

    @Override
    public String getDescription() {
        return this.name;
    }

    @Override
    public int compareTo(ExportFileFilter o) {
        return this.name.compareTo(o.name);
    }
}

