/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.export.ExportFormat;
import net.sf.jabref.export.OOCalcDatabase;

public class OpenOfficeDocumentCreator
extends ExportFormat {
    public OpenOfficeDocumentCreator() {
        super(Globals.lang("OpenOffice Calc"), "oocalc", null, null, ".sxc");
    }

    @Override
    public void performExport(BibtexDatabase database, MetaData metaData, String file, String encoding, Set<String> keySet) throws Exception {
        OpenOfficeDocumentCreator.exportOpenOfficeCalc(new File(file), database, keySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeOpenOfficeFile(File file, InputStream source) throws Exception {
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            ZipEntry zipEntry = new ZipEntry("content.xml");
            out.putNextEntry(zipEntry);
            int c = -1;
            while ((c = source.read()) >= 0) {
                out.write(c);
            }
            out.closeEntry();
            OpenOfficeDocumentCreator.addResourceFile("meta.xml", "/resource/openoffice/meta.xml", out);
            OpenOfficeDocumentCreator.addResourceFile("mimetype", "/resource/openoffice/mimetype", out);
            OpenOfficeDocumentCreator.addResourceFile("META-INF/manifest.xml", "/resource/openoffice/manifest.xml", out);
        }
        finally {
            out.close();
        }
    }

    public static void exportOpenOfficeCalc(File file, BibtexDatabase database, Set<String> keySet) throws Exception {
        File tmpFile = File.createTempFile("oocalc", null);
        OpenOfficeDocumentCreator.exportOpenOfficeCalcXML(tmpFile, database, keySet);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(tmpFile));
        OpenOfficeDocumentCreator.storeOpenOfficeFile(file, in);
        tmpFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportOpenOfficeCalcXML(File tmpFile, BibtexDatabase database, Set<String> keySet) {
        OOCalcDatabase od = new OOCalcDatabase(database, keySet);
        try {
            OutputStreamWriter ps = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF8");
            try {
                DOMSource source = new DOMSource(od.getDOMrepresentation());
                StreamResult result = new StreamResult(ps);
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.setOutputProperty("indent", "yes");
                trans.transform(source, result);
            }
            finally {
                ((Writer)ps).close();
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static void addResourceFile(String name, String resource, ZipOutputStream out) throws IOException {
        ZipEntry zipEntry = new ZipEntry(name);
        out.putNextEntry(zipEntry);
        OpenOfficeDocumentCreator.addFromResource(resource, out);
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFromResource(String resource, OutputStream out) {
        URL url = OpenOfficeDocumentCreator.class.getResource(resource);
        try {
            InputStream in = url.openStream();
            byte[] buffer = new byte[256];
            InputStream inputStream = in;
            synchronized (inputStream) {
                OutputStream outputStream = out;
                synchronized (outputStream) {
                    int bytesRead;
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

