/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.labelPattern.LabelPattern;
import net.sf.jabref.labelPattern.LabelPatternPanel;

public class BibtexKeyPatternDialog
extends JDialog {
    private MetaData metaData;
    private BasePanel panel;
    private LabelPatternPanel labelPatternPanel;

    public BibtexKeyPatternDialog(JabRefFrame parent, BasePanel panel) {
        super(parent, Globals.lang("Bibtex key patterns"), true);
        this.labelPatternPanel = new LabelPatternPanel(parent.helpDiag);
        this.setPanel(panel);
        this.init();
    }

    public void setPanel(BasePanel panel) {
        this.panel = panel;
        this.metaData = panel.metaData();
        LabelPattern keypatterns = this.metaData.getLabelPattern();
        this.labelPatternPanel.setValues(keypatterns);
    }

    private final void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.labelPatternPanel, "Center");
        JButton ok = new JButton(Globals.lang("Ok"));
        JButton cancel = new JButton();
        JPanel lower = new JPanel();
        lower.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ButtonBarBuilder bb = new ButtonBarBuilder(lower);
        bb.addGlue();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        this.getContentPane().add((Component)lower, "South");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setPreferredSize(new Dimension(500, 600));
        this.pack();
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BibtexKeyPatternDialog.this.metaData.setLabelPattern(BibtexKeyPatternDialog.this.labelPatternPanel.getLabelPattern());
                BibtexKeyPatternDialog.this.panel.markNonUndoableBaseChanged();
                BibtexKeyPatternDialog.this.dispose();
            }
        });
        final BibtexKeyPatternDialog dialog = this;
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        cancel.setAction(cancelAction);
        cancel.setText(Globals.lang("Cancel"));
        Util.bindCloseDialogKeyToCancelAction(this.getRootPane(), cancelAction);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            super.setVisible(visible);
        }
    }
}

