/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;

public class FieldSetComponent
extends JPanel
implements ActionListener {
    protected Set<ActionListener> additionListeners = new HashSet<ActionListener>();
    protected JList list;
    protected JScrollPane sp = null;
    protected DefaultListModel listModel;
    protected JComboBox sel;
    protected JTextField input;
    protected JLabel title = null;
    protected JButton add;
    protected JButton remove;
    protected JButton up = null;
    protected JButton down = null;
    protected GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints con = new GridBagConstraints();
    protected boolean forceLowerCase;
    protected boolean changesMade = false;
    protected Set<ListDataListener> modelListeners = new HashSet<ListDataListener>();

    public FieldSetComponent(String title, List<String> fields, List<String> preset, boolean arrows, boolean forceLowerCase) {
        this(title, fields, preset, "Add", "Remove", arrows, forceLowerCase);
    }

    public FieldSetComponent(String title, List<String> fields, boolean arrows, boolean forceLowerCase) {
        this(title, fields, null, "Add", "Remove", arrows, forceLowerCase);
    }

    public FieldSetComponent(String title, List<String> fields, List<String> preset, String addText, String removeText, boolean arrows, boolean forceLowerCase) {
        this.forceLowerCase = forceLowerCase;
        this.add = new JButton(Globals.lang(addText));
        this.remove = new JButton(Globals.lang(removeText));
        this.listModel = new DefaultListModel();
        if (title != null) {
            this.title = new JLabel(title);
        }
        for (String field : fields) {
            this.listModel.addElement(field);
        }
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(2);
        this.add.addActionListener(this);
        this.remove.addActionListener(this);
        this.setLayout(this.gbl);
        this.con.insets = new Insets(1, 1, 1, 1);
        this.con.fill = 1;
        this.con.weightx = 1.0;
        this.con.gridwidth = 0;
        if (this.title != null) {
            this.gbl.setConstraints(this.title, this.con);
            this.add(this.title);
        }
        this.con.weighty = 1.0;
        this.sp = new JScrollPane(this.list, 20, 31);
        this.gbl.setConstraints(this.sp, this.con);
        this.add(this.sp);
        this.con.weighty = 0.0;
        this.con.gridwidth = 1;
        if (arrows) {
            this.con.weightx = 0.0;
            this.up = new JButton(GUIGlobals.getImage("up"));
            this.down = new JButton(GUIGlobals.getImage("down"));
            this.up.addActionListener(this);
            this.down.addActionListener(this);
            this.up.setToolTipText(Globals.lang("Move up"));
            this.down.setToolTipText(Globals.lang("Move down"));
            this.gbl.setConstraints(this.up, this.con);
            this.add(this.up);
            this.gbl.setConstraints(this.down, this.con);
            this.add(this.down);
            this.con.weightx = 0.0;
        }
        Component strut = Box.createHorizontalStrut(5);
        this.gbl.setConstraints(strut, this.con);
        this.add(strut);
        this.con.weightx = 1.0;
        this.con.gridwidth = 0;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.remove, this.con);
        this.add(this.remove);
        this.con.gridwidth = 3;
        this.con.weightx = 1.0;
        if (preset != null) {
            this.sel = new JComboBox<Object>(preset.toArray());
            this.sel.setEditable(true);
            this.gbl.setConstraints(this.sel, this.con);
            this.add(this.sel);
        } else {
            this.input = new JTextField(20);
            this.input.addActionListener(this);
            this.gbl.setConstraints(this.input, this.con);
            this.add(this.input);
        }
        this.con.gridwidth = 0;
        this.con.weighty = 0.0;
        this.con.weightx = 0.5;
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.add, this.con);
        this.add(this.add);
    }

    public void setListSelectionMode(int mode) {
        this.list.setSelectionMode(mode);
    }

    public void selectField(String fieldName) {
        int idx = this.listModel.indexOf(fieldName);
        if (idx >= 0) {
            this.list.setSelectedIndex(idx);
        }
        JViewport viewport = this.sp.getViewport();
        viewport.scrollRectToVisible(this.list.getCellBounds(idx, idx));
    }

    public String getFirstSelected() {
        Object o = this.list.getSelectedValue();
        if (o == null) {
            return null;
        }
        return (String)o;
    }

    @Override
    public void setEnabled(boolean en) {
        if (this.input != null) {
            this.input.setEnabled(en);
        }
        if (this.sel != null) {
            this.sel.setEnabled(en);
        }
        if (this.up != null) {
            this.up.setEnabled(en);
            this.down.setEnabled(en);
        }
        this.add.setEnabled(en);
        this.remove.setEnabled(en);
    }

    public void setFields(List<String> fields) {
        DefaultListModel<String> newListModel = new DefaultListModel<String>();
        for (String field : fields) {
            newListModel.addElement(field);
        }
        this.listModel = newListModel;
        Iterator<ListDataListener> i = this.modelListeners.iterator();
        while (i.hasNext()) {
            newListModel.addListDataListener(i.next());
        }
        this.list.setModel(newListModel);
    }

    protected void addField(String s) {
        s = s.trim();
        if (this.forceLowerCase) {
            s = s.toLowerCase();
        }
        if (s.equals("") || this.listModel.contains(s)) {
            return;
        }
        String testString = Util.checkLegalKey(s);
        if (!testString.equals(s) || s.indexOf(38) >= 0) {
            JOptionPane.showMessageDialog(this, Globals.lang("Field names are not allowed to contain white space or the following characters") + ": # { } ~ , ^ &", Globals.lang("Error"), 0);
            return;
        }
        this.addFieldUncritically(s);
    }

    protected void addFieldUncritically(String s) {
        this.listModel.addElement(s);
        this.changesMade = true;
        Iterator<ActionListener> i = this.additionListeners.iterator();
        while (i.hasNext()) {
            i.next().actionPerformed(new ActionEvent(this, 0, s));
        }
    }

    protected void removeSelected() {
        int[] selected = this.list.getSelectedIndices();
        if (selected.length > 0) {
            this.changesMade = true;
        }
        for (int i = 0; i < selected.length; ++i) {
            this.listModel.removeElementAt(selected[selected.length - 1 - i]);
        }
    }

    public void activate() {
        this.sel.requestFocus();
    }

    public boolean changesMade() {
        return this.changesMade;
    }

    public List<String> getFields() {
        Object[] o = this.listModel.toArray();
        return Arrays.asList(o);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.list.addListSelectionListener(l);
    }

    public void addAdditionActionListener(ActionListener l) {
        this.additionListeners.add(l);
    }

    public void removeAdditionActionListener(ActionListener l) {
        this.additionListeners.remove(l);
    }

    public void addListDataListener(ListDataListener l) {
        this.listModel.addListDataListener(l);
        this.modelListeners.add(l);
    }

    public void move(int dy) {
        int oldIdx = this.list.getSelectedIndex();
        if (oldIdx < 0) {
            return;
        }
        Object o = this.listModel.get(oldIdx);
        int newInd = Math.max(0, Math.min(this.listModel.size() - 1, oldIdx + dy));
        this.listModel.remove(oldIdx);
        this.listModel.add(newInd, o);
        this.list.setSelectedIndex(newInd);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.add) {
            if (this.sel != null && this.sel.getSelectedItem() != null) {
                String s = this.sel.getSelectedItem().toString();
                this.addField(s);
            } else if (this.input != null && !this.input.getText().equals("")) {
                this.addField(this.input.getText());
            }
        } else if (src == this.input) {
            this.addField(this.input.getText());
        } else if (src == this.remove) {
            this.removeSelected();
        } else if (src == this.sel) {
            if (e.getActionCommand().equals("comboBoxChanged") && e.getModifiers() == 0) {
                return;
            }
            String s = this.sel.getSelectedItem().toString();
            this.addField(s);
            this.sel.getEditor().selectAll();
        } else if (src == this.up) {
            this.move(-1);
        } else if (src == this.down) {
            this.move(1);
        }
    }
}

