/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.TreeMap;
import javax.swing.JTabbedPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;

public class SortTabsAction
extends MnemonicAwareAction
implements Comparator<String> {
    private JabRefFrame frame;

    public SortTabsAction(JabRefFrame frame) {
        this.putValue("Name", "Sort tabs");
        this.putValue("ShortDescription", Globals.lang("Rearrange tabs alphabetically by title"));
        this.frame = frame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTabbedPane tabbedPane = this.frame.getTabbedPane();
        TreeMap<String, BasePanel> map = new TreeMap<String, BasePanel>(this);
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            BasePanel panel = (BasePanel)tabbedPane.getComponent(i);
            map.put(tabbedPane.getTitleAt(i), panel);
        }
        tabbedPane.removeAll();
        for (String title : map.keySet()) {
            BasePanel panel = (BasePanel)map.get(title);
            tabbedPane.addTab(title, panel);
        }
    }

    @Override
    public int compare(String o1, String o2) {
        return o1.toLowerCase().compareTo(o2.toLowerCase());
    }
}

