/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.OutputPrinterToNull;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.imports.EntryFromFileCreator;
import net.sf.jabref.imports.PdfContentImporter;
import net.sf.jabref.util.EncryptionNotSupportedException;
import net.sf.jabref.util.XMPUtil;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;

public class EntryFromPDFCreator
extends EntryFromFileCreator {
    private static Logger logger = Logger.getLogger(EntryFromPDFCreator.class.getName());

    public EntryFromPDFCreator() {
        super(EntryFromPDFCreator.getPDFExternalFileType());
    }

    private static ExternalFileType getPDFExternalFileType() {
        ExternalFileType pdfFileType = JabRefPreferences.getInstance().getExternalFileTypeByExt("pdf");
        if (pdfFileType == null) {
            return new ExternalFileType("PDF", "pdf", "application/pdf", "evince", "pdfSmall");
        }
        return pdfFileType;
    }

    @Override
    public boolean accept(File f) {
        return f != null && f.getName().toUpperCase().endsWith(".PDF");
    }

    @Override
    protected BibtexEntry createBibtexEntry(File pdfFile) {
        if (!this.accept(pdfFile)) {
            return null;
        }
        BibtexEntry entry = new BibtexEntry();
        PdfContentImporter pci = new PdfContentImporter();
        try {
            ArrayList list = (ArrayList)pci.importEntries(new FileInputStream(pdfFile), new OutputPrinterToNull());
            if (list != null && !list.isEmpty()) {
                return (BibtexEntry)list.iterator().next();
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "File not found", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error opening file", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntryDataFromPDDocumentInformation(File pdfFile, BibtexEntry entry) {
        PDDocument document = null;
        try {
            BibtexEntry entryDI;
            document = PDDocument.load(pdfFile.getAbsoluteFile());
            PDDocumentInformation pdfDocInfo = document.getDocumentInformation();
            if (pdfDocInfo != null && (entryDI = XMPUtil.getBibtexEntryFromDocumentInformation(document.getDocumentInformation())) != null) {
                this.addEntryDataToEntry(entry, entryDI);
                Calendar creationDate = pdfDocInfo.getCreationDate();
                if (creationDate != null) {
                    String date = new SimpleDateFormat("yyyy.MM.dd").format(creationDate.getTime());
                    this.appendToField(entry, "timestamp", date.toString());
                }
                if (pdfDocInfo.getCustomMetadataValue("bibtex/bibtexkey") != null) {
                    entry.setId(pdfDocInfo.getCustomMetadataValue("bibtex/bibtexkey"));
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void addEntyDataFromXMP(File aFile, BibtexEntry entry) {
        try {
            List<BibtexEntry> entrys = XMPUtil.readXMP(aFile.getAbsoluteFile());
            this.addEntrysToEntry(entry, entrys);
        }
        catch (EncryptionNotSupportedException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getFormatName() {
        return "PDF";
    }
}

