/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.label;

import java.util.Hashtable;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Util;
import net.sf.jabref.label.ArticleLabelRule;
import net.sf.jabref.label.LabelRule;

public class LabelMaker {
    protected LabelRule defaultRule = new ArticleLabelRule();
    protected Hashtable<String, LabelRule> ruleTable = new Hashtable();

    public BibtexEntry applyRule(BibtexEntry newEntry, BibtexDatabase base) {
        String newKey = "";
        newKey = this.ruleTable.containsKey(newEntry.getType().getName()) ? this.ruleTable.get(newEntry.getType().getName()).applyRule(newEntry) : this.applyDefaultRule(newEntry);
        newKey = Util.checkLegalKey(newKey);
        if (base.setCiteKeyForEntry(newEntry.getId(), newKey)) {
            char c = 'b';
            String modKey = newKey + "a";
            while (base.setCiteKeyForEntry(newEntry.getId(), modKey)) {
                char c2 = c;
                c = (char)(c + 1);
                modKey = newKey + c2;
            }
        }
        return newEntry;
    }

    public void setDefaultRule(LabelRule newRule) {
        this.defaultRule = newRule;
    }

    public String applyDefaultRule(BibtexEntry newEntry) {
        return this.defaultRule.applyRule(newEntry);
    }

    public void addRule(LabelRule rule, BibtexEntryType type) {
        this.ruleTable.put(type.getName(), rule);
    }
}

