/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.labelPattern;

import java.util.ArrayList;
import java.util.Hashtable;
import net.sf.jabref.labelPattern.LabelPatternUtil;

public class LabelPattern
extends Hashtable<String, ArrayList<String>> {
    private ArrayList<String> defaultPattern = null;
    protected LabelPattern parent = null;

    public LabelPattern() {
    }

    public LabelPattern(LabelPattern parent) {
        this.parent = parent;
    }

    public void setParent(LabelPattern parent) {
        this.parent = parent;
    }

    public LabelPattern getParent() {
        return this.parent;
    }

    public void addLabelPattern(String type, String pattern) {
        this.put(type, LabelPatternUtil.split(pattern));
    }

    public void removeLabelPattern(String type) {
        if (this.containsKey(type) && this.parent != null) {
            this.remove(type);
        }
    }

    public void removeLabelPattern(String type, boolean sure) {
        if (this.containsKey(type) && sure) {
            this.remove(type);
        }
    }

    public final ArrayList<String> getValue(String key) {
        ArrayList<String> result = (ArrayList<String>)this.get(key);
        if (result == null && (result = this.getDefaultValue()) == null) {
            if (this.parent != null) {
                result = this.parent.getValue(key);
            } else {
                return LabelPatternUtil.DEFAULT_LABELPATTERN;
            }
        }
        return result;
    }

    public final boolean isDefaultValue(String key) {
        Object _obj = this.get(key);
        return _obj == null;
    }

    public ArrayList<String> getDefaultValue() {
        return this.defaultPattern;
    }

    public void setDefaultValue(String labelPattern) {
        ArrayList<String> split = LabelPatternUtil.split(labelPattern);
        this.defaultPattern = split;
    }
}

