/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.star.container.XNameAccess;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.oo.OOBibBase;

public class CitationManager {
    OOBibBase ooBase;
    JDialog diag;
    EventList<CitEntry> list;
    JTable table;
    EventTableModel tableModel;
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));

    public CitationManager(final JabRefFrame frame, OOBibBase ooBase) throws Exception {
        this.diag = new JDialog(frame, Globals.lang("Manage citations"), true);
        this.ooBase = ooBase;
        this.list = new BasicEventList<CitEntry>();
        XNameAccess nameAccess = ooBase.getReferenceMarks();
        String[] names = ooBase.getJabRefReferenceMarks(nameAccess);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            List<String> keys = ooBase.parseRefMarkName(name);
            this.list.add(new CitEntry(name, keys, "<html>..." + ooBase.getCitationContext(nameAccess, name, 30, 30, true) + "...</html>", ooBase.getCustomProperty(name)));
        }
        this.tableModel = new EventTableModel<CitEntry>(this.list, new CitEntryFormat());
        this.table = new JTable(this.tableModel);
        this.diag.add((Component)new JScrollPane(this.table), "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.add((Component)bb.getPanel(), "South");
        this.diag.pack();
        this.diag.setSize(700, 400);
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CitationManager.this.storeSettings();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(frame, Globals.lang("Problem modifying citation"));
                }
                CitationManager.this.diag.dispose();
            }
        };
        this.ok.addActionListener(okAction);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CitationManager.this.diag.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        bb.getPanel().getInputMap(2).put(Globals.prefs.getKey("Close dialog"), "close");
        bb.getPanel().getActionMap().put("close", cancelAction);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(600);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(90);
        this.table.setPreferredScrollableViewportSize(new Dimension(700, 500));
        this.table.addMouseListener(new TableClickListener());
    }

    private void storeSettings() throws Exception {
        for (CitEntry entry : this.list) {
            if (!entry.pageInfoChanged()) continue;
            this.ooBase.setCustomProperty(entry.refMarkName, entry.pageInfo);
        }
    }

    public void showDialog() {
        this.diag.setLocationRelativeTo(this.diag.getParent());
        this.diag.setVisible(true);
    }

    class SingleCitDialog {
        JDialog diag;
        JTextField pageInfo = new JTextField(20);
        JLabel title;
        JButton ok = new JButton(Globals.lang("Ok"));
        JButton cancel = new JButton(Globals.lang("Cancel"));
        CitEntry _entry;

        public SingleCitDialog(CitEntry entry) {
            this._entry = entry;
            this.title = new JLabel(entry.context);
            this.pageInfo.setText(entry.pageInfo);
            this.diag = new JDialog(CitationManager.this.diag, Globals.lang("Citation"), true);
            DefaultFormBuilder b = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, left:150dlu", ""));
            b.append((Component)this.title, 3);
            b.nextLine();
            b.append(Globals.lang("Extra information (e.g. page number)"));
            b.append(this.pageInfo);
            b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.diag.getContentPane().add((Component)b.getPanel(), "Center");
            ButtonBarBuilder bb = new ButtonBarBuilder();
            bb.addGlue();
            bb.addButton((JComponent)this.ok);
            bb.addButton((JComponent)this.cancel);
            bb.addGlue();
            bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.diag.add((Component)bb.getPanel(), "South");
            AbstractAction okAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SingleCitDialog.this._entry.pageInfo = SingleCitDialog.this.pageInfo.getText().trim().length() > 0 ? SingleCitDialog.this.pageInfo.getText().trim() : null;
                    CitationManager.this.tableModel.fireTableDataChanged();
                    SingleCitDialog.this.diag.dispose();
                }
            };
            this.ok.addActionListener(okAction);
            AbstractAction cancelAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SingleCitDialog.this.diag.dispose();
                }
            };
            this.cancel.addActionListener(cancelAction);
            b.getPanel().getInputMap(2).put(Globals.prefs.getKey("Close dialog"), "close");
            b.getPanel().getActionMap().put("close", cancelAction);
        }

        public void showDialog() {
            this.diag.pack();
            this.diag.setLocationRelativeTo(this.diag.getParent());
            this.diag.setVisible(true);
        }
    }

    class TableClickListener
    extends MouseAdapter {
        TableClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row;
            if (e.getButton() == 1 && e.getClickCount() == 2 && (row = CitationManager.this.table.rowAtPoint(e.getPoint())) >= 0) {
                SingleCitDialog scd = new SingleCitDialog((CitEntry)CitationManager.this.list.get(row));
                scd.showDialog();
            }
        }
    }

    class CitEntryFormat
    implements TableFormat<CitEntry> {
        CitEntryFormat() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int i) {
            switch (i) {
                case 0: {
                    return Globals.lang("Citation");
                }
            }
            return Globals.lang("Extra information");
        }

        @Override
        public Object getColumnValue(CitEntry citEntry, int i) {
            switch (i) {
                case 0: {
                    return citEntry.context;
                }
            }
            return citEntry.pageInfo != null ? citEntry.pageInfo : "";
        }
    }

    class CitEntry
    implements Comparable {
        String refMarkName;
        String pageInfo;
        String keyString;
        String context;
        String origPageInfo;
        List<String> keys;

        public CitEntry(String refMarkName, List<String> keys, String context, String pageInfo) {
            this.refMarkName = refMarkName;
            this.keys = keys;
            this.context = context;
            this.pageInfo = pageInfo;
            this.origPageInfo = pageInfo;
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < keys.size(); ++j) {
                sb.append(keys.get(j));
                if (j >= keys.size() - 1) continue;
                sb.append(", ");
            }
            this.keyString = sb.toString();
        }

        public boolean pageInfoChanged() {
            if (this.pageInfo != null && this.origPageInfo == null || this.pageInfo == null && this.origPageInfo != null) {
                return true;
            }
            if (this.pageInfo != null) {
                return this.pageInfo.compareTo(this.origPageInfo) != 0;
            }
            return false;
        }

        public int compareTo(Object o) {
            CitEntry other = (CitEntry)o;
            return this.refMarkName.compareTo(other.refMarkName);
        }
    }
}

