/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.integrity.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.wizard.integrity.IntegrityCheck;
import net.sf.jabref.wizard.integrity.IntegrityMessage;
import net.sf.jabref.wizard.text.gui.HintListModel;

public class IntegrityMessagePanel
extends JPanel
implements ListSelectionListener,
KeyListener,
ActionListener {
    private JList warnings;
    private HintListModel warningData;
    private IntegrityCheck validChecker;
    private JTextField content;
    private JButton applyButton;
    private JButton fixButton;
    private BasePanel basePanel;

    public IntegrityMessagePanel(BasePanel basePanel) {
        this.basePanel = basePanel;
        this.validChecker = new IntegrityCheck();
        this.warningData = new HintListModel();
        this.warnings = new JList(this.warningData);
        this.warnings.setCellRenderer(new IntegrityListRenderer());
        this.warnings.addListSelectionListener(this);
        JScrollPane paneScrollPane = new JScrollPane(this.warnings);
        paneScrollPane.setVerticalScrollBarPolicy(22);
        paneScrollPane.setPreferredSize(new Dimension(540, 255));
        paneScrollPane.setMinimumSize(new Dimension(10, 10));
        JPanel fixPanel = new JPanel();
        JLabel label1 = new JLabel(Globals.lang("Field_content"));
        this.content = new JTextField(40);
        this.content.addKeyListener(this);
        this.applyButton = new JButton(Globals.lang("Apply"));
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        this.fixButton = new JButton(Globals.lang("Suggest"));
        this.fixButton.setEnabled(false);
        fixPanel.add(label1);
        fixPanel.add(this.content);
        fixPanel.add(this.applyButton);
        fixPanel.add(this.fixButton);
        this.setLayout(new BorderLayout());
        this.add((Component)paneScrollPane, "Center");
        this.add((Component)fixPanel, "South");
    }

    public void updateView(BibtexEntry entry) {
        this.warningData.clear();
        IntegrityMessage.setPrintMode(IntegrityMessage.SINLGE_MODE);
        this.warningData.setData(this.validChecker.checkBibtexEntry(entry));
    }

    public void updateView(BibtexDatabase base) {
        this.warningData.clear();
        IntegrityMessage.setPrintMode(IntegrityMessage.FULL_MODE);
        this.warningData.setData(this.validChecker.checkBibtexDatabase(base));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            IntegrityMessage msg;
            BibtexEntry entry;
            Object obj = this.warnings.getSelectedValue();
            String str = "";
            if (obj != null && (entry = (msg = (IntegrityMessage)obj).getEntry()) != null) {
                str = entry.getField(msg.getFieldName());
                this.basePanel.highlightEntry(entry);
            }
            this.content.setText(str);
            this.applyButton.setEnabled(false);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.applyButton.setEnabled(true);
        if (e.getKeyCode() == 10) {
            this.applyButton.doClick();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.applyButton) {
            IntegrityMessage msg;
            BibtexEntry entry;
            Object data = this.warnings.getSelectedValue();
            if (data != null && (entry = (msg = (IntegrityMessage)data).getEntry()) != null) {
                String oldContent = entry.getField(msg.getFieldName());
                UndoableFieldChange edit = new UndoableFieldChange(entry, msg.getFieldName(), oldContent, this.content.getText());
                entry.setField(msg.getFieldName(), this.content.getText());
                this.basePanel.undoManager.addEdit(edit);
                this.basePanel.markBaseChanged();
                msg.setFixed(true);
                this.warningData.valueUpdated(this.warnings.getSelectedIndex());
            }
            this.applyButton.setEnabled(false);
        }
    }

    class IntegrityListRenderer
    extends DefaultListCellRenderer {
        final ImageIcon warnIcon = GUIGlobals.getImage("integrityWarn");
        final ImageIcon infoIcon = GUIGlobals.getImage("integrityInfo");
        final ImageIcon failIcon = GUIGlobals.getImage("integrityFail");
        final ImageIcon fixedIcon = GUIGlobals.getImage("complete");

        IntegrityListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean iss, boolean chf) {
            super.getListCellRendererComponent((JList<?>)list, value, index, iss, chf);
            if (value != null) {
                IntegrityMessage msg = (IntegrityMessage)value;
                if (msg.getFixed()) {
                    this.setIcon(this.fixedIcon);
                } else {
                    int id = msg.getType();
                    if (id < 1000) {
                        this.setIcon(this.infoIcon);
                    } else if (id < 2000) {
                        this.setIcon(this.warnIcon);
                    } else {
                        this.setIcon(this.failIcon);
                    }
                }
            }
            return this;
        }
    }
}

