/*
 * Decompiled with CFR 0.152.
 */
package com.projity.util;

import com.projity.pm.key.HasId;
import com.projity.server.data.DataObject;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import com.projity.util.Environment;
import java.util.Map;

public class DebugUtils {
    private static long LOW_MEMORY_LIMIT = 1000000L;

    public static void dumpStack(String string) {
        try {
            throw new Exception(string);
        }
        catch (Exception exception) {
            System.out.println(string);
            exception.printStackTrace();
            return;
        }
    }

    public static void dumpMapOfHasIdKeys(Map map) {
        for (Object k : map.keySet()) {
            String string = "" + k;
            if (k instanceof DataObject) {
                string = "" + ((DataObject)k).getUniqueId();
            } else if (k instanceof HasId) {
                string = "" + ((HasId)k).getId();
            }
            System.out.println("key=" + string + " value=" + map.get(k));
        }
    }

    public static boolean isMemoryOk(boolean bl) {
        long l = Runtime.getRuntime().freeMemory();
        System.out.println("Free Memory" + l);
        if (l < LOW_MEMORY_LIMIT) {
            System.gc();
            l = Runtime.getRuntime().freeMemory();
            if (l < LOW_MEMORY_LIMIT) {
                Environment.setOutOfMemory(true);
                if (bl) {
                    Alert.error(Messages.getString("Error.OutOfMemory"));
                }
                return false;
            }
        }
        return true;
    }
}

