/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui;

import com.pomodorotechnique.client.ui.PomodoroClientApp;
import com.pomodorotechnique.client.ui.Util;
import com.pomodorotechnique.server.UserType;
import java.awt.Frame;
import java.awt.SystemTray;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;

public class SettingsWindow
extends JDialog {
    private final Preferences prefs = Preferences.userRoot().node("pomodoroServer");
    private final UserType user;
    private JCheckBox autorunCheckBox;
    private JLabel breakLengthLabel;
    private JFormattedTextField breakLengthTextField;
    private JButton cancelButton;
    private JButton defaultsButton;
    private JLabel headerLogoLabel;
    private JPanel headerPanel;
    private JLabel headerTextLabel;
    private JRadioButton hideAllWindowsRadioButton;
    private JRadioButton hideMainWindowRadioButton;
    private JRadioButton hideNoWindowsRadioButton;
    private JLabel pomodoroLengthLabel;
    private JFormattedTextField pomodoroLengthTextField;
    private JPanel pomodoroTechniquePanel;
    private JButton saveButton;
    private JCheckBox soundsCheckBox;
    private JPanel technicalSettingsPanel;
    private ButtonGroup timerWindowButtonGroup;
    private JCheckBox updatesCheckBox;
    private BindingGroup bindingGroup;

    private void storePreferences() {
        this.user.setPomodoroLength(Integer.parseInt(this.pomodoroLengthTextField.getText()));
        this.user.setBreakLength(Integer.parseInt(this.breakLengthTextField.getText()));
        this.prefs.put("autorun", this.autorunCheckBox.isSelected() ? "Y" : "N");
        this.prefs.put("timerSounds", this.soundsCheckBox.isSelected() ? "Y" : "N");
        this.prefs.put("updatesCheck", this.updatesCheckBox.isSelected() ? "Y" : "N");
        this.prefs.put("timerWindowMode", this.hideAllWindowsRadioButton.isSelected() ? "A" : (this.hideMainWindowRadioButton.isSelected() ? "M" : "N"));
    }

    private void loadPreferences() {
        this.pomodoroLengthTextField.setText(this.user.getPomodoroLength().toString());
        this.breakLengthTextField.setText(this.user.getBreakLength().toString());
        this.autorunCheckBox.setSelected(this.prefs.get("autorun", "Y").equals("Y"));
        this.soundsCheckBox.setSelected(this.prefs.get("timerSounds", "Y").equals("Y"));
        this.updatesCheckBox.setSelected(this.prefs.get("updatesCheck", "Y").equals("Y"));
        String hideMode = SystemTray.isSupported() ? this.prefs.get("timerWindowMode", "M") : "N";
        this.timerWindowButtonGroup.setSelected(this.hideMainWindowRadioButton.getModel(), hideMode.equals("M"));
        this.timerWindowButtonGroup.setSelected(this.hideNoWindowsRadioButton.getModel(), hideMode.equals("N"));
        this.timerWindowButtonGroup.setSelected(this.hideAllWindowsRadioButton.getModel(), hideMode.equals("A"));
        if (!SystemTray.isSupported()) {
            this.hideMainWindowRadioButton.setEnabled(false);
            this.hideAllWindowsRadioButton.setEnabled(false);
        }
    }

    public SettingsWindow(Frame parent, boolean modal, UserType user) {
        super(parent, modal);
        this.user = user;
        this.initComponents();
        this.loadPreferences();
        this.getRootPane().setDefaultButton(this.saveButton);
        this.autorunCheckBox.setVisible(false);
        Util.decorate(this, true);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.timerWindowButtonGroup = new ButtonGroup();
        this.headerPanel = new JPanel();
        this.headerTextLabel = new JLabel();
        this.headerLogoLabel = new JLabel();
        this.pomodoroTechniquePanel = new JPanel();
        this.pomodoroLengthLabel = new JLabel();
        this.breakLengthLabel = new JLabel();
        this.pomodoroLengthTextField = new JFormattedTextField();
        this.breakLengthTextField = new JFormattedTextField();
        this.technicalSettingsPanel = new JPanel();
        this.autorunCheckBox = new JCheckBox();
        this.soundsCheckBox = new JCheckBox();
        this.hideMainWindowRadioButton = new JRadioButton();
        this.hideAllWindowsRadioButton = new JRadioButton();
        this.hideNoWindowsRadioButton = new JRadioButton();
        this.updatesCheckBox = new JCheckBox();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.defaultsButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(PomodoroClientApp.class).getContext().getResourceMap(SettingsWindow.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.headerPanel.setBackground(resourceMap.getColor("headerPanel.background"));
        this.headerPanel.setBorder(BorderFactory.createLineBorder(resourceMap.getColor("headerPanel.border.lineColor")));
        this.headerPanel.setName("headerPanel");
        this.headerTextLabel.setFont(this.headerTextLabel.getFont().deriveFont((float)this.headerTextLabel.getFont().getSize() + 7.0f));
        this.headerTextLabel.setText(resourceMap.getString("headerTextLabel.text", new Object[0]));
        this.headerTextLabel.setName("headerTextLabel");
        this.headerLogoLabel.setIcon(resourceMap.getIcon("headerLogoLabel.icon"));
        this.headerLogoLabel.setName("headerLogoLabel");
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, headerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.headerTextLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerLogoLabel)));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerLogoLabel).addComponent(this.headerTextLabel, -1, 68, Short.MAX_VALUE));
        this.pomodoroTechniquePanel.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("pomodoroTechniquePanel.border.title", new Object[0])));
        this.pomodoroTechniquePanel.setName("pomodoroTechniquePanel");
        this.pomodoroLengthLabel.setText(resourceMap.getString("pomodoroLengthLabel.text", new Object[0]));
        this.pomodoroLengthLabel.setName("pomodoroLengthLabel");
        this.breakLengthLabel.setText(resourceMap.getString("breakLengthLabel.text", new Object[0]));
        this.breakLengthLabel.setName("breakLengthLabel");
        this.pomodoroLengthTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.pomodoroLengthTextField.setText(resourceMap.getString("pomodoroLengthTextField.text", new Object[0]));
        this.pomodoroLengthTextField.setName("pomodoroLengthTextField");
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.saveButton, ELProperty.create("${action}"), this.pomodoroLengthTextField, BeanProperty.create("action"));
        this.bindingGroup.addBinding(binding);
        this.breakLengthTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.breakLengthTextField.setText(resourceMap.getString("breakLengthTextField.text", new Object[0]));
        this.breakLengthTextField.setName("breakLengthTextField");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.saveButton, ELProperty.create("${action}"), this.breakLengthTextField, BeanProperty.create("action"));
        this.bindingGroup.addBinding(binding);
        GroupLayout pomodoroTechniquePanelLayout = new GroupLayout(this.pomodoroTechniquePanel);
        this.pomodoroTechniquePanel.setLayout(pomodoroTechniquePanelLayout);
        pomodoroTechniquePanelLayout.setHorizontalGroup(pomodoroTechniquePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pomodoroTechniquePanelLayout.createSequentialGroup().addContainerGap().addGroup(pomodoroTechniquePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pomodoroLengthLabel).addComponent(this.breakLengthLabel)).addGap(18, 18, 18).addGroup(pomodoroTechniquePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.breakLengthTextField, -2, 36, -2).addComponent(this.pomodoroLengthTextField, -2, 36, -2)).addContainerGap(79, Short.MAX_VALUE)));
        pomodoroTechniquePanelLayout.setVerticalGroup(pomodoroTechniquePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pomodoroTechniquePanelLayout.createSequentialGroup().addContainerGap().addGroup(pomodoroTechniquePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pomodoroLengthLabel).addComponent(this.pomodoroLengthTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pomodoroTechniquePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.breakLengthLabel).addComponent(this.breakLengthTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.technicalSettingsPanel.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("technicalSettingsPanel.border.title", new Object[0])));
        this.technicalSettingsPanel.setName("technicalSettingsPanel");
        this.autorunCheckBox.setSelected(true);
        this.autorunCheckBox.setText(resourceMap.getString("autorunCheckBox.text", new Object[0]));
        this.autorunCheckBox.setName("autorunCheckBox");
        this.soundsCheckBox.setSelected(true);
        this.soundsCheckBox.setText(resourceMap.getString("soundsCheckBox.text", new Object[0]));
        this.soundsCheckBox.setName("soundsCheckBox");
        this.timerWindowButtonGroup.add(this.hideMainWindowRadioButton);
        this.hideMainWindowRadioButton.setSelected(true);
        this.hideMainWindowRadioButton.setText(resourceMap.getString("hideMainWindowRadioButton.text", new Object[0]));
        this.hideMainWindowRadioButton.setName("hideMainWindowRadioButton");
        this.timerWindowButtonGroup.add(this.hideAllWindowsRadioButton);
        this.hideAllWindowsRadioButton.setText(resourceMap.getString("hideAllWindowsRadioButton.text", new Object[0]));
        this.hideAllWindowsRadioButton.setName("hideAllWindowsRadioButton");
        this.timerWindowButtonGroup.add(this.hideNoWindowsRadioButton);
        this.hideNoWindowsRadioButton.setText(resourceMap.getString("hideNoWindowsRadioButton.text", new Object[0]));
        this.hideNoWindowsRadioButton.setName("hideNoWindowsRadioButton");
        this.updatesCheckBox.setSelected(true);
        this.updatesCheckBox.setText(resourceMap.getString("updatesCheckBox.text", new Object[0]));
        this.updatesCheckBox.setName("updatesCheckBox");
        GroupLayout technicalSettingsPanelLayout = new GroupLayout(this.technicalSettingsPanel);
        this.technicalSettingsPanel.setLayout(technicalSettingsPanelLayout);
        technicalSettingsPanelLayout.setHorizontalGroup(technicalSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(technicalSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(technicalSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autorunCheckBox).addComponent(this.soundsCheckBox).addComponent(this.updatesCheckBox).addComponent(this.hideMainWindowRadioButton).addComponent(this.hideAllWindowsRadioButton).addComponent(this.hideNoWindowsRadioButton)).addContainerGap(18, Short.MAX_VALUE)));
        technicalSettingsPanelLayout.setVerticalGroup(technicalSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(technicalSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.autorunCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.soundsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.updatesCheckBox).addGap(18, 18, 18).addComponent(this.hideMainWindowRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAllWindowsRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideNoWindowsRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        ApplicationActionMap actionMap = Application.getInstance(PomodoroClientApp.class).getContext().getActionMap(SettingsWindow.class, this);
        this.saveButton.setAction(actionMap.get("save"));
        this.saveButton.setText(resourceMap.getString("saveButton.text", new Object[0]));
        this.saveButton.setName("saveButton");
        this.cancelButton.setText(resourceMap.getString("cancelButton.text", new Object[0]));
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.cancelButtonActionPerformed(evt);
            }
        });
        this.defaultsButton.setText(resourceMap.getString("defaultsButton.text", new Object[0]));
        this.defaultsButton.setName("defaultsButton");
        this.defaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.defaultsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.technicalSettingsPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.pomodoroTechniquePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.headerPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 98, Short.MAX_VALUE).addComponent(this.defaultsButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.headerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pomodoroTechniquePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.technicalSettingsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton).addComponent(this.cancelButton).addComponent(this.defaultsButton)).addContainerGap()));
        this.bindingGroup.bind();
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        this.autorunCheckBox.setSelected(true);
        this.soundsCheckBox.setSelected(true);
        this.updatesCheckBox.setSelected(true);
        this.breakLengthTextField.setValue(5);
        this.pomodoroLengthTextField.setValue(25);
        this.hideAllWindowsRadioButton.setSelected(false);
        this.hideMainWindowRadioButton.setSelected(true);
        this.hideNoWindowsRadioButton.setSelected(false);
    }

    @Action
    public void save() {
        this.storePreferences();
        this.setVisible(false);
    }
}

