/*
 * Copyright (C) 2004, 2005 Valery Reznic
 * This file is part of the Elf Statifier project
 * 
 * This project is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * See LICENSE file in the doc directory.
 *
 * Include file for all .S sources.
 * And MY_ORG macro needed to be used in order
 * to align code to the REGISTER_SIZE boundary.
 * Otherwise gcc (at least gcc 2.95.3)
 * will add bytes to the end of the file.
 * It is not good, so I do it by myself where I need it
 *
 *
 * Idea is following:
 *    I need move addr to the multiple by REGISTER_SIZE.
 *    (. % REGISTER_SIZE) - how many spare bytes we have
 *    (REGISTER_SIZE - (. % REGISTER_SIZE)) - how many bytes 
 *					     we need to add in order to
 *                                            be multiplly by REGISTER_SIZE
 *    ((REGISTER_SIZE - (. % REGISTER_SIZE )) % REGISTER_SIZE) - 
 *                                                in case . was alignment avoid 
 *                                                adding REGISTER_SIZE bytes
 */

MY_DATA NEXT_CODE
	MY_JUMP	data + NEXT_CODE
	/* .org . + ((REGISTER_SIZE - (. % REGISTER_SIZE )) % REGISTER_SIZE) */
	/* 
	 * Now I use 16 instead of REGISTER_SIZE.
	 * The reason is following:
	 * Part of my asm code include another asm file, generated by gcc
	 * from .c 
	 * In asm generated by gcc (at least i386) there are .p2align 4,,7
	 * directives.
	 * After using this directive gcc (at least 2.95.3) adjust file not
	 * to the register_size boundary but to 16 boundary.
  	 * Also as gcc's man say, that 16 is maximum alignment. So, i use it.
	 */
	.org . + ((16 - (. % 16 )) % 16)
data:

