/***************************************************************************
    File                 : Correlation.h
    Project              : AlphaPlot
    --------------------------------------------------------------------
    Copyright            : (C) 2007 by Ion Vasilief
    Email (use @ for *)  : ion_vasilief*yahoo.fr
    Description          : Numerical correlation of data sets

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor,                    *
 *   Boston, MA  02110-1301  USA                                           *
 *                                                                         *
 ***************************************************************************/
#ifndef CORRELATION_H
#define CORRELATION_H

#include "Filter.h"

class Correlation : public Filter {
  Q_OBJECT

 public:
  Correlation(ApplicationWindow* parent, Table* t, const QString& colName1,
              const QString& colName2);

  void setDataFromTable(Table* t, const QString& colName1,
                        const QString& colName2);

 protected:
  //! Handles the graphical output
  void addResultCurve();

 private:
  virtual void output();
};

#endif  // CORRELATION_H
