/*
 * Decompiled with CFR 0.152.
 */
package data2fcs;

import data2fcs.Source;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class Converter
implements ActionListener,
WindowListener {
    private Source theSource;
    private JDialog theGui;
    private JScrollPane theLineScroller;
    private JTable theLines;
    private final String OK = "Convert";
    private final String EXIT = "Exit";
    private final String HEADER = "Use first line as parameter name";
    private final String TAB = "TAB";
    private final String COMMA = ",";
    private final String SEMI = ";";
    private final String SPACE = "SPACE";
    private final String DECIMAL_COMMA = ",,";
    private final String DECIMAL_PERIOD = ".";
    private JButton OK_Button = new JButton("Convert");
    private JButton EXIT_Button = new JButton("Exit");
    private JCheckBox headerCheckbox = new JCheckBox("Use first line as parameter name");
    private JRadioButton sepTab = new JRadioButton("TAB");
    private JRadioButton sepComma = new JRadioButton(",");
    private JRadioButton sepSemi = new JRadioButton(";");
    private JRadioButton sepSpace = new JRadioButton("SPACE");
    private JRadioButton decimalIndicatorPeriod = new JRadioButton(".");
    private JRadioButton decimalIndicatorComma = new JRadioButton(",");

    public Converter(File toConvert, String version) throws FileNotFoundException {
        this.theGui = new JDialog();
        this.theGui.setTitle("Data2FCS " + version);
        this.theGui.setModal(true);
        this.theGui.setDefaultCloseOperation(1);
        this.theGui.addWindowListener(this);
        this.theGui.setLocationByPlatform(true);
        this.theGui.setSize(800, 600);
        this.theGui.setLayout(new BorderLayout());
        this.OK_Button.setActionCommand("Convert");
        this.OK_Button.addActionListener(this);
        this.EXIT_Button.setActionCommand("Exit");
        this.EXIT_Button.addActionListener(this);
        JPanel buttonPane = new JPanel();
        buttonPane.add(this.OK_Button);
        buttonPane.add(this.EXIT_Button);
        this.theGui.add((Component)buttonPane, "South");
        JPanel optionPane = new JPanel();
        BoxLayout boxL = new BoxLayout(optionPane, 1);
        optionPane.setLayout(boxL);
        this.headerCheckbox.setAlignmentX(0.0f);
        this.headerCheckbox.setActionCommand("Use first line as parameter name");
        this.headerCheckbox.addActionListener(this);
        optionPane.add(this.headerCheckbox);
        ButtonGroup separators = new ButtonGroup();
        this.sepTab.setActionCommand("TAB");
        this.sepComma.setActionCommand(",");
        this.sepSemi.setActionCommand(";");
        this.sepSpace.setActionCommand("SPACE");
        this.sepTab.setAlignmentX(0.0f);
        separators.add(this.sepTab);
        this.sepSpace.setAlignmentX(0.0f);
        separators.add(this.sepSpace);
        this.sepComma.setAlignmentX(0.0f);
        separators.add(this.sepComma);
        this.sepSemi.setAlignmentX(0.0f);
        separators.add(this.sepSemi);
        this.sepTab.setSelected(true);
        this.sepTab.addActionListener(this);
        this.sepComma.addActionListener(this);
        this.sepSemi.addActionListener(this);
        this.sepSpace.addActionListener(this);
        JPanel sepPanels = new JPanel();
        JLabel l = new JLabel("Parameter separator: ");
        l.setAlignmentX(0.0f);
        sepPanels.add(l);
        sepPanels.add(this.sepTab);
        sepPanels.add(this.sepSpace);
        sepPanels.add(this.sepComma);
        sepPanels.add(this.sepSemi);
        sepPanels.setAlignmentX(0.0f);
        sepPanels.setMaximumSize(sepPanels.getPreferredSize());
        optionPane.add(sepPanels);
        ButtonGroup commators = new ButtonGroup();
        commators.add(this.decimalIndicatorPeriod);
        commators.add(this.decimalIndicatorComma);
        this.decimalIndicatorPeriod.setSelected(true);
        JPanel decimalPanels = new JPanel();
        decimalPanels.add(new JLabel("Decimal point indicator: "));
        this.decimalIndicatorPeriod.setActionCommand(".");
        this.decimalIndicatorComma.setActionCommand(",,");
        this.decimalIndicatorPeriod.addActionListener(this);
        this.decimalIndicatorComma.addActionListener(this);
        decimalPanels.add(this.decimalIndicatorPeriod);
        decimalPanels.add(this.decimalIndicatorComma);
        decimalPanels.setAlignmentX(0.0f);
        decimalPanels.setMaximumSize(decimalPanels.getPreferredSize());
        optionPane.add(decimalPanels);
        this.theGui.add((Component)optionPane, "North");
        this.theSource = new Source(toConvert, "\t", this);
        this.theLines = new JTable(this.theSource);
        this.theSource.setRegulars(this.theLines.getDefaultEditor(String.class), this.theLines.getDefaultRenderer(String.class), this.theLines.getDefaultEditor(Boolean.class), this.theLines.getDefaultRenderer(Boolean.class));
        this.theLines.setDefaultEditor(String.class, this.theSource);
        this.theLines.setDefaultRenderer(String.class, this.theSource);
        this.theLines.setAutoResizeMode(0);
        this.theLineScroller = new JScrollPane(this.theLines);
        this.theGui.add((Component)this.theLineScroller, "Center");
        optionPane.add(this.theSource.theProgressBar);
    }

    public void show() {
        this.theGui.setVisible(true);
    }

    public void setHasHeader() {
        this.headerCheckbox.setSelected(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand == "Use first line as parameter name") {
            this.theSource.setHasHeader(this.headerCheckbox.isSelected());
        }
        if (actionCommand == "Exit") {
            this.theGui.dispose();
            this.theSource.dispose();
            System.exit(0);
        }
        if (actionCommand == "TAB") {
            this.theSource.setSeparator("\t");
        }
        if (actionCommand == "SPACE") {
            this.theSource.setSeparator(" ");
        }
        if (actionCommand == ",") {
            this.theSource.setSeparator(",");
        }
        if (actionCommand == ";") {
            this.theSource.setSeparator(";");
        }
        if (actionCommand == ",,") {
            this.theSource.setUseDecimalPeriod(false);
        }
        if (actionCommand == ".") {
            this.theSource.setUseDecimalPeriod(true);
        }
        if (actionCommand == "Convert") {
            JFileChooser jF = new JFileChooser();
            jF.setApproveButtonText("Save");
            jF.setFileSelectionMode(0);
            jF.setDialogType(1);
            jF.setDialogTitle("Save converted file as ...");
            jF.setMultiSelectionEnabled(false);
            jF.showSaveDialog(null);
            File selectedFile = jF.getSelectedFile();
            if (selectedFile != null) {
                boolean success = true;
                if (selectedFile.exists()) {
                    int confirm = JOptionPane.showConfirmDialog(null, "File already exists! Overwrite?", "File already exists.", 2, 2);
                    if (confirm == 0) {
                        try {
                            this.theSource.convert(selectedFile);
                        }
                        catch (IOException ip) {
                            success = false;
                            JOptionPane.showMessageDialog(null, "There was an error during file generation!", "File error!", 0);
                        }
                    } else {
                        success = false;
                    }
                } else {
                    try {
                        this.theSource.convert(selectedFile);
                    }
                    catch (IOException ip) {
                        success = false;
                        JOptionPane.showMessageDialog(null, "There was an error during file generation!", "File error!", 0);
                    }
                }
                if (success) {
                    JOptionPane.showMessageDialog(null, "Conversion completed", "Success", 1);
                }
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.theGui.dispose();
        this.theSource.dispose();
        System.exit(0);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.theGui.dispose();
        this.theSource.dispose();
        System.exit(0);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

