/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2019-2020 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::genericPatchField

Description

SourceFiles
    genericPatchField.C

\*---------------------------------------------------------------------------*/

#ifndef genericPatchField_H
#define genericPatchField_H

#include "typeInfo.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                       Class genericFvPatch Declaration
\*---------------------------------------------------------------------------*/

class genericPatchField
{
    // Private Data

        word actualTypeName_;

public:

    //- Runtime type information
    TypeName("generic");


    // Constructors

        genericPatchField()
        {}

        genericPatchField(const word& atn)
        :
            actualTypeName_(atn)
        {}


    //- Destructor
    virtual ~genericPatchField()
    {}


    // Member Functions

        //- Return the actual type name
        word actualTypeName() const
        {
            return actualTypeName_;
        }
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
