/*
 * main.c
 * Copyright (C) Michael Heras 2018 <userxbw@gmail.com>
 *
        wmslides is free software: you can redistribute it and/or modify it
        under the terms of the GNU General Public License as published by the
        Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        wmslides is distributed in the hope that it will be useful, but
        WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
        See the GNU General Public License for more details.

        You should have received a copy of the GNU General Public License along
        with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/timeb.h>
#include <X11/X.h>
#include <X11/xpm.h>
#include <X11/Xlib.h>
#include <Imlib2.h>

#include "wmgeneral.h"
#include "pixmaps.h"
#include "filelist.h"

#define VERSION "1.0"

char *path;
int isize=64;
int dtime = 0;
int random_flag = 0;

static void usage(char * pname)
{
    printf("%s version: %s\n"
    "By Michael Heras <userxbw@gmail.com>\n\n"
    "\t-r, --random\t\t\t shows images in random order.\n"
    "\t-p, --path [path to images]\t images to be displayed.\n"
    "\t-t, --time [nseconds]\t delay time between images.\n"
    "Default time is 5 minutes.\n\n"
    "\nie:\n%s -t 30 -p /path/to/images\n", pname,VERSION, pname);
}

static void ParseCMDLine(int argc, char *argv[])
{
   int i = 0;

    for (i=1; i < argc; i++)
    {
        if ( ((!strcmp(argv[i], "--path")) || (!strcmp(argv[i], "-p"))) && (i+1 < argc) )
        {
            path = argv[++i];
        }
        else if ( ((!strcmp(argv[i], "--time")) || (!strcmp(argv[i], "-t"))) && (i+1 < argc) )
        {
            dtime = atoi(argv[++i]);
        }
        else if ( ((!strcmp(argv[i], "--random")) || (!strcmp(argv[i], "-r"))))
        {
            random_flag = 1;
        }
        else
        {
            usage(argv[0]);
            exit(1);
        }
    }
    if ((argc < 3) )
    {
        usage(argv[0]);
        exit(1);
    }
}
void load_image(Imlib_Image image, Visual *visual,  Pixmap xpm, Window iconwin)
{
    visual = DefaultVisual(display, DefaultScreen(display));

    imlib_context_set_dither(1);
    imlib_context_set_display(display);
    imlib_context_set_visual(visual);

    image = imlib_load_image(get_file_name());

    imlib_context_set_image(image);
    imlib_context_set_drawable(xpm);
    imlib_render_image_on_drawable_at_size(0, 0, isize, isize);
    imlib_free_image();
    XSetWindowBackgroundPixmap (display, iconwin, xpm);
    XClearWindow (display,iconwin);
    XFlush (display);
    XSync (display, False);
}
int main(int argc, char *argv[])
{
    extern int d_depth;
    extern Window iconwin, win;
    Visual *visual = NULL;
    Pixmap xpm;
    Imlib_Image image = NULL;

    ParseCMDLine(argc, argv);
    add_file_to_filelist_recursively(path, FILELIST_FIRST);

    openXwindow(argc, argv, xpm_master, xpm_mask_bits, xpm_mask_width, xpm_mask_height);

    xpm = XCreatePixmap(display, win, 64, 64, d_depth);
    XFillRectangle(display, xpm, NormalGC, 0, 0, 64, 64);
    if (dtime == 0 )
    {
        dtime = 300;
    }
    if ( random_flag == 1)
    {
        prepare_filelist();
    }
    //load first image
    load_image(image, visual,xpm, iconwin);
    
    while (!sleep(dtime))
    {
        load_image(image, visual,xpm, iconwin);
    }
    //should never reach here
    return (0);
}
